/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.file;

import com.nokia.mj.impl.file.FileAccessHelper;
import com.nokia.mj.impl.file.FileLogger;
import com.nokia.mj.impl.security.common.PermissionBase;
import com.nokia.mj.impl.security.utils.SecurityPromptMessage;
import java.security.Permission;
import java.security.PermissionCollection;

public class FileInternalPermission
extends PermissionBase {
    private String targetName;
    private String intent;

    public FileInternalPermission(String aUri) {
        this(aUri, "read");
    }

    public FileInternalPermission(String aUri, String aActions) {
        super(aUri);
        this.targetName = aUri;
        this.intent = aActions;
    }

    public boolean implies(Permission aPermission) {
        if (aPermission instanceof FileInternalPermission) {
            FileInternalPermission per = (FileInternalPermission)aPermission;
            if (PermissionBase.matchActions(per.getActions(), this.intent)) {
                if (this.getTarget().equals("*")) {
                    return true;
                }
                if (this.targetName.equalsIgnoreCase(per.getTarget())) {
                    return true;
                }
                return this.getCategory().equals(per.getCategory());
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return "javax.microedition.io.FileProtocolPermission";
    }

    public String getSecurityPromptQuestion() {
        if (this.intent.equals("read")) {
            if (this.targetName.equals("")) {
                return SecurityPromptMessage.getInstance().getText("reading_user_data", new String[]{this.targetName});
            }
            return SecurityPromptMessage.getInstance().getText("reading_file", new String[]{this.targetName});
        }
        if (this.intent.equals("write")) {
            if (this.targetName.equals("")) {
                return SecurityPromptMessage.getInstance().getText("writing_user_data", new String[]{this.targetName});
            }
            return SecurityPromptMessage.getInstance().getText("modifying_file", new String[]{this.targetName});
        }
        FileLogger.ELog("FileInternalPermission: getSecurityPromptQuestion: Invalid security intent presented: " + this.intent + " for target: " + this.targetName);
        return null;
    }

    public String getCategory() {
        return FileAccessHelper.getCategory(this.targetName);
    }

    public String getTarget() {
        return this.targetName;
    }

    public boolean equals(Object obj) {
        return true;
    }

    public int hashCode() {
        return 0;
    }

    public String getActions() {
        return this.intent;
    }

    public PermissionCollection newPermissionCollection() {
        return null;
    }
}

