/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.file;

import com.nokia.mj.impl.file.FileLogger;
import com.nokia.mj.impl.file.FileSystemUtils;
import java.io.IOException;
import java.util.Vector;

final class FileUrlValidator {
    private static String FILE_LOCALHOST = "file://localhost/";
    private static String FILE_SIMPLE = "file:///";

    FileUrlValidator() {
    }

    public static String validateFileUrl(String aFileUrl) throws IOException {
        String path = aFileUrl;
        if (aFileUrl.startsWith(FILE_LOCALHOST)) {
            path = aFileUrl.substring(FILE_LOCALHOST.length());
        } else if (aFileUrl.startsWith(FILE_SIMPLE)) {
            path = aFileUrl.substring(FILE_SIMPLE.length());
        } else {
            throw new IOException("Improper URL Start");
        }
        if (path.length() < 3) {
            throw new IllegalArgumentException("Invalid Uri: " + aFileUrl);
        }
        FileUrlValidator.checkPathStart(path);
        if (aFileUrl.length() > 256) {
            throw new IllegalArgumentException("Invalid Uri: " + aFileUrl);
        }
        return path;
    }

    private static void checkPathStart(String aFilePath) throws IOException {
        FileLogger.Log("FileUrlValidator.checkPathStart: " + aFilePath);
        Vector roots = FileSystemUtils.listRoots();
        boolean validPath = false;
        for (int i = 0; i < roots.size(); ++i) {
            if (!aFilePath.startsWith((String)roots.elementAt(i)) && !aFilePath.toLowerCase().startsWith(((String)roots.elementAt(i)).toLowerCase())) continue;
            validPath = true;
            break;
        }
        if (!validPath) {
            throw new IOException("Invalid Uri");
        }
    }
}

