/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.fileutils;

import com.nokia.mj.impl.fileutils.FilePlatformSpecifics;
import com.nokia.mj.impl.fileutils.FileUtility;
import java.io.IOException;

public final class FileOperations {
    public static boolean copy(String aSourceFile, String aDestFile, boolean aOverWrite) throws IOException {
        FileUtility source = new FileUtility(aSourceFile);
        if (!source.exists()) {
            throw new IOException("Source not present: " + source);
        }
        if (!source.isFile()) {
            throw new IOException("Source not a file: " + source);
        }
        FileUtility destination = new FileUtility(aDestFile);
        if (destination.exists() && destination.isDirectory()) {
            throw new IOException("Destination is a directory: " + destination);
        }
        try {
            return FilePlatformSpecifics.copy(aSourceFile, aDestFile, aOverWrite);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean move(String aSourceFile, String aDestFile, boolean aOverWrite) throws IOException {
        FileUtility source = new FileUtility(aSourceFile);
        FileUtility destination = new FileUtility(aDestFile);
        if (!source.exists()) {
            throw new IOException("Source not present: " + source);
        }
        if (destination.exists()) {
            if (destination.isDirectory()) {
                throw new IOException("Destination is a directory: " + source);
            }
            if (!aOverWrite) {
                throw new IOException("Destination already present: " + source);
            }
        }
        return FilePlatformSpecifics.move(aSourceFile, aDestFile, aOverWrite);
    }

    public static boolean copyAll(String aSourceDir, String aDestDir, boolean aOverWrite) throws IOException {
        FileUtility source = new FileUtility(aSourceDir);
        FileUtility destination = new FileUtility(aDestDir);
        if (!source.exists()) {
            throw new IOException("Source not present: " + source);
        }
        if (!source.isDirectory()) {
            throw new IOException("Source not a directory: " + source);
        }
        if (!aOverWrite && destination.exists()) {
            return false;
        }
        try {
            boolean retVal = FilePlatformSpecifics.copyAll(aSourceDir, aDestDir, aOverWrite);
            return retVal;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean deleteAll(String aTargetDir) throws IOException {
        FileUtility source = new FileUtility(aTargetDir);
        if (!source.exists()) {
            throw new IOException("Path specified does not exist: " + source);
        }
        if (!source.isDirectory()) {
            throw new IOException("Source not a directory: " + source);
        }
        try {
            return FilePlatformSpecifics.deleteAll(aTargetDir);
        }
        catch (Exception e) {
            return false;
        }
    }
}

