/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.gcf.protocol.datagram;

import com.nokia.mj.impl.gcf.PushValidator;
import com.nokia.mj.impl.gcf.protocol.datagram.DatagramPermissionImpl;
import com.nokia.mj.impl.gcf.utils.UrlParser;
import com.nokia.mj.impl.rt.support.ApplicationUtils;
import com.nokia.mj.impl.utils.Logger;
import com.nokia.mj.impl.utils.Uid;

public class PushValidatorImpl
extends PushValidator {
    private static final String DATAGRAM_PREFIX = "datagram://:";

    public void validate(String aUri, String aFilter, Uid aSuiteUid, String aMidletName, boolean aIsStaticRegistration) {
        char ch;
        boolean flag = aUri.startsWith(DATAGRAM_PREFIX);
        Logger.LOG(14, 4, "+datagram - push validator");
        if (!flag) {
            throw new IllegalArgumentException("Invalid URL: " + aUri);
        }
        String portNumStr = null;
        int startIndex = DATAGRAM_PREFIX.length();
        int endIndex = aUri.length();
        if (endIndex > startIndex) {
            portNumStr = aUri.substring(startIndex, endIndex);
            try {
                Integer.parseInt(portNumStr);
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException("Invalid URL: " + aUri);
            }
        }
        if (aFilter == null) {
            throw new IllegalArgumentException("Invalid filter: " + aFilter);
        }
        if (aFilter == "") {
            throw new IllegalArgumentException("Invalid filter: " + aFilter);
        }
        if (aFilter.length() == 1) {
            ch = aFilter.charAt(0);
            if (ch != '*' && ch != '?') {
                throw new IllegalArgumentException("Invalid filter: " + aFilter);
            }
        } else {
            for (int i = 0; i < aFilter.length(); ++i) {
                char val = ch = aFilter.charAt(i);
                if (ch == '?' || ch == '*' || ch == '.' || ch == ':' || ch == '[' || ch == ']' || val >= '0' && val <= '9' || val >= 'a' && val <= 'f' || val >= 'A' && val <= 'F') continue;
                Logger.LOG(14, 4, "Invalid filter argument");
                throw new IllegalArgumentException("Invalid filter: " + aFilter);
            }
        }
        String url1 = "datagram://" + aFilter;
        Logger.LOG(14, 4, "Socket PushValidator - after appending url = " + url1);
        UrlParser url2 = new UrlParser(url1);
        Logger.LOG(14, 4, "datagram - push validator : before security check");
        ApplicationUtils appUtils = ApplicationUtils.getInstance();
        DatagramPermissionImpl per = new DatagramPermissionImpl("datagram://");
        appUtils.checkPermission(per);
        Logger.LOG(14, 4, "datagram - push validator : after security check");
    }
}

