/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.gcf.protocol.sms;

import com.nokia.mj.impl.gcf.PushValidator;
import com.nokia.mj.impl.rt.support.ApplicationUtils;
import com.nokia.mj.impl.sms.SMSPermissionImpl;
import com.nokia.mj.impl.utils.Uid;

public class PushValidatorImpl
extends PushValidator {
    private final int MAX_PORT = 65535;
    private static final String SMS_PREFIX = "sms://:";
    private final String INVALID_URI = "Invalid Uri";
    private final String INVALID_FILTER = "Invalid Filter";

    public void validate(String aUri, String aFilter, Uid aSuiteUid, String aMidletName, boolean aIsStaticRegistration) {
        boolean flag = aUri.startsWith(SMS_PREFIX);
        if (!flag) {
            throw new IllegalArgumentException("Invalid Uri");
        }
        String port = aUri.substring(SMS_PREFIX.length());
        int smsPort = 0;
        try {
            smsPort = Integer.parseInt(port);
        }
        catch (NumberFormatException exp) {
            throw new IllegalArgumentException("Invalid Uri");
        }
        if (smsPort > 65535 || smsPort < 0) {
            throw new IllegalArgumentException("Invalid Port:" + smsPort);
        }
        for (int i = 0; i < aFilter.length(); ++i) {
            char ch = aFilter.charAt(i);
            if (i == 0 && ch == '+' || Character.isDigit(ch) || ch == '*' || ch == '?') continue;
            throw new IllegalArgumentException("Invalid Filter");
        }
        ApplicationUtils appUtils = ApplicationUtils.getInstance();
        SMSPermissionImpl permission = new SMSPermissionImpl("sms://*", "open");
        appUtils.checkPermission(permission);
    }
}

