/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.installer.ui.eswt;

import com.nokia.mj.impl.installer.ui.InstallInfo;
import com.nokia.mj.impl.installer.ui.InstallerUiTexts;
import com.nokia.mj.impl.installer.ui.eswt.ConfirmationViewBase;
import com.nokia.mj.impl.security.midp.common.SigningCertificate;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class CertificateDetailsView
extends ConfirmationViewBase {
    private InstallInfo iInstallInfo = null;
    private int iCertIndex = 0;

    protected CertificateDetailsView() {
    }

    protected CertificateDetailsView(Composite aParent, String aTitle, InstallInfo aInstallInfo, int aCertIndex) {
        super(aParent, 1);
        this.iInstallInfo = aInstallInfo;
        this.iCertIndex = aCertIndex;
        this.setTitle(aTitle);
        this.setCommands(null, InstallerUiTexts.get("back"));
    }

    protected void createView() {
        int horizontalSpan = this.getColumns();
        int labelStyle = 64;
        Label detailsLabel = this.createLabel(InstallerUiTexts.get("cert_details_title"), horizontalSpan, labelStyle);
        detailsLabel.setFont(this.getBoldFont());
        SigningCertificate certificate = this.iInstallInfo.getCertificates()[this.iCertIndex];
        Label domainLabel = this.createLabel(InstallerUiTexts.get("cert_details_domain", new String[]{this.getDomainCategoryString(certificate)}), horizontalSpan, labelStyle);
        Label issuerLabel = this.createLabel(InstallerUiTexts.get("cert_details_issuer", new String[]{certificate.getFormattedIssuer()}), horizontalSpan, labelStyle);
        Label subjectLabel = this.createLabel(InstallerUiTexts.get("cert_details_subject", new String[]{certificate.getFormattedSubject()}), horizontalSpan, labelStyle);
        Label validFromLabel = this.createLabel(InstallerUiTexts.get("cert_details_valid_from", new Object[]{certificate.getValidFrom()}), horizontalSpan, labelStyle);
        Label validUntilLabel = this.createLabel(InstallerUiTexts.get("cert_details_valid_until", new Object[]{certificate.getValidUntil()}), horizontalSpan, labelStyle);
        Label serialNumberLabel = this.createLabel(InstallerUiTexts.get("cert_details_serial_number", new String[]{certificate.getSerialNumber()}), horizontalSpan, labelStyle);
        Label fingerprintLabel = this.createLabel(InstallerUiTexts.get("cert_details_fingerprint", new String[]{certificate.getFormattedFingerprint()}), horizontalSpan, labelStyle);
    }

    protected void getDataFromView() {
    }

    protected int getStyle() {
        return 512;
    }

    private String getDomainCategoryString(SigningCertificate aCertificate) {
        String result = "";
        String domainCategory = aCertificate.getProtectionDomain().getCategory();
        if (domainCategory.equals("MFD")) {
            result = InstallerUiTexts.get("cert_details_domain_manufacturer");
        } else if (domainCategory.equals("OPD")) {
            result = InstallerUiTexts.get("cert_details_domain_operator");
        } else if (domainCategory.equals("ITPD")) {
            result = InstallerUiTexts.get("cert_details_domain_trusted_third_party");
        } else if (domainCategory.equals("UTPD")) {
            result = InstallerUiTexts.get("cert_details_domain_untrusted_third_party");
        }
        return result;
    }
}

