/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.installer.ui.eswt;

import com.nokia.mj.impl.installer.ui.InstallerUiTexts;
import com.nokia.mj.impl.installer.ui.eswt.ViewBase;
import org.eclipse.ercp.swt.mobile.Command;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public abstract class ConfirmationViewBase
extends ViewBase {
    private Command iOkCommand = null;
    private Command iCancelCommand = null;
    private String iOkText = InstallerUiTexts.get("ok");
    private String iCancelText = InstallerUiTexts.get("cancel");
    private boolean iCancelled = false;
    private boolean iUserHasAnswered = false;
    private Object iSynchObject = new Object();

    protected ConfirmationViewBase() {
    }

    protected ConfirmationViewBase(Composite aParent, int aColumns) {
        super(aParent, aColumns);
    }

    public void setCommands(String aOkText, String aCancelText) {
        this.iOkText = aOkText;
        this.iCancelText = aCancelText;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean confirm() {
        if (this.isDisposed()) {
            return false;
        }
        this.getComposite().getDisplay().syncExec(new Runnable(){

            public void run() {
                if (ConfirmationViewBase.this.iOkCommand == null && ConfirmationViewBase.this.iCancelCommand == null) {
                    ConfirmationViewBase.this.createView();
                    ConfirmationViewBase.this.createCommands();
                }
                ConfirmationViewBase.this.open();
            }
        });
        Object object = this.iSynchObject;
        synchronized (object) {
            try {
                this.iSynchObject.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.commandDisposed()) {
            return false;
        }
        this.getComposite().getDisplay().syncExec(new Runnable(){

            public void run() {
                if (ConfirmationViewBase.this.commandDisposed()) {
                    return;
                }
                ConfirmationViewBase.this.getDataFromView();
                ConfirmationViewBase.this.setVisible(false);
            }
        });
        boolean result = true;
        if (this.iCancelled) {
            result = false;
        }
        return result;
    }

    public boolean userHasAnswered() {
        return this.iUserHasAnswered;
    }

    protected abstract void createView();

    protected abstract void getDataFromView();

    private void createCommands() {
        if (this.iOkText != null) {
            this.iOkCommand = new Command((Control)this.getShell(), 1, 2);
            this.iOkCommand.setText(this.iOkText);
            this.iOkCommand.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent aEvent) {
                    ConfirmationViewBase.this.confirmCancel();
                }
            });
            this.iOkCommand.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent aEvent) {
                    this.widgetSelected(aEvent);
                }

                public void widgetSelected(SelectionEvent aEvent) {
                    ConfirmationViewBase.this.confirmOk();
                }
            });
        }
        if (this.iCancelText != null) {
            this.iCancelCommand = new Command((Control)this.getShell(), 4, 1);
            this.iCancelCommand.setText(this.iCancelText);
            this.iCancelCommand.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent aEvent) {
                    ConfirmationViewBase.this.confirmCancel();
                }
            });
            this.iCancelCommand.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent aEvent) {
                    this.widgetSelected(aEvent);
                }

                public void widgetSelected(SelectionEvent aEvent) {
                    ConfirmationViewBase.this.confirmCancel();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void confirmOk() {
        Object object = this.iSynchObject;
        synchronized (object) {
            this.iUserHasAnswered = true;
            this.iCancelled = false;
            this.iSynchObject.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void confirmCancel() {
        Object object = this.iSynchObject;
        synchronized (object) {
            this.iUserHasAnswered = true;
            this.iCancelled = true;
            this.iSynchObject.notify();
        }
    }

    private boolean commandDisposed() {
        return this.iOkCommand != null && this.iOkCommand.isDisposed() || this.iCancelCommand != null && this.iCancelCommand.isDisposed();
    }
}

