/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.installer.ui.eswt;

import com.nokia.mj.impl.installer.ui.InstallerUiTexts;
import com.nokia.mj.impl.installer.ui.eswt.ViewBase;
import org.eclipse.ercp.swt.mobile.Command;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ProgressBar;

public class ProgressView
extends ViewBase {
    private Label iLabel = null;
    private String iMsg = null;
    private ProgressBar iProgressBar = null;
    private boolean iIndeterminate = false;
    private int iValue = 0;
    protected Command iCancelCommand = null;

    protected ProgressView() {
    }

    protected ProgressView(Composite aParent) {
        this(aParent, "");
    }

    protected ProgressView(Composite aParent, String aMsg) {
        this(aParent, aMsg, false);
    }

    protected ProgressView(Composite aParent, String aMsg, boolean aIndeterminate) {
        super(aParent, 1);
        this.iMsg = aMsg;
        this.setTitle(this.iMsg);
        this.iLabel = this.createLabel(this.iMsg, 64);
        this.iIndeterminate = aIndeterminate;
        if (this.iIndeterminate) {
            this.iProgressBar = new ProgressBar(this.getComposite(), 258);
        } else {
            this.iProgressBar = new ProgressBar(this.getComposite(), 65792);
            this.iProgressBar.setMinimum(0);
            this.iProgressBar.setMaximum(100);
            this.iProgressBar.setSelection(this.iValue);
        }
        this.iProgressBar.setLayoutData((Object)new GridData(768));
        this.addCancelCommand();
        this.updateSize();
    }

    public void setText(String aText) {
        this.iMsg = aText;
        this.getComposite().getDisplay().asyncExec(new Runnable(){

            public void run() {
                ProgressView.this.setTitle(ProgressView.this.iMsg);
                ProgressView.this.iLabel.setText(ProgressView.this.iMsg);
                ProgressView.this.updateSize();
            }
        });
    }

    public void updateProgress(int aValue) {
        this.iValue = aValue;
        if (this.iIndeterminate) {
            return;
        }
        this.getComposite().getDisplay().asyncExec(new Runnable(){

            public void run() {
                ProgressView.this.iProgressBar.setSelection(ProgressView.this.iValue);
            }
        });
    }

    protected void addCancelCommand() {
        if (this.iCancelCommand != null || this.isDisposed()) {
            return;
        }
        this.getDisplay().syncExec(new Runnable(){

            public void run() {
                ProgressView.this.iCancelCommand = new Command((Control)ProgressView.this.getShell(), 4, 1);
                ProgressView.this.iCancelCommand.setText(InstallerUiTexts.get("cancel"));
                ProgressView.this.iCancelCommand.addSelectionListener(new SelectionListener(){

                    public void widgetDefaultSelected(SelectionEvent aEvent) {
                        this.widgetSelected(aEvent);
                    }

                    public void widgetSelected(SelectionEvent aEvent) {
                        if (ProgressView.this.getInstallerUi() != null) {
                            ProgressView.this.getInstallerUi().cancel();
                        }
                    }
                });
            }
        });
    }

    protected void removeCancelCommand() {
        if (this.iCancelCommand == null || this.isDisposed()) {
            return;
        }
        this.getDisplay().syncExec(new Runnable(){

            public void run() {
                ProgressView.this.iCancelCommand.dispose();
                ProgressView.this.iCancelCommand = null;
            }
        });
    }
}

