/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.mms;

import com.nokia.mj.impl.mms.MMSAddress;
import com.nokia.mj.impl.utils.Logger;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;

final class MultipartMessageHeader {
    String iSubject = null;
    Vector iToAddresses = null;
    Vector iCcAddresses = null;
    Vector iBccAddresses = null;
    static final String PRIORITY_HEADER = "x-mms-priority";
    static final String DELIVERY_TIME_HEADER = "x-mms-delivery-time";
    static final String DUMMY_REPLY_TO_APP_ID = "$";
    static final String HIGH = "high";
    static final String LOW = "low";
    static final String NORMAL = "normal";
    String iApplicationID = null;
    String iReplyToAppID = null;
    String iFrom = null;
    static final String ADDRESS_TYPE_TO = "to";
    static final String ADDRESS_TYPE_CC = "cc";
    static final String ADDRESS_TYPE_BCC = "bcc";
    static final int TO_ADDRESS = 0;
    static final int BCC_ADDRESS = 1;
    static final int CC_ADDRESS = 2;
    boolean iValidationOn = true;
    private Hashtable iHeaders = null;
    private static final String SUBJECT_HEADER = "x-mms-subject";
    private static final String FROM_HEADER = "x-mms-from";
    private static final String TO_HEADER = "x-mms-to";
    private static final String CC_HEADER = "x-mms-cc";
    private static final String BCC_HEADER = "x-mms-bcc";
    private static final String ADDRESS_TYPE_FROM = "from";
    private int iToAddressCount = 0;
    private int iBccAddressCount = 0;
    private int iCcAddressCount = 0;

    MultipartMessageHeader(boolean aValidationOn) {
        Logger.LOG(15, 4, "+ MultipartMessageHeader::MultipartMessageHeader()");
        this.iHeaders = new Hashtable();
        this.iToAddresses = new Vector();
        this.iCcAddresses = new Vector();
        this.iBccAddresses = new Vector();
        this.iValidationOn = aValidationOn;
        Logger.LOG(15, 4, "- MultipartMessageHeader::MultipartMessageHeader()");
    }

    void setFrom(String aFrom) {
        this.iFrom = aFrom;
    }

    String getHeader(String aHeaderField) {
        Logger.LOG(15, 4, "+ MultipartMessageHeader::getHeader()");
        if (aHeaderField == null) {
            throw new IllegalArgumentException("Header field is null");
        }
        if ((aHeaderField = aHeaderField.toLowerCase()).equals(DELIVERY_TIME_HEADER) || aHeaderField.equals(PRIORITY_HEADER)) {
            Logger.LOG(15, 4, "- MultipartMessageHeader::getHeader()");
            return (String)this.iHeaders.get(aHeaderField);
        }
        if (aHeaderField.equals(SUBJECT_HEADER) || aHeaderField.equals(FROM_HEADER) || aHeaderField.equals(TO_HEADER) || aHeaderField.equals(CC_HEADER) || aHeaderField.equals(BCC_HEADER)) {
            throw new SecurityException("Access to header field " + aHeaderField + " is restricted");
        }
        throw new IllegalArgumentException("Unknown header field: " + aHeaderField);
    }

    void setHeader(String aHeaderField, String aHeaderValue) {
        this.validateAndSetHeader(aHeaderField, aHeaderValue);
    }

    boolean addAddress(String aType, String aAddress) {
        this.validateTypeAndAddress(aType, aAddress);
        this.setAddress(aType, aAddress);
        return true;
    }

    void removeAddresses() {
        this.iToAddresses.removeAllElements();
        this.iCcAddresses.removeAllElements();
        this.iBccAddresses.removeAllElements();
        this.iApplicationID = null;
        this.iToAddressCount = 0;
        this.iCcAddressCount = 0;
        this.iBccAddressCount = 0;
    }

    void removeAddresses(String aType) {
        Logger.LOG(15, 4, "+ MultipartMessageHeader::removeAddresses()");
        aType = aType.toLowerCase();
        if (aType.equals(ADDRESS_TYPE_TO)) {
            this.iToAddresses.removeAllElements();
        } else if (aType.equals(ADDRESS_TYPE_CC)) {
            this.iCcAddresses.removeAllElements();
        } else if (aType.equals(ADDRESS_TYPE_BCC)) {
            this.iBccAddresses.removeAllElements();
        } else {
            throw new IllegalArgumentException("Address type must be one of \"to\", \"cc\" or \"bcc\": " + aType);
        }
        this.checkEmptyAddresses();
        Logger.LOG(15, 4, "- MultipartMessageHeader::removeAddresses()");
    }

    boolean removeAddress(String aType, String aAddress) {
        boolean ret;
        Logger.LOG(15, 4, "+ MultipartMessageHeader::removeAddress()");
        if (aAddress == null) {
            return false;
        }
        if ((aType = aType.toLowerCase()).equals(ADDRESS_TYPE_TO)) {
            ret = this.iToAddresses.removeElement(aAddress);
        } else if (aType.equals(ADDRESS_TYPE_CC)) {
            ret = this.iCcAddresses.removeElement(aAddress);
        } else if (aType.equals(ADDRESS_TYPE_BCC)) {
            ret = this.iBccAddresses.removeElement(aAddress);
        } else {
            throw new IllegalArgumentException("Address type must be one of \"to\", \"cc\" or \"bcc\": " + aType);
        }
        this.checkEmptyAddresses();
        Logger.LOG(15, 4, "- MultipartMessageHeader::removeAddress()");
        return ret;
    }

    String[] getAddresses(String aType) {
        Logger.LOG(15, 4, "+ MultipartMessageHeader::getAddresses()");
        if (aType == null) {
            return null;
        }
        aType = aType.toLowerCase();
        String[] addresses = null;
        if (aType.equals(ADDRESS_TYPE_FROM)) {
            if (this.iFrom != null) {
                addresses = new String[]{this.getFullAddress(this.iFrom, true)};
            }
        } else if (aType.equals(ADDRESS_TYPE_TO)) {
            addresses = new String[this.iToAddresses.size()];
            for (int i = 0; i < this.iToAddresses.size(); ++i) {
                addresses[i] = (String)this.iToAddresses.elementAt(i);
            }
        } else if (aType.equals(ADDRESS_TYPE_CC)) {
            addresses = new String[this.iCcAddresses.size()];
            for (int i = 0; i < this.iCcAddresses.size(); ++i) {
                addresses[i] = (String)this.iCcAddresses.elementAt(i);
            }
        } else if (aType.equals(ADDRESS_TYPE_BCC)) {
            addresses = new String[this.iBccAddresses.size()];
            for (int i = 0; i < this.iBccAddresses.size(); ++i) {
                addresses[i] = (String)this.iBccAddresses.elementAt(i);
            }
        } else {
            throw new IllegalArgumentException("Address type must be one of \"to\", \"cc\" or \"bcc\": " + aType);
        }
        Logger.LOG(15, 4, "- MultipartMessageHeader::getAddresses()");
        return addresses != null && addresses.length > 0 ? addresses : null;
    }

    String getAddress() {
        if (this.iFrom != null && this.iFrom.length() > 0) {
            return this.getFullAddress(this.iFrom, true);
        }
        if (this.iToAddresses.size() > 0) {
            return (String)this.iToAddresses.elementAt(0);
        }
        return null;
    }

    String getDestinationAddress() {
        if (this.iFrom != null && this.iFrom.length() > 0) {
            return this.getFullAddress(this.iFrom, false);
        }
        if (this.iToAddresses.size() > 0) {
            return (String)this.iToAddresses.elementAt(0);
        }
        return null;
    }

    String convertAddresses(int aAddressType, Vector aAddresses) {
        Logger.LOG(15, 4, "+ MultipartMessageHeader::convertAddresses()");
        int addressCount = 0;
        Vector cleanAddresses = new Vector();
        StringBuffer sAddresses = new StringBuffer();
        for (int i = 0; i < aAddresses.size(); ++i) {
            int index;
            String address = (String)aAddresses.elementAt(i);
            if (address.startsWith("mms://")) {
                address = address.substring(6);
            }
            if ((index = address.indexOf(":")) != -1) {
                address = address.substring(0, index);
            }
            if (!cleanAddresses.contains(address)) {
                cleanAddresses.addElement(address);
                sAddresses.append(address);
                ++addressCount;
            }
            if (i >= aAddresses.size() - 1) continue;
            sAddresses.append(";");
        }
        switch (aAddressType) {
            case 0: {
                this.iToAddressCount = addressCount;
                break;
            }
            case 1: {
                this.iBccAddressCount = addressCount;
                break;
            }
            case 2: {
                this.iCcAddressCount = addressCount;
            }
        }
        Logger.LOG(15, 4, "- MultipartMessageHeader::convertAddresses()");
        return sAddresses.toString();
    }

    int getNumberOfRecipients() {
        return this.iToAddressCount + this.iBccAddressCount + this.iCcAddressCount;
    }

    void setAddress(String aAddr) {
        if (aAddr == null) {
            return;
        }
        this.addAddress(ADDRESS_TYPE_TO, aAddr);
    }

    void setAddress(String aType, String aAddress) {
        Logger.LOG(15, 4, "+ MultipartMessageHeader::setAddress()");
        aType = aType.toLowerCase();
        if (aType.equals(ADDRESS_TYPE_TO)) {
            if (!this.iToAddresses.contains(aAddress)) {
                this.iToAddresses.addElement(aAddress);
            }
        } else if (aType.equals(ADDRESS_TYPE_CC)) {
            if (!this.iCcAddresses.contains(aAddress)) {
                this.iCcAddresses.addElement(aAddress);
            }
        } else if (aType.equals(ADDRESS_TYPE_BCC)) {
            if (!this.iBccAddresses.contains(aAddress)) {
                this.iBccAddresses.addElement(aAddress);
            }
        } else {
            throw new IllegalArgumentException("Address type must be one of \"to\", \"cc\" or \"bcc\": " + aType);
        }
        Logger.LOG(15, 4, "- MultipartMessageHeader::setAddress()");
    }

    public String toString() {
        return "\nSubject: " + this.iSubject + "\nDeliveryDate: " + "\nFrom: " + this.iFrom + "\nTo: " + this.convertAddresses(0, this.iToAddresses) + "\nBcc: " + this.convertAddresses(1, this.iBccAddresses) + "\nCc: " + this.convertAddresses(2, this.iCcAddresses) + "\nHeaders \n" + this.iHeaders.toString();
    }

    private String getFullAddress(String aAddress, boolean aUseReplyToAppID) {
        Logger.LOG(15, 4, "+ MultipartMessageHeader::getFullAddress()");
        String fullAddress = "mms://" + aAddress;
        if (aUseReplyToAppID) {
            if (this.iReplyToAppID != null && !this.iReplyToAppID.equals(DUMMY_REPLY_TO_APP_ID)) {
                fullAddress = fullAddress + ":" + this.iReplyToAppID;
            }
        } else if (this.iApplicationID != null) {
            fullAddress = fullAddress + ":" + this.iApplicationID;
        }
        Logger.LOG(15, 4, "- MultipartMessageHeader::getFullAddress()");
        return fullAddress;
    }

    private void checkEmptyAddresses() {
        if (this.iToAddresses.size() == 0 && this.iCcAddresses.size() == 0 && this.iBccAddresses.size() == 0) {
            this.iApplicationID = null;
            this.iToAddressCount = 0;
            this.iCcAddressCount = 0;
            this.iBccAddressCount = 0;
        }
    }

    private void validateAndSetHeader(String aHeaderField, String aHeaderValue) {
        Logger.LOG(15, 4, "+ MultipartMessageHeader::validateAndSetHeader()");
        if (aHeaderField == null) {
            throw new NullPointerException("Header field is null");
        }
        if ((aHeaderField = aHeaderField.toLowerCase()).equals(DELIVERY_TIME_HEADER)) {
            if (aHeaderValue == null) {
                this.iHeaders.remove(DELIVERY_TIME_HEADER);
                return;
            }
            if (this.iValidationOn) {
                try {
                    new Date(Long.parseLong(aHeaderValue));
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Invalid header value x-mms-delivery-time");
                }
            }
            this.iHeaders.put(DELIVERY_TIME_HEADER, aHeaderValue);
            return;
        }
        if (aHeaderField.equals(PRIORITY_HEADER)) {
            if (aHeaderValue == null) {
                this.iHeaders.remove(PRIORITY_HEADER);
                return;
            }
            if (this.iValidationOn && !aHeaderValue.equalsIgnoreCase(HIGH) && !aHeaderValue.equalsIgnoreCase(NORMAL) && !aHeaderValue.equalsIgnoreCase(LOW)) {
                throw new IllegalArgumentException("Invalid header valuex-mms-priority");
            }
            this.iHeaders.put(PRIORITY_HEADER, aHeaderValue);
            return;
        }
        if (this.iValidationOn) {
            if (aHeaderField.equals(SUBJECT_HEADER) || aHeaderField.equals(FROM_HEADER) || aHeaderField.equals(TO_HEADER) || aHeaderField.equals(CC_HEADER) || aHeaderField.equals(BCC_HEADER)) {
                throw new SecurityException("Access to header field " + aHeaderField + " is restricted");
            }
            throw new IllegalArgumentException("Unknown header field: " + aHeaderField);
        }
        Logger.LOG(15, 4, "- MultipartMessageHeader::validateAndSetHeader()");
    }

    private void validateType(String aType) {
        if (aType == null) {
            throw new IllegalArgumentException("Address type is null");
        }
    }

    private void validateAddress(String aAddress) {
        Logger.LOG(15, 4, "+ MultipartMessageHeader::validateAddress()");
        MMSAddress.validateUrl(aAddress);
        String appID = MMSAddress.getAppIdFromUrl(aAddress);
        if (this.iApplicationID != null) {
            if (appID != null && !this.iApplicationID.equals(appID)) {
                throw new IllegalArgumentException("The MultipartMessage can only contain one applicationID.");
            }
        } else {
            this.iApplicationID = appID;
        }
        Logger.LOG(15, 4, "- MultipartMessageHeader::validateAddress()");
    }

    private void validateTypeAndAddress(String aType, String aAddress) {
        this.validateType(aType);
        this.validateAddress(aAddress);
    }
}

