/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.properties.mobinfo;

import com.nokia.mj.impl.connectionmanager.AccessPoint;
import com.nokia.mj.impl.connectionmanager.ConnectionManager;
import com.nokia.mj.impl.properties.mobinfo.MobileInfoPermission;
import com.nokia.mj.impl.rt.support.ApplicationInfo;
import com.nokia.mj.impl.rt.support.ApplicationUtils;
import com.nokia.mj.impl.rt.support.Jvm;
import com.nokia.mj.impl.rt.support.SystemPropertyProvider;
import com.nokia.mj.impl.utils.Logger;
import com.nokia.mj.impl.utils.Uid;
import java.util.Hashtable;

public class MobileInfoProperties
implements SystemPropertyProvider {
    private static final String NETWORK_ACCESS = "com.nokia.network.access";
    private static final String BATTERY_LEVEL = "com.nokia.mid.batterylevel";
    private static final String COUNTRY_CODE = "com.nokia.mid.countrycode";
    private static final String IMEI = "com.nokia.mid.imei";
    static final String IMSI = "com.nokia.mid.imsi";
    private static final String NETWORK_AVAILABILITY = "com.nokia.mid.networkavailability";
    private static final String NETWORK_ID = "com.nokia.mid.networkid";
    private static final String NETWORK_SIGNAL = "com.nokia.mid.networksignal";
    private static final String EMAIL_RECIEVE_SETTINGS = "com.nokia.mid.settings.email-receive-protocol";
    private static final String EMAIL_SEND_SETTINGS = "com.nokia.mid.settings.email-send-protocol";
    private static final String CELLID = "com.nokia.mid.cellid";
    static final String MSISDN = "com.nokia.mid.msisdn";
    private static final String DATEFORMAT = "com.nokia.mid.dateformat";
    private static final String TIMEFORMAT = "com.nokia.mid.timeformat";
    private static final String NETWORKSTATUS = "com.nokia.mid.networkstatus";
    private static final int APP_DEFAULT_APN_NOT_SPECIFIED = -1;
    private static final int NETWORK_ACCESS_V = 1;
    private static final int BATTERY_LEVEL_V = 2;
    private static final int COUNTRY_CODE_V = 3;
    private static final int IMEI_V = 4;
    private static final int IMSI_V = 5;
    private static final int NETWORK_AVAILABILITY_V = 6;
    private static final int NETWORK_ID_V = 7;
    private static final int NETWORK_SIGNAL_V = 8;
    private static final int EMAIL_RECIEVE_SETTINGS_V = 9;
    private static final int EMAIL_SEND_SETTINGS_V = 10;
    private static final int CELLID_V = 11;
    private static final int MSISDN_V = 12;
    private static final int DATEFORMAT_V = 13;
    private static final int TIMEFORMAT_V = 14;
    private static final int NETWORKSTATUS_V = 15;
    private static Hashtable iPropertyKeys;

    public String getProperty(String aKey) {
        ApplicationUtils appUtils = ApplicationUtils.getInstance();
        appUtils.checkPermission(new MobileInfoPermission(aKey, "read"));
        int value = (Integer)iPropertyKeys.get(aKey);
        ConnectionManager CmInstance = null;
        String result = null;
        if (aKey.equals(EMAIL_RECIEVE_SETTINGS) || aKey.equals(EMAIL_SEND_SETTINGS)) {
            return null;
        }
        if (aKey.equals(NETWORK_ACCESS)) {
            try {
                AccessPoint apn;
                Uid appSuiteUid = ApplicationInfo.getInstance().getSuiteUid();
                CmInstance = ConnectionManager.getInstance();
                result = CmInstance != null ? ((apn = CmInstance.getApplicationDefault(appSuiteUid)) != null ? (apn.getType() == AccessPoint.NAP_IAP ? MobileInfoProperties._getPropertyApn(1, apn.getNapId()) : MobileInfoProperties._getPropertyApn(1, -1)) : MobileInfoProperties._getPropertyApn(1, -1)) : MobileInfoProperties._getPropertyApn(1, -1);
            }
            catch (Exception e) {
                Logger.LOG(14, 4, "MobilInfoProperties :: getSuiteUid exception ");
                result = MobileInfoProperties._getPropertyApn(1, -1);
            }
            return result;
        }
        return this._getProperty(value);
    }

    public boolean isStatic(String aKey) {
        return aKey.equals(IMEI) || aKey.equals(IMSI);
    }

    private native String _getProperty(int var1);

    private static native String _getPropertyApn(int var0, int var1);

    static {
        try {
            Jvm.loadSystemLibrary("javamobinfo");
        }
        catch (Exception e) {
            Logger.ELOG(14, "MOBINFO: Unable to load javamobinfo");
        }
        iPropertyKeys = new Hashtable();
        iPropertyKeys.put(NETWORK_ACCESS, new Integer(1));
        iPropertyKeys.put(BATTERY_LEVEL, new Integer(2));
        iPropertyKeys.put(COUNTRY_CODE, new Integer(3));
        iPropertyKeys.put(IMEI, new Integer(4));
        iPropertyKeys.put(IMSI, new Integer(5));
        iPropertyKeys.put(NETWORK_AVAILABILITY, new Integer(6));
        iPropertyKeys.put(NETWORK_ID, new Integer(7));
        iPropertyKeys.put(NETWORK_SIGNAL, new Integer(8));
        iPropertyKeys.put(EMAIL_RECIEVE_SETTINGS, new Integer(9));
        iPropertyKeys.put(EMAIL_SEND_SETTINGS, new Integer(10));
        iPropertyKeys.put(CELLID, new Integer(11));
        iPropertyKeys.put(MSISDN, new Integer(12));
        iPropertyKeys.put(DATEFORMAT, new Integer(13));
        iPropertyKeys.put(TIMEFORMAT, new Integer(14));
        iPropertyKeys.put(NETWORKSTATUS, new Integer(15));
    }
}

