/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.rt.midp;

import com.nokia.mj.impl.rt.midp.ApplicationInfoImpl;
import com.nokia.mj.impl.rt.midp.Log;
import com.nokia.mj.impl.rt.ui.RuntimeUi;
import com.nokia.mj.impl.rt.ui.RuntimeUiFactory;
import com.nokia.mj.impl.security.common.RuntimeSecurityException;
import com.nokia.mj.impl.utils.ErrorMessageBase;
import com.nokia.mj.impl.utils.LineReader;
import com.nokia.mj.impl.utils.ResourceLoader;
import com.nokia.mj.impl.utils.exception.ExceptionBase;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Hashtable;

final class RuntimeErrorDialog
extends ErrorMessageBase {
    private static final int UNHANDLED_ERROR = 1;
    private static final int UNHANDLED_ERROR_DETAILS = 2;
    private static final int START_UP_ERROR = 3;
    private static final int START_UP_ERROR_DETAILS = 4;
    private static final int MAX_LINE_COUNT = 50;
    private static final int MAX_CHAR_COUNT = 34;
    private static Hashtable mMessageTable = null;
    private static ResourceLoader mRes = null;
    private ExceptionBase mExceptionBase;

    private RuntimeErrorDialog() {
    }

    static final RuntimeErrorDialog getUnhandledDialog(Throwable t) {
        return new RuntimeErrorDialog(t, 1, 2);
    }

    static final RuntimeErrorDialog getStartUpErrorDialog(Throwable t) {
        return new RuntimeErrorDialog(t, 3, 4);
    }

    static final RuntimeErrorDialog getStartUpErrorDialog(String detail) {
        return new RuntimeErrorDialog(detail, 3, 4);
    }

    static final void showAuthenticationFailed(RuntimeSecurityException rse) {
        RuntimeUi ui = RuntimeUiFactory.getRuntimeUi();
        ui.error(ApplicationInfoImpl.getMidletInfo().getSuiteName(), rse);
        ui.destroy();
    }

    void showDialog() {
        RuntimeUi ui = RuntimeUiFactory.getRuntimeUi(true);
        ui.error(ApplicationInfoImpl.getMidletInfo().getName(), this.mExceptionBase);
        ui.destroy();
    }

    private RuntimeErrorDialog(Throwable t, int errCode, int detailedErrCode) {
        String[] detailedParams = new String[]{RuntimeErrorDialog.getStackTrace(t)};
        this.mExceptionBase = new ExceptionBase(this, errCode, null, this, detailedErrCode, detailedParams);
    }

    private RuntimeErrorDialog(String detail, int errCode, int detailedErrCode) {
        String[] detailedParams = new String[]{detail};
        this.mExceptionBase = new ExceptionBase(this, errCode, null, this, detailedErrCode, detailedParams);
    }

    protected Hashtable getMessageTable() {
        if (mMessageTable == null) {
            mMessageTable = new Hashtable();
            mMessageTable.put(new Integer(1), "runtime_error_unhandled");
            mMessageTable.put(new Integer(3), "system_app_cannot_start");
            mMessageTable.put(new Integer(2), "runtime_error_unhandled_details");
            mMessageTable.put(new Integer(4), "runtime_error_unhandled_details");
        }
        return mMessageTable;
    }

    protected ResourceLoader getResourceLoader() {
        if (mRes == null) {
            mRes = ResourceLoader.getInstance("javausermessages", "qtn_java_");
        }
        return mRes;
    }

    private static String getStackTrace(Throwable t) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(baos);
        RuntimeErrorDialog._getStackTrace(t, printStream);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        StringBuffer sb = new StringBuffer();
        String lineSeparator = "\u2028";
        try {
            String line;
            int lineCount;
            LineReader lr = new LineReader(new InputStreamReader(bais));
            boolean firstLine = true;
            for (lineCount = 0; (line = lr.readLine()) != null && lineCount < 50; ++lineCount) {
                if (firstLine) {
                    firstLine = false;
                } else {
                    sb.append(lineSeparator);
                }
                line = line.replace('\t', ' ');
                int index = line.indexOf(40);
                if (index > 0 && (line = line.substring(0, index)).length() > 34) {
                    sb.append(" at ...");
                    index = Math.max(line.length() - 34 + 7, 4);
                    line = line.substring(index);
                }
                sb.append(line);
            }
            if (lineCount == 50) {
                sb.append(lineSeparator);
                sb.append(".......");
            }
            bais.close();
            baos.close();
        }
        catch (IOException ioe) {
            Log.logE("Error in stack trace: ", ioe);
        }
        return sb.toString();
    }

    private static native void _getStackTrace(Throwable var0, PrintStream var1);
}

