/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.security;

import com.nokia.mj.impl.rt.support.Finalizer;
import com.nokia.mj.impl.rt.support.Jvm;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SignatureException;

public class SignatureImpl {
    private final int iHandle;
    private Finalizer iFinalizer;

    public SignatureImpl(String aAlgorithm) throws NoSuchAlgorithmException {
        this.iHandle = SignatureImpl._create(aAlgorithm.toUpperCase());
        if (this.iHandle <= 0) {
            throw new NoSuchAlgorithmException("Unsupported algorithm: " + aAlgorithm);
        }
        this.iFinalizer = this.registerForFinalization();
    }

    private Finalizer registerForFinalization() {
        return new Finalizer(){

            public void finalizeImpl() {
                SignatureImpl.this.doFinalize();
            }
        };
    }

    void doFinalize() {
        if (this.iFinalizer == null) {
            return;
        }
        this.iFinalizer = null;
        SignatureImpl._dispose(this.iHandle);
    }

    public void initVerifyImpl(PublicKey aPublicKey) throws InvalidKeyException {
        if (aPublicKey == null) {
            throw new IllegalArgumentException("PublicKey is null.");
        }
        int err = SignatureImpl._initVerify(this.iHandle, aPublicKey.getAlgorithm().toUpperCase(), aPublicKey.getFormat().toUpperCase(), aPublicKey.getEncoded());
        if (err < 0) {
            throw new InvalidKeyException("Invalid key: encoding or length is false, or it is uninitialized");
        }
    }

    public void updateImpl(byte[] aData, int aOffset, int aLength) throws SignatureException {
        if (aData == null) {
            throw new IllegalArgumentException("Data is null.");
        }
        if (aLength == 0) {
            return;
        }
        if (aData.length < aOffset + aLength || aOffset < 0 || aLength < 0 || aOffset >= aData.length) {
            throw new IllegalArgumentException("Array out of bounds.");
        }
        int err = SignatureImpl._update(this.iHandle, aData, aOffset, aLength);
        if (err <= 0) {
            throw new SignatureException("Update failed");
        }
    }

    public boolean verifyImpl(byte[] aSignature) throws SignatureException {
        if (aSignature == null) {
            throw new IllegalArgumentException("Signature is null.");
        }
        int retVal = SignatureImpl._verify(this.iHandle, aSignature);
        if (retVal < 0) {
            throw new SignatureException("Verification failed: invalid signature");
        }
        return retVal > 0;
    }

    private static native int _create(String var0);

    private static native int _initVerify(int var0, String var1, String var2, byte[] var3);

    private static native int _update(int var0, byte[] var1, int var2, int var3);

    private static native int _verify(int var0, byte[] var1);

    private static native void _dispose(int var0);

    static {
        try {
            Jvm.loadSystemLibrary("javasatsa");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

