/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.sensor;

import com.nokia.mj.impl.sensor.ChannelInfoImpl;
import com.nokia.mj.impl.utils.ResourceLoader;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.microedition.sensor.ChannelInfo;
import javax.microedition.sensor.SensorInfo;

final class SensorInfoImpl
implements SensorInfo {
    private static final int MAX_BUFFER_SIZE = 256;
    static final int PUBLIC_SENSOR = 1;
    static final int PRIVATE_SENSOR = 2;
    static final int PROTECTED_SENSOR = 4;
    private static final String[] NO_PROPERTIES = new String[0];
    private static final String SCHEME_SENSOR = "sensor:";
    private static final String SCHEME_CONTEXT_TYPE = "contextType=";
    private static final String SCHEME_MODEL = "model=";
    private static final String SCHEME_LOCATION = "location=";
    private static final String SCHEME_SEP_EXTERNAL = ";";
    private static final String SCHEME_SEP_INTERNAL = "#";
    private static final String SCHEME_SEP_EQUAL = "=";
    private static final String INVALID_SENSORINFO = "Invalid sensor info string";
    private static final String CHANNEL_END_SEP = "@ch_end#";
    private static final String FILE_RES_START = "qtn_sensor_description_";
    private static final String FILE_RES_NAME = "javasensor";
    private ChannelInfo[] iChannelInfos;
    private int connectionType;
    private boolean iAvailable;
    private String contextType;
    private String description;
    private String model;
    private Hashtable properties;
    private String quantity;
    private String url;
    int iIndex;
    private static ResourceLoader iRes = null;

    SensorInfoImpl(String aSensorInfo, int aIndex) {
        this.iIndex = aIndex;
        this.properties = new Hashtable();
        int start = 0;
        int end = aSensorInfo.indexOf(SCHEME_SEP_INTERNAL);
        if (end <= 0) {
            throw new IllegalArgumentException(INVALID_SENSORINFO);
        }
        this.quantity = aSensorInfo.substring(start, end);
        start = end + 1;
        if ((end = aSensorInfo.indexOf(SCHEME_SEP_INTERNAL, start)) <= start) {
            throw new IllegalArgumentException(INVALID_SENSORINFO);
        }
        this.contextType = aSensorInfo.substring(start, end);
        start = end + 1;
        if ((end = aSensorInfo.indexOf(SCHEME_SEP_INTERNAL, start)) <= start) {
            throw new IllegalArgumentException(INVALID_SENSORINFO);
        }
        this.properties.put("location", aSensorInfo.substring(start, end));
        start = end + 1;
        end = aSensorInfo.indexOf(SCHEME_SEP_INTERNAL, start);
        if (end <= start) {
            throw new IllegalArgumentException(INVALID_SENSORINFO);
        }
        this.properties.put("vendor", aSensorInfo.substring(start, end));
        start = aSensorInfo.indexOf(SCHEME_SEP_EQUAL, end) + 1;
        end = aSensorInfo.indexOf(SCHEME_SEP_INTERNAL, start);
        if (end <= start) {
            throw new IllegalArgumentException(INVALID_SENSORINFO);
        }
        String textId = aSensorInfo.substring(start, end);
        if (iRes == null) {
            iRes = ResourceLoader.getInstance(FILE_RES_NAME, FILE_RES_START);
        }
        this.description = iRes.format(textId, null);
        start = aSensorInfo.indexOf(SCHEME_SEP_EQUAL, end) + 1;
        if ((end = aSensorInfo.indexOf(SCHEME_SEP_INTERNAL, start)) <= start) {
            throw new IllegalArgumentException(INVALID_SENSORINFO);
        }
        this.model = aSensorInfo.substring(start, end);
        start = aSensorInfo.indexOf(SCHEME_SEP_EQUAL, end) + 1;
        if ((end = aSensorInfo.indexOf(SCHEME_SEP_INTERNAL, start)) <= start) {
            throw new IllegalArgumentException(INVALID_SENSORINFO);
        }
        String conn = aSensorInfo.substring(start, end);
        this.connectionType = Integer.parseInt(conn);
        this.url = this.createUrl();
        start = end + 1;
        if ((end = aSensorInfo.indexOf(SCHEME_SEP_INTERNAL, start)) <= start) {
            throw new IllegalArgumentException(INVALID_SENSORINFO);
        }
        String avail = aSensorInfo.substring(start, end);
        this.iAvailable = Integer.parseInt(avail) != 0;
        start = end + 1;
        if ((end = aSensorInfo.indexOf(SCHEME_SEP_INTERNAL, start)) <= start) {
            throw new IllegalArgumentException(INVALID_SENSORINFO);
        }
        String chCountStr = aSensorInfo.substring(start, end);
        int channelCount = Integer.parseInt(chCountStr);
        this.iChannelInfos = new ChannelInfo[channelCount];
        start = end + 1;
        for (int i = 0; i < channelCount; ++i) {
            end = aSensorInfo.indexOf(CHANNEL_END_SEP, start);
            String channelString = aSensorInfo.substring(start, end);
            this.iChannelInfos[i] = new ChannelInfoImpl(channelString);
            start = end + CHANNEL_END_SEP.length();
        }
    }

    public ChannelInfo[] getChannelInfos() {
        return this.iChannelInfos;
    }

    public int getConnectionType() {
        return this.connectionType;
    }

    public String getContextType() {
        return this.contextType;
    }

    public String getDescription() {
        return this.description;
    }

    public int getMaxBufferSize() {
        return 256;
    }

    public String getModel() {
        return this.model;
    }

    public synchronized String[] getPropertyNames() {
        if (this.properties == null) {
            return NO_PROPERTIES;
        }
        String[] keys = new String[this.properties.size()];
        int i = 0;
        Enumeration e = this.properties.keys();
        while (e.hasMoreElements()) {
            keys[i] = (String)e.nextElement();
            ++i;
        }
        return keys;
    }

    public synchronized Object getProperty(String key) {
        if (key == null) {
            throw new NullPointerException("Retrieving property name failed: property name is null");
        }
        if (!this.properties.containsKey(key)) {
            throw new IllegalArgumentException("Retrieving property name failed: " + key + " is not found");
        }
        return this.properties.get(key);
    }

    public String getQuantity() {
        return this.quantity;
    }

    public final String getUrl() {
        return this.url;
    }

    public boolean isAvailable() {
        return this.iAvailable;
    }

    public boolean isAvailabilityPushSupported() {
        return false;
    }

    public boolean isConditionPushSupported() {
        return false;
    }

    ChannelInfo getChannelInfo(String name) {
        int l = this.iChannelInfos.length;
        for (int i = 0; i < l; ++i) {
            if (!this.iChannelInfos[i].getName().equals(name)) continue;
            return this.iChannelInfos[i];
        }
        return null;
    }

    private String createUrl() {
        if (!this.properties.containsKey("location")) {
            return SCHEME_SENSOR + this.quantity + SCHEME_SEP_EXTERNAL + SCHEME_CONTEXT_TYPE + this.contextType + SCHEME_SEP_EXTERNAL + SCHEME_MODEL + this.model;
        }
        return SCHEME_SENSOR + this.quantity + SCHEME_SEP_EXTERNAL + SCHEME_CONTEXT_TYPE + this.contextType + SCHEME_SEP_EXTERNAL + SCHEME_MODEL + this.model + SCHEME_SEP_EXTERNAL + SCHEME_LOCATION + this.properties.get("location");
    }
}

