/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.sms;

import com.nokia.mj.impl.security.common.PermissionBase;
import com.nokia.mj.impl.security.utils.SecurityPromptMessage;
import java.security.Permission;
import java.security.PermissionCollection;

public class SMSPermissionImpl
extends PermissionBase {
    public String iAction = null;
    String iDestination = null;
    int iNumberOfSegments = 0;

    public SMSPermissionImpl(String aUri, String aAction) {
        super(aUri);
        this.iAction = aAction;
    }

    public SMSPermissionImpl(String aUri, String aAction, int aNumberOfSegments, String aDestNumber) {
        super(aUri);
        this.iAction = aAction;
        this.iNumberOfSegments = aNumberOfSegments;
        this.iDestination = aDestNumber;
    }

    public String getSecurityPromptQuestion() {
        if (this.iAction.compareTo("receive") == 0) {
            return SecurityPromptMessage.getInstance().getText("sms_receiving", null);
        }
        if (this.iAction.compareTo("open") == 0) {
            return SecurityPromptMessage.getInstance().getText("sms_opening_conn", null);
        }
        if (this.iAction.compareTo("send") == 0) {
            if (this.iNumberOfSegments > 1) {
                return SecurityPromptMessage.getInstance().getText("sms_sending", new Object[]{new Integer(this.iNumberOfSegments), this.iDestination});
            }
            return SecurityPromptMessage.getInstance().getText("sms_single_sending", new Object[]{this.iDestination});
        }
        return null;
    }

    public String toString() {
        if (this.iAction.compareTo("open") == 0) {
            return "javax.microedition.io.Connector.sms";
        }
        if (this.iAction.compareTo("send") == 0) {
            return "javax.wireless.messaging.sms.send";
        }
        if (this.iAction.compareTo("receive") == 0) {
            return "javax.wireless.messaging.sms.receive";
        }
        return null;
    }

    public boolean implies(Permission perm) {
        if (perm instanceof SMSPermissionImpl) {
            SMSPermissionImpl permission = (SMSPermissionImpl)perm;
            if (SMSPermissionImpl.matchActions(this.iAction, permission.iAction)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return 0;
    }

    public boolean equals(Object obj) {
        return true;
    }

    public String getActions() {
        return "";
    }

    public PermissionCollection newPermissionCollection() {
        return null;
    }
}

