/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.tckrunner;

import com.nokia.mj.impl.comms.CommsEndpoint;
import com.nokia.mj.impl.comms.CommsListener;
import com.nokia.mj.impl.comms.CommsMessage;
import com.nokia.mj.impl.tckrunner.Installer;
import com.nokia.mj.impl.tckrunner.Launcher;
import com.nokia.mj.impl.tckrunner.TckRunnerException;
import com.nokia.mj.impl.tckrunner.TckRunnerStateListener;
import com.nokia.mj.impl.utils.Logger;

public class TckRunner
implements CommsListener {
    private static final int NUMBER_OF_RETRIES = 30;
    private static final int RETRY_DELAY = 2000;
    private static final int ERR_NONE = 0;
    private static final int ERR_TCK_RUNNER = -1;
    private static final int ERR_GENERAL = -2;
    public static final int TCK_RUNNER_ADDRESS = 10300;
    public static final int MSG_ID_APPLICATION_EXIT = 104;
    public static final int MSG_ID_GET_NEXT_OPERATION = 500;
    public static final int MSG_ID_OPERATION = 501;
    public static final int MSG_ID_OPERATION_RESULT = 502;
    public static final int OPERATION_INSTALL = 0;
    public static final int OPERATION_UNINSTALL = 1;
    public static final int OPERATION_EXIT = 2;
    private Installer iInstaller;
    private Launcher iLauncher;
    private String iUrl = null;
    private int iRetryCount = 0;
    private int iExitCode = 0;
    private int iState = 0;
    private TckRunnerStateListener iListener = null;
    private Object iSync = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int start(String aUrl, String[] aInstallerArgs) {
        int rc = 0;
        try {
            this.iInstaller = new Installer(this);
            this.iLauncher = new Launcher(this);
            this.iRetryCount = 0;
            this.iUrl = aUrl;
            this.changeState(1);
            this.iInstaller.start(aInstallerArgs);
            Object object = this.iSync;
            synchronized (object) {
                this.iSync.wait();
            }
            rc = this.iExitCode;
        }
        catch (Exception e) {
            Logger.ELOG(18, "Starting TCK Runner failed", e);
            rc = -1;
        }
        finally {
            this.iInstaller.close();
            this.iLauncher.close();
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int startInTestMode(String aUrl) {
        int rc = 0;
        try {
            this.iInstaller = new Installer(this);
            this.iLauncher = new Launcher(this);
            this.iRetryCount = 0;
            this.iUrl = aUrl;
            this.changeState(1);
            Object object = this.iSync;
            synchronized (object) {
                this.iSync.wait();
            }
            rc = this.iExitCode;
        }
        catch (Exception e) {
            Logger.ELOG(18, "Starting TCK Runner in test mode failed", e);
            rc = -1;
        }
        finally {
            this.iInstaller.close();
            this.iLauncher.close();
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        CommsEndpoint comms = new CommsEndpoint();
        try {
            this.iInstaller.stop();
            comms.connect(10300);
            CommsMessage msg = new CommsMessage();
            msg.setMessageId(502);
            msg.write(2);
            msg.write(0);
            Logger.LOG(18, 4, "Stopping TCK Runner");
            comms.send(msg);
            comms.disconnect();
        }
        catch (Exception e) {
            Logger.ELOG(18, "Stopping TCK Runner failed", e);
            this.exit(-1);
        }
        finally {
            comms.destroy();
        }
    }

    public void setListener(TckRunnerStateListener aListener) {
        this.iListener = aListener;
    }

    public synchronized void processMessage(CommsMessage aMsg) {
        try {
            block1 : switch (aMsg.getMessageId()) {
                case 500: {
                    this.iInstaller.saveRequest(aMsg);
                    switch (this.iState) {
                        case 1: {
                            this.iInstaller.install(this.iUrl);
                            break block1;
                        }
                        case 2: {
                            String uid = this.iLauncher.getUidForUninstallation();
                            this.iInstaller.uninstall(uid);
                            break block1;
                        }
                        case 3: {
                            break block1;
                        }
                    }
                    this.iInstaller.stop();
                    break;
                }
                case 502: {
                    int oper = aMsg.readInt();
                    int result = aMsg.readInt();
                    switch (oper) {
                        case 0: {
                            if (result == 0) {
                                int uidCount = aMsg.readInt();
                                String[] uids = new String[uidCount];
                                for (int i = 0; i < uids.length; ++i) {
                                    String uid;
                                    uids[i] = uid = aMsg.readString();
                                }
                                this.changeState(3);
                                this.iLauncher.setApplications(uids);
                                this.iLauncher.runNext();
                                this.iRetryCount = 0;
                                break block1;
                            }
                            Logger.ELOG(18, "Install operation failed: " + result);
                            this.retry();
                            break block1;
                        }
                        case 1: {
                            if (result == 0) {
                                this.changeState(1);
                                break block1;
                            }
                            Logger.ELOG(18, "Uninstall operation failed: " + result);
                            this.exit(-1);
                            break block1;
                        }
                        case 2: {
                            this.exit(result);
                            break block1;
                        }
                    }
                    Logger.ELOG(18, "Unknown operation: " + oper);
                    break;
                }
                case 104: {
                    String uid = aMsg.readString();
                    int status = aMsg.readInt();
                    Logger.LOG(18, 4, "ApplicationExitNotification: uid=" + uid + " status=" + status);
                    boolean allDone = this.iLauncher.runNext();
                    if (allDone) {
                        this.changeState(2);
                        if (this.iInstaller.isReady()) {
                            uid = this.iLauncher.getUidForUninstallation();
                            this.iInstaller.uninstall(uid);
                        }
                    }
                    break;
                }
                default: {
                    Logger.WLOG(18, "Unknow message received:");
                    Logger.WLOG(18, "    messageId = " + aMsg.getMessageId());
                    Logger.WLOG(18, "    moduleId  = " + aMsg.getModuleId());
                }
            }
        }
        catch (TckRunnerException tre) {
            Logger.ELOG(18, "TckRunner error", tre);
            this.exit(-1);
        }
        catch (Exception e) {
            Logger.ELOG(18, "Unexpected error", e);
            this.exit(-2);
        }
    }

    private void changeState(int aState) {
        String state;
        switch (aState) {
            case 1: {
                state = "Install application";
                break;
            }
            case 2: {
                state = "Remove application";
                break;
            }
            case 3: {
                state = "Run application";
                break;
            }
            case 0: {
                state = "Not running";
                break;
            }
            default: {
                state = "Invalid state";
            }
        }
        this.iState = aState;
        Logger.LOG(18, 4, "TckRunner state change: " + state);
        if (this.iListener != null) {
            this.iListener.stateChanged(this.iState);
        }
    }

    private void retry() {
        try {
            ++this.iRetryCount;
            if (30 < this.iRetryCount) {
                throw new TckRunnerException("Maximum number of retries reached");
            }
            long millisecondsToSleep = 2000L;
            Thread.sleep(millisecondsToSleep);
            if (this.iListener != null) {
                this.iListener.operationFailed(this.iState, this.iRetryCount);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exit(int aExitCode) {
        this.iExitCode = aExitCode;
        this.iInstaller.stop();
        Logger.LOG(18, 4, "Exiting " + this.iExitCode);
        this.changeState(0);
        Object object = this.iSync;
        synchronized (object) {
            this.iSync.notifyAll();
        }
    }
}

