/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.utils;

import com.nokia.mj.impl.utils.Task;

public final class TaskQueue {
    Task mFirst = null;
    Task mLast = null;
    boolean mIsActive = true;

    public synchronized Task getTask() {
        while (this.mIsActive) {
            try {
                Task task = this.getTaskImpl();
                if (task == null) {
                    this.wait();
                    task = this.getTaskImpl();
                }
                return task;
            }
            catch (InterruptedException interruptedException) {
            }
        }
        return null;
    }

    private Task getTaskImpl() {
        Task task = this.mFirst;
        if (task != null) {
            if (this.mFirst == this.mLast) {
                this.mFirst = null;
                this.mLast = null;
            } else {
                this.mFirst = task.getNext();
            }
        }
        return task;
    }

    public synchronized void forcedTerminate() {
        this.mIsActive = false;
        this.notify();
    }

    public synchronized int addTask(Task task) {
        if (this.mIsActive) {
            if (this.mLast != null) {
                this.mLast.setNext(task);
                this.mLast = task;
            } else {
                this.mFirst = task;
                this.mLast = task;
            }
            this.notify();
            return 0;
        }
        return -1;
    }
}

