/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.utils.exception;

import com.nokia.mj.impl.utils.ErrorMessageBase;

public class ExceptionBase
extends RuntimeException {
    private Throwable iRootException = null;
    private ErrorMessageBase iShortMsgBase = null;
    private ErrorMessageBase iDetailedMsgBase = null;
    private int iShortMsgId = 0;
    private int iDetailedMsgId = 0;
    private String[] iShortMsgParams = null;
    private String[] iDetailedMsgParams = null;

    public ExceptionBase(ErrorMessageBase aShortMsgBase, int aShortMsgId, String[] aShortMsgParams, ErrorMessageBase aDetailedMsgBase, int aDetailedMsgId, String[] aDetailedMsgParams) {
        this(aShortMsgBase, aShortMsgId, aShortMsgParams, aDetailedMsgBase, aDetailedMsgId, aDetailedMsgParams, null);
    }

    public ExceptionBase(ErrorMessageBase aShortMsgBase, int aShortMsgId, String[] aShortMsgParams, ErrorMessageBase aDetailedMsgBase, int aDetailedMsgId, String[] aDetailedMsgParams, Throwable aRootException) {
        super(ExceptionBase.getLogMsg(aShortMsgBase, aShortMsgId, aShortMsgParams, aDetailedMsgBase, aDetailedMsgId, aDetailedMsgParams));
        this.iShortMsgBase = aShortMsgBase;
        this.iShortMsgId = aShortMsgId;
        this.iShortMsgParams = aShortMsgParams;
        this.iDetailedMsgBase = aDetailedMsgBase;
        this.iDetailedMsgId = aDetailedMsgId;
        this.iDetailedMsgParams = aDetailedMsgParams;
        this.iRootException = aRootException;
    }

    public String getShortMessage() {
        return this.iShortMsgBase.get(this.iShortMsgId, this.iShortMsgParams);
    }

    public String getDetailedMessage() {
        if (this.iDetailedMsgId == 0) {
            return null;
        }
        return this.iDetailedMsgBase.get(this.iDetailedMsgId, this.iDetailedMsgParams);
    }

    public Throwable getRootException() {
        return this.iRootException;
    }

    public boolean equalReason(Object aObj) {
        if (!(aObj instanceof ExceptionBase)) {
            return false;
        }
        ExceptionBase ex = (ExceptionBase)aObj;
        return this.iShortMsgId == ex.iShortMsgId && this.iDetailedMsgId == ex.iDetailedMsgId;
    }

    private static String getLogMsg(ErrorMessageBase aShortMsgBase, int aShortMsgId, String[] aShortMsgParams, ErrorMessageBase aDetailedMsgBase, int aDetailedMsgId, String[] aDetailedMsgParams) {
        StringBuffer result = new StringBuffer("\n");
        result.append("ShortMsg: ").append(aShortMsgBase.get(aShortMsgId, aShortMsgParams)).append("\n");
        if (aDetailedMsgId != 0) {
            result.append("DetailedMsg: ").append(aDetailedMsgBase.get(aDetailedMsgId, aDetailedMsgParams)).append("\n");
        }
        return result.toString();
    }

    private static String getLogMsg2(ErrorMessageBase aShortMsgBase, int aShortMsgId, String[] aShortMsgParams, ErrorMessageBase aDetailedMsgBase, int aDetailedMsgId, String[] aDetailedMsgParams) {
        StringBuffer result = new StringBuffer("\n");
        result.append("ShortMsg: ").append(aShortMsgId).append(": ").append(ExceptionBase.msgParamsToString(aShortMsgParams)).append("\n");
        result.append("DetailedMsg: ").append(aDetailedMsgId).append(": ").append(ExceptionBase.msgParamsToString(aDetailedMsgParams)).append("\n");
        return result.toString();
    }

    private static String msgParamsToString(String[] aParams) {
        if (aParams == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < aParams.length; ++i) {
            result.append(aParams[i]);
            if (i >= aParams.length - 1) continue;
            result.append(", ");
        }
        return result.toString();
    }
}

