/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import com.ibm.oti.util.Msg;
import java.io.IOException;
import java.io.OutputStream;

public class ByteArrayOutputStream
extends OutputStream {
    protected byte[] buf;
    protected int count;

    public ByteArrayOutputStream() {
        this.buf = new byte[32];
    }

    public ByteArrayOutputStream(int size) {
        if (size < 0) {
            throw new IllegalArgumentException(Msg.getString("K005e"));
        }
        this.buf = new byte[size];
    }

    public void close() throws IOException {
        super.close();
    }

    private void expand(int i) {
        byte[] newbuf = new byte[(this.count + i) * 2];
        System.arraycopy((Object)this.buf, 0, (Object)newbuf, 0, this.count);
        this.buf = newbuf;
    }

    public synchronized void reset() {
        this.count = 0;
    }

    public int size() {
        return this.count;
    }

    public synchronized byte[] toByteArray() {
        byte[] newArray = new byte[this.count];
        System.arraycopy((Object)this.buf, 0, (Object)newArray, 0, this.count);
        return newArray;
    }

    public String toString() {
        return new String(this.buf, 0, this.count);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void write(byte[] buffer, int offset, int count) {
        if (this.buf == null) {
            return;
        }
        if (buffer == null) throw new NullPointerException();
        if (offset < 0 || offset > buffer.length || count < 0 || count > buffer.length - offset) throw new ArrayIndexOutOfBoundsException(Msg.getString("K002f"));
        if (this.count + count > this.buf.length) {
            this.expand(count);
        }
        System.arraycopy((Object)buffer, offset, (Object)this.buf, this.count, count);
        this.count += count;
    }

    public synchronized void write(int oneByte) {
        if (this.count >= this.buf.length) {
            this.expand(1);
        }
        this.buf[this.count++] = (byte)oneByte;
    }
}

