/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.GregorianCalendar;

public class Date {
    private transient long milliseconds;

    private static String toString(GregorianCalendar cal) {
        StringBuffer buffer = new StringBuffer(25);
        int offset = (cal.get(7) - 1) * 3;
        buffer.append("SunMonTueWedThuFriSat".substring(offset, offset + 3));
        buffer.append(' ');
        offset = cal.get(2) * 3;
        buffer.append("JanFebMarAprMayJunJulAugSepOctNovDec".substring(offset, offset + 3));
        buffer.append(' ');
        Date.format(buffer, cal.get(5), 2);
        buffer.append(' ');
        Date.format(buffer, cal.get(11), 2);
        buffer.append(':');
        Date.format(buffer, cal.get(12), 2);
        buffer.append(':');
        Date.format(buffer, cal.get(13), 2);
        buffer.append(' ');
        String tz = cal.getTimeZone().getID();
        if (tz != null) {
            buffer.append(tz);
            buffer.append(' ');
        }
        Date.format(buffer, cal.get(1), 4);
        return buffer.toString();
    }

    private static void format(StringBuffer buffer, int value, int digits) {
        String out = String.valueOf(value);
        int i = 0;
        while (i < digits - out.length()) {
            buffer.append('0');
            ++i;
        }
        buffer.append(out);
    }

    public Date() {
        this(System.currentTimeMillis());
    }

    public Date(long milliseconds) {
        this.setTime(milliseconds);
    }

    public boolean equals(Object object) {
        return object == this || object instanceof Date && this.milliseconds == ((Date)object).milliseconds;
    }

    public long getTime() {
        return this.milliseconds;
    }

    public int hashCode() {
        return (int)(this.milliseconds >>> 32) ^ (int)this.milliseconds;
    }

    public void setTime(long milliseconds) {
        this.milliseconds = milliseconds;
    }

    public String toString() {
        GregorianCalendar cal = new GregorianCalendar(this.milliseconds);
        return Date.toString(cal);
    }
}

