/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.Enumeration;
import java.util.NoSuchElementException;

public class Vector {
    protected int elementCount = 0;
    protected Object[] elementData;
    protected int capacityIncrement;

    public Vector() {
        this(10, 0);
    }

    public Vector(int capacity) {
        this(capacity, 0);
    }

    public Vector(int capacity, int capacityIncrement) {
        try {
            this.elementData = new Object[capacity];
        }
        catch (NegativeArraySizeException negativeArraySizeException) {
            throw new IllegalArgumentException();
        }
        this.capacityIncrement = capacityIncrement;
    }

    public synchronized void addElement(Object object) {
        if (this.elementCount == this.elementData.length) {
            this.growByOne();
        }
        this.elementData[this.elementCount++] = object;
    }

    public synchronized int capacity() {
        return this.elementData.length;
    }

    public boolean contains(Object object) {
        return this.indexOf(object, 0) != -1;
    }

    public synchronized void copyInto(Object[] elements) {
        System.arraycopy((Object)this.elementData, 0, (Object)elements, 0, this.elementCount);
    }

    public synchronized Object elementAt(int location) {
        if (location < this.elementCount) {
            return this.elementData[location];
        }
        throw new ArrayIndexOutOfBoundsException(location);
    }

    public Enumeration elements() {
        return new Enumeration(){
            int pos = 0;

            public boolean hasMoreElements() {
                return this.pos < Vector.this.elementCount;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object nextElement() {
                Vector vector = Vector.this;
                synchronized (vector) {
                    if (this.pos < Vector.this.elementCount) {
                        return Vector.this.elementData[this.pos++];
                    }
                }
                throw new NoSuchElementException();
            }
        };
    }

    public synchronized void ensureCapacity(int minimumCapacity) {
        if (this.elementData.length < minimumCapacity) {
            int next = (this.capacityIncrement <= 0 ? this.elementData.length : this.capacityIncrement) + this.elementData.length;
            this.grow(minimumCapacity > next ? minimumCapacity : next);
        }
    }

    public synchronized Object firstElement() {
        if (this.elementCount > 0) {
            return this.elementData[0];
        }
        throw new NoSuchElementException();
    }

    private void grow(int newCapacity) {
        Object[] newData = new Object[newCapacity];
        System.arraycopy((Object)this.elementData, 0, (Object)newData, 0, this.elementCount);
        this.elementData = newData;
    }

    private void growByOne() {
        int adding = 0;
        if (this.capacityIncrement <= 0) {
            adding = this.elementData.length;
            if (adding == 0) {
                adding = 1;
            }
        } else {
            adding = this.capacityIncrement;
        }
        Object[] newData = new Object[this.elementData.length + adding];
        System.arraycopy((Object)this.elementData, 0, (Object)newData, 0, this.elementCount);
        this.elementData = newData;
    }

    public int indexOf(Object object) {
        return this.indexOf(object, 0);
    }

    public synchronized int indexOf(Object object, int location) {
        if (object != null) {
            int i = location;
            while (i < this.elementCount) {
                if (object.equals(this.elementData[i])) {
                    return i;
                }
                ++i;
            }
        } else {
            int i = location;
            while (i < this.elementCount) {
                if (this.elementData[i] == null) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public synchronized void insertElementAt(Object object, int location) {
        if (location >= 0 && location <= this.elementCount) {
            int count;
            if (this.elementCount == this.elementData.length) {
                this.growByOne();
            }
            if ((count = this.elementCount - location) > 0) {
                System.arraycopy((Object)this.elementData, location, (Object)this.elementData, location + 1, count);
            }
            this.elementData[location] = object;
            ++this.elementCount;
        } else {
            throw new ArrayIndexOutOfBoundsException(location);
        }
    }

    public synchronized boolean isEmpty() {
        return this.elementCount == 0;
    }

    public synchronized Object lastElement() {
        try {
            return this.elementData[this.elementCount - 1];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new NoSuchElementException();
        }
    }

    public synchronized int lastIndexOf(Object object) {
        return this.lastIndexOf(object, this.elementCount - 1);
    }

    public synchronized int lastIndexOf(Object object, int location) {
        if (location < this.elementCount) {
            if (object != null) {
                int i = location;
                while (i >= 0) {
                    if (object.equals(this.elementData[i])) {
                        return i;
                    }
                    --i;
                }
            } else {
                int i = location;
                while (i >= 0) {
                    if (this.elementData[i] == null) {
                        return i;
                    }
                    --i;
                }
            }
            return -1;
        }
        throw new ArrayIndexOutOfBoundsException(location);
    }

    public synchronized void removeAllElements() {
        int i = 0;
        while (i < this.elementCount) {
            this.elementData[i] = null;
            ++i;
        }
        this.elementCount = 0;
    }

    public synchronized boolean removeElement(Object object) {
        int index = this.indexOf(object, 0);
        if (index == -1) {
            return false;
        }
        this.removeElementAt(index);
        return true;
    }

    public synchronized void removeElementAt(int location) {
        if (location >= 0 && location < this.elementCount) {
            --this.elementCount;
            int size = this.elementCount - location;
            if (size > 0) {
                System.arraycopy((Object)this.elementData, location + 1, (Object)this.elementData, location, size);
            }
        } else {
            throw new ArrayIndexOutOfBoundsException(location);
        }
        this.elementData[this.elementCount] = null;
    }

    public synchronized void setElementAt(Object object, int location) {
        if (location >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(location);
        }
        this.elementData[location] = object;
    }

    public synchronized void setSize(int length) {
        if (length == this.elementCount) {
            return;
        }
        this.ensureCapacity(length);
        if (this.elementCount > length) {
            int i = length;
            while (i < this.elementCount) {
                this.elementData[i] = null;
                ++i;
            }
        }
        this.elementCount = length;
    }

    public synchronized int size() {
        return this.elementCount;
    }

    public synchronized String toString() {
        if (this.elementCount == 0) {
            return "[]";
        }
        int length = this.elementCount - 1;
        StringBuffer buffer = new StringBuffer(this.size() * 16);
        buffer.append('[');
        int i = 0;
        while (i < length) {
            if (this.elementData[i] == this) {
                buffer.append("(this Collection)");
            } else {
                buffer.append(this.elementData[i]);
            }
            buffer.append(", ");
            ++i;
        }
        if (this.elementData[length] == this) {
            buffer.append("(this Collection)");
        } else {
            buffer.append(this.elementData[length]);
        }
        buffer.append(']');
        return buffer.toString();
    }

    public synchronized void trimToSize() {
        if (this.elementData.length != this.elementCount) {
            this.grow(this.elementCount);
        }
    }
}

