/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.location;

import com.nokia.mj.impl.location.LAPIManager;
import com.nokia.mj.impl.location.LandmarkStoreManager;
import com.nokia.mj.impl.location.LocationPermission;
import com.nokia.mj.impl.location.Locator;
import com.nokia.mj.impl.location.NativeError;
import com.nokia.mj.impl.rt.support.ApplicationUtils;
import com.nokia.mj.impl.rt.support.Finalizer;
import com.nokia.mj.impl.rt.support.Jvm;
import com.nokia.mj.impl.utils.Logger;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.location.Landmark;
import javax.microedition.location.LandmarkException;

public class LandmarkStore {
    private static final String LANDMARK_STORE_NAME_IS_NULL_ERROR = "Landmark store name is null";
    private static final String UNABLE_TO_LIST_CATEGORIES_ERROR = "Unable to list categories";
    private static final String CATEGORY_NAME_IS_NULL_ERROR = "Category name is null";
    private static final String ADDING_CATEGORIES_NOT_SUPPORTED_ERROR = "Adding new categories to this store is not supported";
    private static final String DELETING_CATEGORIES_NOT_SUPPORTED_ERROR = "Deleting categories from this store is not supported";
    private static final String LANDMARK_STORE_IS_CLOSED_ERROR = "Landmark store is closed";
    private static final String LANDMARK_NAME_IS_NULL = "Landmark name is null";
    private static final String LANDMARK_DOES_NOT_BELONG_TO_STORE = "Landmark does not belong to this store";
    private static final String INCORRECT_SEARCH_AREA_ARGUMENTS = "Area arguments are not valid: ";
    private static final String NON_SUPPORTED_UNICODE_CHARACTER = "Non supported unicode characters are not allowed: ";
    private static final String LANDMARK_NAME_LENGTH_EXCEEDS = "Landmark name length exceeds the supported length";
    private static final String CREATE_LANDMARK_STORE_ERROR = "Landmark store name is too long or a landmark store with the specified name already exists";
    private static final String ADD_CATEGORY_ARGUMENT_ERROR = "Category name already exists or it is illegal";
    private static final String CREATE_LANDMARK_STORE_OPERATION_ERROR = "unable to create landmark store: ";
    private static final String DELETE_LANDMARK_ERROR = "Unable to delete landmark: ";
    private static final String ADD_LANDMARK_TO_CATEGORY_ERROR = "Unable to add landmark to category: ";
    private static final String REMOVE_LANDMARK_FROM_CATEGORY_ERROR = "Unable to remove landmark from category: ";
    private static final String UPDATE_LANDMARK_ERROR = "Unable to update landmark: ";
    private static final String DELETE_LANDMARK_STORE_ERROR = "Unable to delete landmark store: ";
    private static final String ADD_CATEGORY_TO_LANDMARK_STORE_ERROR = "Unable to add category to this landmark store: ";
    private static final String DELETE_CATEGORY_FROM_LANDMARK_STORE_ERROR = "Unable to delete category from this landmark store: ";
    private static final String OBTAIN_LANDMARK_ERROR = "Unable to obtain landmarks: ";
    private static final int KErrAlreadyExists = -11;
    private static final int KErrSessionClosed = -45;
    private static final int KLandmarkNameLength = 255;
    private int iStoreHandle;
    private int iEventSourceHandle;
    private String iStoreUri;
    private Finalizer mFinalizer;

    LandmarkStore(int aStoreHandle, String aStoreUri) {
        this.iStoreUri = aStoreUri.toLowerCase().intern();
        this.mFinalizer = this.registerForFinalization();
        this.iStoreHandle = aStoreHandle;
        this.iEventSourceHandle = LAPIManager.getInstance().getFunctionSourceHandle();
    }

    Finalizer registerForFinalization() {
        return new Finalizer(){

            public void finalizeImpl() {
                LandmarkStore.this.doFinalize();
            }
        };
    }

    final void doFinalize() {
        LandmarkStoreManager.getInstance().removeStore(this.iStoreUri, this.iStoreHandle);
        this._dispose(this.iEventSourceHandle, this.iStoreHandle);
    }

    public static LandmarkStore getInstance(String aStoreName) {
        LandmarkStore store;
        String[] arguments = new String[]{""};
        ApplicationUtils appUtils = ApplicationUtils.getInstance();
        LocationPermission permission = new LocationPermission("landmarks://*", "read");
        appUtils.checkPermission(permission);
        Locator locator = null;
        if (aStoreName != null) {
            locator = Locator.createLocator(aStoreName);
        }
        if ((store = LandmarkStoreManager.getInstance().getStore(locator)) == null) {
            int handle = LandmarkStoreManager.getInstance().openStore(locator);
            if (handle <= 0) {
                return null;
            }
            String storeUri = aStoreName == null ? "" : locator.getStoreURI();
            store = new LandmarkStore(handle, storeUri);
            LandmarkStoreManager.getInstance().registerStore(store, storeUri);
        }
        return store;
    }

    public static void createLandmarkStore(String aStoreName) throws IOException, LandmarkException {
        int index;
        String[] arguments = new String[]{""};
        ApplicationUtils appUtils = ApplicationUtils.getInstance();
        LocationPermission permission = new LocationPermission("landmarks://*", "management");
        appUtils.checkPermission(permission);
        LandmarkStore.checkNullArgument(aStoreName, LANDMARK_STORE_NAME_IS_NULL_ERROR);
        for (index = 0; index <= 31; ++index) {
            if (aStoreName.indexOf(index) <= 0) continue;
            throw new IllegalArgumentException(NON_SUPPORTED_UNICODE_CHARACTER + aStoreName);
        }
        if (aStoreName.indexOf(92) > 0 || aStoreName.indexOf(47) > 0 || aStoreName.indexOf(58) > 0 || aStoreName.indexOf(42) > 0 || aStoreName.indexOf(63) > 0 || aStoreName.indexOf(34) > 0 || aStoreName.indexOf(60) > 0 || aStoreName.indexOf(62) > 0 || aStoreName.indexOf(124) > 0) {
            throw new IllegalArgumentException(NON_SUPPORTED_UNICODE_CHARACTER + aStoreName);
        }
        for (index = 127; index <= 159; ++index) {
            if (aStoreName.indexOf(index) <= 0) continue;
            throw new IllegalArgumentException(NON_SUPPORTED_UNICODE_CHARACTER + aStoreName);
        }
        if (aStoreName.indexOf(65279) > 0) {
            throw new IllegalArgumentException(NON_SUPPORTED_UNICODE_CHARACTER + aStoreName);
        }
        for (index = 65520; index <= 65535; ++index) {
            if (aStoreName.indexOf(index) <= 0) continue;
            throw new IllegalArgumentException(NON_SUPPORTED_UNICODE_CHARACTER + aStoreName);
        }
        Locator locator = Locator.createLocator(aStoreName);
        int error = LandmarkStoreManager.getInstance().createStore(locator);
        if (error == -11 || error == -28) {
            throw new IllegalArgumentException(CREATE_LANDMARK_STORE_ERROR);
        }
        NativeError.checkIO(error, CREATE_LANDMARK_STORE_OPERATION_ERROR);
    }

    public static void deleteLandmarkStore(String aStoreName) throws IOException, LandmarkException {
        String[] arguments = new String[]{""};
        ApplicationUtils appUtils = ApplicationUtils.getInstance();
        LocationPermission permission = new LocationPermission("landmarks://*", "management");
        appUtils.checkPermission(permission);
        LandmarkStore.checkNullArgument(aStoreName, LANDMARK_STORE_NAME_IS_NULL_ERROR);
        Locator locator = Locator.createLocator(aStoreName);
        int error = LandmarkStoreManager.getInstance().deleteStore(locator);
        if (error != -6 && error != -18 && error != -28) {
            NativeError.checkIO(error, DELETE_LANDMARK_STORE_ERROR);
        }
    }

    public static String[] listLandmarkStores() throws IOException {
        String[] arguments = new String[]{""};
        ApplicationUtils appUtils = ApplicationUtils.getInstance();
        LocationPermission permission = new LocationPermission("landmarks://*", "read");
        appUtils.checkPermission(permission);
        String[] stores = null;
        Vector locators = LandmarkStoreManager.getInstance().listStores();
        if (locators != null) {
            int numStores = locators.size();
            stores = new String[numStores];
            for (int i = 0; i < numStores; ++i) {
                stores[i] = ((Locator)locators.elementAt(i)).getName();
            }
        }
        return stores;
    }

    public void addLandmark(Landmark aLandmark, String aCategory) throws IOException {
        String[] arguments = new String[]{""};
        ApplicationUtils appUtils = ApplicationUtils.getInstance();
        LocationPermission permission = new LocationPermission("landmarks://*", "write");
        appUtils.checkPermission(permission);
        LandmarkStore.checkNullArgument(aLandmark, LANDMARK_NAME_IS_NULL);
        aLandmark.prepareForSave();
        int landmarkHandle = aLandmark.getHandle();
        int error = this._addLandmark(this.iEventSourceHandle, this.iStoreHandle, landmarkHandle, aCategory);
        this.ensureOpenStore(error);
        NativeError.checkIO(error, ADD_LANDMARK_TO_CATEGORY_ERROR);
        aLandmark.associateToStore(this);
    }

    public Enumeration getLandmarks(String aCategory, String aName) throws IOException {
        int[] error = new int[1];
        int[] landmarkHandles = this._getLandmarksFromCategory(this.iEventSourceHandle, this.iStoreHandle, aCategory, aName, error);
        return this.handleGetLandmarks(landmarkHandles, error[0]);
    }

    public Enumeration getLandmarks() throws IOException {
        int[] error = new int[1];
        int[] landmarkHandles = this._getLandmarks(this.iEventSourceHandle, this.iStoreHandle, error);
        return this.handleGetLandmarks(landmarkHandles, error[0]);
    }

    public Enumeration getLandmarks(String aCategory, double aMinLatitude, double aMaxLatitude, double aMinLongitude, double aMaxLongitude) throws IOException {
        if (aMinLatitude < -90.0 || aMinLatitude > 90.0 || aMaxLatitude < -90.0 || aMaxLatitude > 90.0 || aMinLongitude < -180.0 || aMinLongitude >= 180.0 || aMaxLongitude < -180.0 || aMaxLongitude >= 180.0 || aMinLatitude > aMaxLatitude) {
            throw new IllegalArgumentException(INCORRECT_SEARCH_AREA_ARGUMENTS + aMinLatitude + ", " + aMaxLatitude + ", " + aMinLongitude + " or " + aMaxLongitude);
        }
        int[] error = new int[1];
        int[] landmarkHandles = this._getLandmarksFromArea(this.iEventSourceHandle, this.iStoreHandle, aCategory, aMinLatitude, aMaxLatitude, aMinLongitude, aMaxLongitude, error);
        return this.handleGetLandmarks(landmarkHandles, error[0]);
    }

    public void removeLandmarkFromCategory(Landmark aLandmark, String aCategory) throws IOException {
        String[] arguments = new String[]{""};
        ApplicationUtils appUtils = ApplicationUtils.getInstance();
        LocationPermission permission = new LocationPermission("landmarks://*", "write");
        appUtils.checkPermission(permission);
        LandmarkStore.checkNullArgument(aCategory, CATEGORY_NAME_IS_NULL_ERROR);
        LandmarkStore.checkNullArgument(aLandmark, LANDMARK_NAME_IS_NULL);
        LandmarkStore store = aLandmark.getAssociatedStore();
        if (store == null || !store.getURI().equals(this.iStoreUri)) {
            return;
        }
        int error = this._removeLandmarkFromCategory(this.iEventSourceHandle, this.iStoreHandle, aLandmark.getHandle(), aCategory);
        if (error != 0 && error != -1 && error != -6) {
            NativeError.checkIO(error, REMOVE_LANDMARK_FROM_CATEGORY_ERROR);
        }
    }

    public void updateLandmark(Landmark aLandmark) throws IOException, LandmarkException {
        String[] arguments = new String[]{""};
        ApplicationUtils appUtils = ApplicationUtils.getInstance();
        LocationPermission permission = new LocationPermission("landmarks://*", "write");
        appUtils.checkPermission(permission);
        LandmarkStore.checkNullArgument(aLandmark, LANDMARK_NAME_IS_NULL);
        if (aLandmark.getName().length() > 255) {
            throw new IllegalArgumentException(LANDMARK_NAME_LENGTH_EXCEEDS);
        }
        LandmarkStore store = aLandmark.getAssociatedStore();
        if (store == null || !store.getURI().equals(this.iStoreUri)) {
            throw new LandmarkException(LANDMARK_DOES_NOT_BELONG_TO_STORE);
        }
        aLandmark.prepareForSave();
        int landmarkHandle = aLandmark.getHandle();
        int error = this._updateLandmark(this.iEventSourceHandle, this.iStoreHandle, landmarkHandle);
        this.ensureOpenStore(error);
        if (error == -1) {
            throw new LandmarkException(LANDMARK_DOES_NOT_BELONG_TO_STORE);
        }
        NativeError.checkIO(error, UPDATE_LANDMARK_ERROR);
    }

    public void deleteLandmark(Landmark aLandmark) throws IOException, LandmarkException {
        String[] arguments = new String[]{""};
        ApplicationUtils appUtils = ApplicationUtils.getInstance();
        LocationPermission permission = new LocationPermission("landmarks://*", "write");
        appUtils.checkPermission(permission);
        LandmarkStore.checkNullArgument(aLandmark, LANDMARK_NAME_IS_NULL);
        LandmarkStore store = aLandmark.getAssociatedStore();
        if (store == null || !store.getURI().equals(this.iStoreUri)) {
            throw new LandmarkException(LANDMARK_DOES_NOT_BELONG_TO_STORE);
        }
        int landmarkHandle = aLandmark.getHandle();
        int error = this._deleteLandmark(this.iEventSourceHandle, this.iStoreHandle, landmarkHandle);
        this.ensureOpenStore(error);
        NativeError.checkIO(error, DELETE_LANDMARK_ERROR);
    }

    public Enumeration getCategories() {
        int[] error = new int[1];
        String[] categories = this._listCategories(this.iEventSourceHandle, this.iStoreHandle, error);
        if (error[0] == -45) {
            return null;
        }
        if (categories == null || error[0] < 0) {
            throw new OutOfMemoryError(UNABLE_TO_LIST_CATEGORIES_ERROR);
        }
        Vector categoryVector = new Vector(categories.length);
        for (int i = 0; i < categories.length; ++i) {
            categoryVector.addElement(categories[i]);
        }
        return categoryVector.elements();
    }

    public void addCategory(String aCategory) throws LandmarkException, IOException {
        String[] arguments = new String[]{""};
        ApplicationUtils appUtils = ApplicationUtils.getInstance();
        LocationPermission permission = new LocationPermission("landmarks://*", "management");
        appUtils.checkPermission(permission);
        LandmarkStore.checkNullArgument(aCategory, CATEGORY_NAME_IS_NULL_ERROR);
        int error = this._addCategory(this.iEventSourceHandle, this.iStoreHandle, aCategory);
        this.ensureOpenStore(error);
        if (error == -11 || error == -6) {
            throw new IllegalArgumentException(ADD_CATEGORY_ARGUMENT_ERROR);
        }
        if (error == -5) {
            throw new LandmarkException(ADDING_CATEGORIES_NOT_SUPPORTED_ERROR);
        }
        NativeError.checkIO(error, ADD_CATEGORY_TO_LANDMARK_STORE_ERROR);
    }

    public void deleteCategory(String aCategory) throws LandmarkException, IOException {
        String[] arguments = new String[]{""};
        ApplicationUtils appUtils = ApplicationUtils.getInstance();
        LocationPermission permission = new LocationPermission("landmarks://*", "management");
        appUtils.checkPermission(permission);
        LandmarkStore.checkNullArgument(aCategory, CATEGORY_NAME_IS_NULL_ERROR);
        int error = this._deleteCategory(this.iEventSourceHandle, this.iStoreHandle, aCategory);
        this.ensureOpenStore(error);
        if (error == -5) {
            throw new LandmarkException(DELETING_CATEGORIES_NOT_SUPPORTED_ERROR);
        }
        NativeError.checkIO(error, DELETE_CATEGORY_FROM_LANDMARK_STORE_ERROR);
    }

    String getURI() {
        return this.iStoreUri;
    }

    private synchronized boolean isOpen() {
        return this.iStoreHandle != -1;
    }

    private void ensureOpenStore(int aError) throws IOException {
        if (!this.isOpen() || aError == -45) {
            throw new IOException(LANDMARK_STORE_IS_CLOSED_ERROR);
        }
    }

    private Enumeration handleGetLandmarks(int[] aLandmarkHandles, int aError) throws IOException {
        this.ensureOpenStore(aError);
        NativeError.checkIO(aError, OBTAIN_LANDMARK_ERROR);
        if (aLandmarkHandles == null || aLandmarkHandles.length == 0) {
            return null;
        }
        Vector landmarks = new Vector(aLandmarkHandles.length);
        for (int i = 0; i < aLandmarkHandles.length; ++i) {
            Landmark newLandmark = new Landmark(aLandmarkHandles[i], this.iEventSourceHandle);
            newLandmark.associateToStore(this);
            landmarks.addElement(newLandmark);
        }
        return landmarks.elements();
    }

    private static void checkNullArgument(Object aObject, String aError) {
        if (aObject == null) {
            throw new NullPointerException(aError);
        }
    }

    private native int _addLandmark(int var1, int var2, int var3, String var4);

    private native int[] _getLandmarks(int var1, int var2, int[] var3);

    private native int[] _getLandmarksFromCategory(int var1, int var2, String var3, String var4, int[] var5);

    private native int[] _getLandmarksFromArea(int var1, int var2, String var3, double var4, double var6, double var8, double var10, int[] var12);

    private native int _removeLandmarkFromCategory(int var1, int var2, int var3, String var4);

    private native int _updateLandmark(int var1, int var2, int var3);

    private native int _deleteLandmark(int var1, int var2, int var3);

    private native String[] _listCategories(int var1, int var2, int[] var3);

    private native int _addCategory(int var1, int var2, String var3);

    private native int _deleteCategory(int var1, int var2, String var3);

    private native void _dispose(int var1, int var2);

    static {
        try {
            Jvm.loadSystemLibrary("javalocation");
        }
        catch (Exception e) {
            Logger.ELOG(24, "Unable to load javalocation dll.");
        }
    }
}

