/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.location;

import com.nokia.mj.impl.location.LAPIManager;
import com.nokia.mj.impl.location.LocationPermission;
import com.nokia.mj.impl.rt.support.ApplicationUtils;
import com.nokia.mj.impl.rt.support.Finalizer;
import com.nokia.mj.impl.rt.support.Jvm;
import javax.microedition.location.LocationException;

public class Orientation {
    private static final String UNABLE_TO_OBTAIN_ORIENTATION = "Unable to obtain orientation";
    private static final String ORIENTATION_NOT_SUPPORTED = "Orientation is not supported by the device";
    private float iAzimuth;
    private float iPitch;
    private float iRoll;
    private boolean iIsMagnetic;
    private static final int AZIMUTH = 0;
    private final int iFunctionServerHandle;
    private Finalizer iFinalizer = this.registerFinalize();
    private final int iHandle;
    private static boolean iIsAzimuthCorrectData;
    private static final Object iLock;

    public Orientation(float azimuth, boolean isMagnetic, float pitch, float roll) {
        this.iFunctionServerHandle = LAPIManager.getInstance().getFunctionSourceHandle();
        if (this.iFunctionServerHandle == 0) {
            throw new OutOfMemoryError(UNABLE_TO_OBTAIN_ORIENTATION);
        }
        this.iHandle = this._createNativeHandle(this.iFunctionServerHandle);
        this.iAzimuth = azimuth;
        this.iIsMagnetic = isMagnetic;
        this.iPitch = pitch;
        this.iRoll = roll;
    }

    public float getCompassAzimuth() {
        return this.iAzimuth;
    }

    public boolean isOrientationMagnetic() {
        return this.iIsMagnetic;
    }

    public float getPitch() {
        return this.iPitch;
    }

    public float getRoll() {
        return this.iRoll;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized Orientation getOrientation() throws LocationException {
        float[] orientArray = new float[1];
        boolean isMagnetic = true;
        ApplicationUtils appUtils = ApplicationUtils.getInstance();
        LocationPermission permission = new LocationPermission("location://*", "orientation");
        appUtils.checkPermission(permission);
        Orientation orientInstance = new Orientation(Float.NaN, true, Float.NaN, Float.NaN);
        if (orientInstance.getEventSourceHandle() <= 0 || orientInstance.getNativeHandle() <= 0) {
            orientInstance = null;
            return null;
        }
        int res = Orientation._getAzimuthData(orientInstance.getEventSourceHandle(), orientInstance.getNativeHandle());
        if (res == -2) {
            throw new LocationException(ORIENTATION_NOT_SUPPORTED);
        }
        if (res < 0) {
            iIsAzimuthCorrectData = false;
        } else {
            Object object = iLock;
            synchronized (object) {
                try {
                    iLock.wait();
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }
        if (iIsAzimuthCorrectData) {
            Orientation._getData(orientInstance.getNativeHandle(), orientArray);
            orientInstance.iAzimuth = orientArray[0];
            orientInstance.iIsMagnetic = isMagnetic;
            return orientInstance;
        }
        orientInstance = null;
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void AzimuthDataCallBack(int result) {
        if (result < 0) {
            iIsAzimuthCorrectData = false;
        }
        Object object = iLock;
        synchronized (object) {
            iLock.notify();
        }
    }

    private Finalizer registerFinalize() {
        return new Finalizer(){

            public void finalizeImpl() {
                Orientation.this.registeredFinalize();
            }
        };
    }

    void registeredFinalize() {
        this._dispose(this.iHandle);
    }

    int getEventSourceHandle() {
        return this.iFunctionServerHandle;
    }

    int getNativeHandle() {
        return this.iHandle;
    }

    private static native int _getAzimuthData(int var0, int var1);

    private static native void _getData(int var0, float[] var1);

    private native void _dispose(int var1);

    private native int _createNativeHandle(int var1);

    static {
        try {
            Jvm.loadSystemLibrary("javalocation");
        }
        catch (Exception exception) {
            // empty catch block
        }
        iIsAzimuthCorrectData = true;
        iLock = new Object();
    }
}

