/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.connection.datagram;

import com.ibm.oti.connection.socket.Socket;
import com.ibm.oti.util.Msg;
import com.ibm.oti.util.Util;
import java.io.EOFException;
import java.io.IOException;
import java.io.UTFDataFormatException;
import javax.microedition.io.Datagram;

public class DatagramPacket
implements Datagram {
    String host;
    int port;
    private byte[] data;
    private int length;
    private int offset;
    private int pos;
    private boolean changeLength;

    String getHost() {
        return this.host;
    }

    public String getAddress() {
        if (this.host == null) {
            return null;
        }
        return "datagram://" + this.host + ":" + this.port;
    }

    public byte[] getData() {
        return this.data;
    }

    public int getLength() {
        return this.length;
    }

    public int getOffset() {
        return this.offset;
    }

    public void reset() {
        this.offset = 0;
        this.length = 0;
        this.pos = 0;
        this.changeLength = true;
    }

    public void setAddress(Datagram address) {
        if (address == null) {
            throw new IllegalArgumentException();
        }
        String addressString = address.getAddress();
        if (addressString == null) {
            throw new IllegalArgumentException();
        }
        try {
            this.setAddress(addressString);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public void setAddress(String rawAddress) throws IOException {
        if (rawAddress == null || !rawAddress.startsWith("datagram:")) {
            throw new IllegalArgumentException(Msg.getString("K00a0"));
        }
        String addr = rawAddress.substring(9);
        if (!addr.startsWith("//")) {
            throw new IllegalArgumentException(Msg.getString("K00a1"));
        }
        int[] result = new int[1];
        this.host = Socket.parseURL(addr, result, true, false);
        this.port = result[0];
    }

    public void setData(byte[] data, int start, int length) {
        if (data == null || start < 0 || length < 0 || data.length - start < length) {
            throw new IllegalArgumentException();
        }
        this.data = data;
        this.offset = start;
        this.length = length;
        this.pos = start;
        this.changeLength = false;
    }

    public void setLength(int length) {
        if (length < 0 || length > this.getData().length - this.getOffset()) {
            throw new IllegalArgumentException();
        }
        this.length = length;
        this.changeLength = false;
    }

    public void write(byte[] buffer, int offset, int count) throws IOException {
        if (offset < 0 || count < 0 || offset > buffer.length || buffer.length - offset < count) {
            throw new IndexOutOfBoundsException();
        }
        if (this.changeLength ? count > this.getData().length - this.pos : count > this.getLength() - (this.pos - offset)) {
            throw new EOFException();
        }
        System.arraycopy((Object)buffer, offset, (Object)this.data, this.pos, count);
        this.pos += count;
        if (this.changeLength) {
            this.length = this.pos - this.offset;
        }
    }

    public void write(int oneByte) throws IOException {
        if (this.changeLength ? this.pos == this.getData().length : this.pos - this.getOffset() == this.getLength()) {
            throw new EOFException();
        }
        this.data[this.pos++] = (byte)oneByte;
        if (this.changeLength) {
            this.length = this.pos - this.offset;
        }
    }

    public void writeBoolean(boolean val) throws IOException {
        this.write(val ? 1 : 0);
    }

    public void writeByte(int val) throws IOException {
        this.write(val);
    }

    public void writeChar(int val) throws IOException {
        this.write(val >> 8);
        this.write(val);
    }

    public void writeChars(String str) throws IOException {
        int destIndex = 0;
        byte[] newBytes = new byte[str.length() * 2];
        int index = 0;
        while (index < str.length()) {
            newBytes[destIndex++] = (byte)(str.charAt(index) >> 8);
            newBytes[destIndex++] = (byte)str.charAt(index);
            ++index;
        }
        this.write(newBytes);
    }

    public void writeInt(int val) throws IOException {
        this.write(val >> 24);
        this.write(val >> 16);
        this.write(val >> 8);
        this.write(val);
    }

    public void writeLong(long val) throws IOException {
        this.writeInt((int)(val >> 32));
        this.writeInt((int)val);
    }

    public void writeShort(int val) throws IOException {
        this.writeChar(val);
    }

    public final void writeUTF(String str) throws IOException {
        int utfCount = 0;
        int length = str.length();
        int i = 0;
        while (i < length) {
            char charValue = str.charAt(i);
            utfCount = charValue > '\u0000' && charValue <= '\u007f' ? ++utfCount : (charValue <= '\u07ff' ? (utfCount += 2) : (utfCount += 3));
            ++i;
        }
        if (utfCount > 65535) {
            throw new UTFDataFormatException(Msg.getString("K0068"));
        }
        byte[] utfBytes = new byte[utfCount];
        int utfIndex = 0;
        int i2 = 0;
        while (i2 < length) {
            char charValue = str.charAt(i2);
            if (charValue > '\u0000' && charValue <= '\u007f') {
                utfBytes[utfIndex++] = (byte)charValue;
            } else if (charValue <= '\u07ff') {
                utfBytes[utfIndex++] = (byte)(0xC0 | 0x1F & charValue >> 6);
                utfBytes[utfIndex++] = (byte)(0x80 | 0x3F & charValue);
            } else {
                utfBytes[utfIndex++] = (byte)(0xE0 | 0xF & charValue >> 12);
                utfBytes[utfIndex++] = (byte)(0x80 | 0x3F & charValue >> 6);
                utfBytes[utfIndex++] = (byte)(0x80 | 0x3F & charValue);
            }
            ++i2;
        }
        this.writeShort(utfCount);
        if (utfCount > 0) {
            this.write(utfBytes);
        }
    }

    public void write(byte[] buffer) throws IOException {
        this.write(buffer, 0, buffer.length);
    }

    public boolean readBoolean() throws IOException {
        return this.readUnsignedByte() != 0;
    }

    public byte readByte() throws IOException {
        if (this.pos - this.getOffset() == this.getLength()) {
            throw new EOFException();
        }
        return this.data[this.pos++];
    }

    public char readChar() throws IOException {
        int b1 = this.readUnsignedByte();
        int b2 = this.readUnsignedByte();
        return (char)((b1 << 8) + b2);
    }

    public void readFully(byte[] buffer) throws IOException {
        this.readFully(buffer, 0, buffer.length);
    }

    public void readFully(byte[] buffer, int offset, int count) throws IOException {
        if (offset < 0 || count < 0 || offset > buffer.length || buffer.length - offset < count) {
            throw new IndexOutOfBoundsException();
        }
        if (count > this.getLength() - (this.pos - this.getOffset())) {
            throw new EOFException();
        }
        System.arraycopy((Object)this.data, this.pos, (Object)buffer, offset, count);
        this.pos += count;
    }

    public int readInt() throws IOException {
        int b1 = this.readUnsignedByte();
        int b2 = this.readUnsignedByte();
        int b3 = this.readUnsignedByte();
        int b4 = this.readUnsignedByte();
        return (b1 << 24) + (b2 << 16) + (b3 << 8) + b4;
    }

    public long readLong() throws IOException {
        int i1 = this.readInt();
        int i2 = this.readInt();
        return ((long)i1 << 32) + ((long)i2 & 0xFFFFFFFFL);
    }

    public short readShort() throws IOException {
        return (short)this.readUnsignedShort();
    }

    public final int readUnsignedByte() throws IOException {
        if (this.pos - this.getOffset() == this.getLength()) {
            throw new EOFException();
        }
        return this.data[this.pos++] & 0xFF;
    }

    public final int readUnsignedShort() throws IOException {
        int b1 = this.readUnsignedByte();
        int b2 = this.readUnsignedByte();
        return (b1 << 8) + b2;
    }

    public final String readUTF() throws IOException {
        int utfSize = this.readUnsignedShort();
        byte[] buf = new byte[utfSize];
        this.readFully(buf, 0, utfSize);
        return Util.convertFromUTF8(buf, 0, utfSize);
    }

    public int skipBytes(int count) throws IOException {
        int max = this.getLength() - (this.pos - this.getOffset());
        if (count > max) {
            count = max;
        }
        this.pos += count;
        return count;
    }

    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public final void writeFloat(float val) throws IOException {
        this.writeInt(Float.floatToIntBits(val));
    }

    public final void writeDouble(double val) throws IOException {
        this.writeLong(Double.doubleToLongBits(val));
    }
}

