/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.connection.file;

import com.ibm.oti.util.Msg;
import com.ibm.oti.util.Util;
import com.ibm.oti.vm.VM;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.io.ConnectionNotFoundException;

public final class FileInputStream
extends InputStream {
    private long descriptor = -1L;
    public static final FileInputStream in = new FileInputStream(0L);

    FileInputStream(long fid) {
        if (!VM.callerIsBootstrap()) {
            throw new SecurityException();
        }
        this.descriptor = fid;
    }

    public FileInputStream(String fileName) throws ConnectionNotFoundException {
        if (!VM.callerIsBootstrap()) {
            throw new SecurityException();
        }
        this.descriptor = this.openImpl(Util.getBytes(fileName));
        if (this.descriptor == -1L) {
            throw new ConnectionNotFoundException(fileName);
        }
    }

    public FileInputStream(byte[] fileName) throws ConnectionNotFoundException {
        if (!VM.callerIsBootstrap()) {
            throw new SecurityException();
        }
        this.descriptor = this.openImpl(fileName);
        if (this.descriptor == -1L) {
            throw new ConnectionNotFoundException();
        }
    }

    public int available() throws IOException {
        return this.availableImpl(this.descriptor);
    }

    private native int availableImpl(long var1) throws IOException;

    public void close() throws IOException {
        try {
            this.closeImpl(this.descriptor);
        }
        finally {
            this.descriptor = -1L;
        }
    }

    private native void closeImpl(long var1) throws IOException;

    private native long openImpl(byte[] var1);

    public int read() throws IOException {
        if (this.descriptor == -1L) {
            throw new IOException(Msg.getString("K0059"));
        }
        return this.readByteImpl(this.descriptor);
    }

    private native int readByteImpl(long var1) throws IOException;

    public int read(byte[] buffer, int offset, int count) throws IOException {
        if (this.descriptor == -1L) {
            throw new IOException(Msg.getString("K0059"));
        }
        return this.readImpl(buffer, offset, count, this.descriptor);
    }

    private native int readImpl(byte[] var1, int var2, int var3, long var4) throws IOException;

    public long skip(long count) throws IOException {
        return this.skipImpl(count, this.descriptor);
    }

    private native long skipImpl(long var1, long var3) throws IOException;
}

