/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.connection.file;

import com.ibm.oti.util.Msg;
import com.ibm.oti.util.Util;
import com.ibm.oti.vm.VM;
import java.io.IOException;
import java.io.OutputStream;
import javax.microedition.io.ConnectionNotFoundException;

public final class FileOutputStream
extends OutputStream {
    private long descriptor = -1L;
    public static final FileOutputStream out = new FileOutputStream(1L);
    public static final FileOutputStream err = new FileOutputStream(2L);

    FileOutputStream(long fid) {
        if (!VM.callerIsBootstrap()) {
            throw new SecurityException();
        }
        this.descriptor = fid;
    }

    public FileOutputStream(String filename, boolean append) throws ConnectionNotFoundException {
        if (!VM.callerIsBootstrap()) {
            throw new SecurityException();
        }
        this.descriptor = this.openImpl(Util.getBytes(filename), append);
        if (this.descriptor == -1L) {
            throw new ConnectionNotFoundException(filename);
        }
    }

    public void close() throws IOException {
        try {
            this.closeImpl(this.descriptor);
        }
        finally {
            this.descriptor = -1L;
        }
    }

    private native void closeImpl(long var1) throws IOException;

    private native long openImpl(byte[] var1, boolean var2);

    public void write(byte[] buffer, int offset, int count) throws IOException {
        if (this.descriptor == -1L) {
            throw new IOException(Msg.getString("K00b7"));
        }
        this.writeImpl(buffer, offset, count, this.descriptor);
    }

    private native void writeImpl(byte[] var1, int var2, int var3, long var4) throws IOException;

    public void write(int oneByte) throws IOException {
        if (this.descriptor == -1L) {
            throw new IOException(Msg.getString("K00b7"));
        }
        this.writeByteImpl(oneByte, this.descriptor);
    }

    private native void writeByteImpl(int var1, long var2) throws IOException;
}

