/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.io;

import com.ibm.oti.io.CharBuffer;
import com.ibm.oti.io.CharacterConverter;
import com.ibm.oti.vm.VM;

public class NativeCharacterConverter
extends CharacterConverter {
    protected String javaEncoding;
    protected byte[] resultBytes;
    protected char[] resultChars;
    protected int bytePos = 0;
    protected long osConverter = 0L;
    protected int osEncodingUID = 0;
    protected int osConverterState = -1;
    protected static boolean supportsNativeConv = NativeCharacterConverter.supportsNativeCharConv();
    protected static boolean isInitialized = false;
    private static MasterThread masterThread;
    private static boolean mThreadStartup;
    static /* synthetic */ Class class$0;

    static {
        mThreadStartup = false;
        masterThread = new MasterThread();
        VM.setDaemonThread(masterThread);
        masterThread.start();
    }

    public static NativeCharacterConverter getNativeConverter(String encoding) {
        if (!supportsNativeConv) {
            return null;
        }
        if (!isInitialized) {
            Class clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.Thread");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            NativeCharacterConverter.ntvinit(clazz);
            isInitialized = true;
        }
        NativeCharacterConverter converter = new NativeCharacterConverter(encoding);
        if (converter.osConverter <= 0L) {
            return null;
        }
        return converter;
    }

    private NativeCharacterConverter(final String encoding) {
        Runnable r = new Runnable(){

            public void run() {
                NativeCharacterConverter.this.osConverter = NativeCharacterConverter.this.createOSConverterImpl(encoding);
                NativeCharacterConverter.this.javaEncoding = encoding;
                NativeCharacterConverter.this.setName(encoding);
            }
        };
        masterThread.syncExec(r);
        this.initializeConverterState();
    }

    private NativeCharacterConverter(String encoding, long osConverterPtr) {
        this(encoding);
        this.osConverter = osConverterPtr;
    }

    private native long createOSConverterImpl(String var1);

    public String getJavaEncoding() {
        return this.javaEncoding;
    }

    public int getOSEncodingUID() {
        return this.osEncodingUID;
    }

    private static native void ntvinit(Class var0);

    private void initializeConverterState() {
        if (this.osConverter != 0L) {
            this.initializeConverterStateImpl();
        }
    }

    private native void initializeConverterStateImpl();

    public synchronized long getOSConverter() {
        return this.osConverter;
    }

    private synchronized void deleteOSConverter() {
        if (this.osConverter != 0L) {
            Runnable r = new Runnable(){

                public void run() {
                    NativeCharacterConverter.deleteOSConverterImpl(NativeCharacterConverter.this.osConverter, Thread.currentThread());
                }
            };
            masterThread.syncExec(r);
            this.osConverter = 0L;
            this.osEncodingUID = 0;
            this.osConverterState = -1;
            this.javaEncoding = "";
        }
    }

    private static native void deleteOSConverterImpl(long var0, Thread var2);

    private static native boolean supportsNativeCharConv();

    public static boolean supportsNativeConversion() {
        return supportsNativeConv;
    }

    public byte[] convert(final char[] value, final int offset, final int count) {
        if (offset >= 0 && offset <= value.length && count >= 0 && count <= value.length - offset) {
            if (count == 0) {
                this.resultBytes = new byte[0];
            } else {
                Runnable r = new Runnable(){

                    public void run() {
                        NativeCharacterConverter.this.resultBytes = NativeCharacterConverter.this.convertCharsToBytesImpl(value, offset, count, NativeCharacterConverter.this.javaEncoding, NativeCharacterConverter.this.osConverter, Thread.currentThread(), NativeCharacterConverter.this.osEncodingUID);
                    }
                };
                masterThread.syncExec(r);
            }
        } else {
            throw new IndexOutOfBoundsException();
        }
        return this.resultBytes;
    }

    private synchronized native byte[] convertCharsToBytesImpl(char[] var1, int var2, int var3, String var4, long var5, Thread var7, int var8);

    public char[] convert(final byte[] value, final int offset, final int count) {
        if (offset >= 0 && offset <= value.length && count >= 0 && count <= value.length - offset) {
            if (count == 0) {
                this.resultChars = new char[0];
            } else {
                Runnable r = new Runnable(){

                    public void run() {
                        NativeCharacterConverter.this.resultChars = NativeCharacterConverter.this.convertBytesToCharsImpl(value, offset, count, NativeCharacterConverter.this.javaEncoding, NativeCharacterConverter.this.osConverter, NativeCharacterConverter.this.osConverterState, Thread.currentThread(), NativeCharacterConverter.this.osEncodingUID);
                    }
                };
                masterThread.syncExec(r);
            }
        } else {
            throw new IndexOutOfBoundsException();
        }
        return this.resultChars;
    }

    private synchronized native char[] convertBytesToCharsImpl(byte[] var1, int var2, int var3, String var4, long var5, int var7, Thread var8, int var9);

    public int convert(final byte[] value, final int offset, final int count, final CharBuffer buffer) {
        if (offset >= 0 && offset <= value.length && count >= 0 && count <= value.length - offset) {
            Runnable r = new Runnable(){

                public void run() {
                    int[] charPos = new int[]{buffer.getPos()};
                    NativeCharacterConverter.this.bytePos = NativeCharacterConverter.this.convertStreamBytesToCharsImpl(value, offset, count, buffer.getChars(), buffer.getOffset(), buffer.getSize(), charPos, NativeCharacterConverter.this.javaEncoding, NativeCharacterConverter.this.osConverter, NativeCharacterConverter.this.osConverterState, Thread.currentThread(), NativeCharacterConverter.this.osEncodingUID);
                    buffer.setPos(charPos[0]);
                }
            };
            masterThread.syncExec(r);
            return this.bytePos;
        }
        throw new IndexOutOfBoundsException();
    }

    private synchronized native int convertStreamBytesToCharsImpl(byte[] var1, int var2, int var3, char[] var4, int var5, int var6, int[] var7, String var8, long var9, int var11, Thread var12, int var13);

    public synchronized void close() {
        this.deleteOSConverter();
    }

    private static class MasterThread
    extends Thread {
        private boolean running = true;
        private Runnable runnable = null;
        private Object execLock = new Object();
        private Object runLock = new Object();
        static int numRuns = 0;

        MasterThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (this.running) {
                Object object = this.runLock;
                synchronized (object) {
                    try {
                        if (!mThreadStartup) {
                            mThreadStartup = true;
                        }
                        if (this.runnable == null) {
                            this.runLock.wait();
                        }
                        if (this.runnable != null) {
                            this.runnable.run();
                            ++numRuns;
                            this.runnable = null;
                        }
                        this.runLock.notifyAll();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void syncExec(Runnable r) {
            Object object = this.execLock;
            synchronized (object) {
                while (true) {
                    if (mThreadStartup) {
                        Object object2 = this.runLock;
                        synchronized (object2) {
                            this.runnable = r;
                            this.runLock.notifyAll();
                            try {
                                this.runLock.wait();
                            }
                            catch (InterruptedException interruptedException) {}
                            break;
                        }
                    }
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finished() {
            Object object = this.runLock;
            synchronized (object) {
                this.running = false;
                this.runLock.notifyAll();
            }
        }
    }
}

