/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mid.iapinfo;

import com.nokia.mid.iapinfo.CommDBException;
import com.nokia.mj.impl.rt.support.Finalizer;

abstract class CommsTable {
    public int iRecordId;
    public int iRecordTag;
    public String iRecordName;
    public static final int ERROR_NONE = 0;
    public static final int ERROR_OPEN_FAILED = -1;
    public static final int ERROR_TABLE_CLOSED = -2;
    public static final int RECORD_NOT_FOUND = -3;
    public static final int ERROR_INVALID_PARAMETER = -4;
    public static final int ERROR_TABLE_READ = -5;
    public static final int ERROR_TABLE_END = -6;
    protected String iTableName = "";
    protected static final String TABLE_IAP = "IAP";
    protected static final String TABLE_CONNECTION_PREFERENCES = "ConnectionPreferences";
    protected static final String TABLE_NETWORK = "Network";
    protected static final String TABLE_GLOBALSETTINGS = "GlobalSettings";
    private int iHandle;
    private int state = -1;
    private static final int UNKNOWN = -1;
    private static final int CREATED = 0;
    private static final int CLOSED = 1;
    private static final int OPENED = 2;
    private Finalizer iFinalizer;

    public CommsTable(String tableName) throws CommDBException {
        this.iTableName = tableName;
        this.iHandle = CommsTable._construct();
        if (this.iHandle < 0) {
            throw new CommDBException("Native constructor failed!", 0, this.iHandle);
        }
        this.iFinalizer = this.createFinalizer();
        this.state = 0;
    }

    public void open() throws CommDBException {
        int err = CommsTable._open(this.iHandle, this.iTableName);
        if (0 != err) {
            throw new CommDBException("Open failed!", -1, err);
        }
        this.state = 2;
        this.readFieldValues();
    }

    public void close() {
        this.state = 1;
        CommsTable._close(this.iHandle);
        this.clearFieldValues();
    }

    public int findByName(String recordName) throws CommDBException {
        int rec = 0;
        rec = CommsTable._findByName(this.iHandle, recordName);
        if (rec < 0) {
            return -3;
        }
        this.readFieldValues();
        return rec;
    }

    public int findById(int id) throws CommDBException {
        int rec = 0;
        rec = CommsTable._findById(this.iHandle, id);
        if (rec < 0) {
            return -3;
        }
        this.readFieldValues();
        return rec;
    }

    public int getRecordCount() throws CommDBException {
        return CommsTable._getRecordCount(this.iHandle);
    }

    public void nextRecord() throws CommDBException {
        int ret = CommsTable._next(this.iHandle);
        if (-25 == ret) {
            throw new CommDBException("End of table reached!", -6);
        }
        this.readFieldValues();
    }

    public void previousRecord() throws CommDBException {
        int ret = CommsTable._previous(this.iHandle);
        if (-25 == ret) {
            throw new CommDBException("End of table reached!", -6);
        }
        this.readFieldValues();
    }

    protected abstract void readFieldValues() throws CommDBException;

    protected abstract void clearFieldValues();

    protected int readIntFieldValue(String fieldName) throws CommDBException {
        int[] error = new int[1];
        int value = CommsTable._readIntFieldValue(this.iHandle, fieldName, error);
        if (0 != error[0]) {
            this.clearFieldValues();
            throw new CommDBException("Error while reading table data!", -5, error[0]);
        }
        return value;
    }

    protected String readStringFieldValue(String fieldName) throws CommDBException {
        int[] error = new int[1];
        String value = CommsTable._readStringFieldValue(this.iHandle, fieldName, error);
        if (0 != error[0]) {
            this.clearFieldValues();
            throw new CommDBException("Error while reading table data!", -5, error[0]);
        }
        return value;
    }

    Finalizer createFinalizer() {
        return new Finalizer(){

            public void finalizeImpl() {
                CommsTable.this.doFinalize();
            }
        };
    }

    public void doFinalize() {
        CommsTable._destroy(this.iHandle);
    }

    private static native int _construct();

    private static native void _destroy(int var0);

    private static native int _open(int var0, String var1);

    private static native void _close(int var0);

    private static native int _next(int var0);

    private static native int _previous(int var0);

    private static native int _getRecordCount(int var0);

    private static native int _findByName(int var0, String var1);

    private static native int _findById(int var0, int var1);

    private static native int _readIntFieldValue(int var0, String var1, int[] var2);

    private static native String _readStringFieldValue(int var0, String var1, int[] var2);
}

