/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.comms;

import com.nokia.mj.impl.comms.CommsEndpointBase;
import com.nokia.mj.impl.comms.exception.CommsException;
import com.nokia.mj.impl.rt.support.Jvm;

public final class CommsEndpoint
extends CommsEndpointBase {
    public static final int JAVA_CAPTAIN = 10000;
    public static final int TCK_RUNNER = 10300;
    public static final int JAVA_PREINSTALLER = 10400;
    public static final int JAVA_APPCONVERTER = 10500;
    public static final int JAVA_DEBUGAPI = 10700;
    public static final int WAIT_FOR_EVER = -1;
    private boolean iReleaseHandle;

    public CommsEndpoint() {
        this.iHandle = this._create();
        this.iReleaseHandle = true;
    }

    private CommsEndpoint(int aHandle) {
        this.iHandle = aHandle;
        this.iReleaseHandle = false;
    }

    public static CommsEndpoint find(String aName) {
        int handle = CommsEndpoint._find(aName);
        CommsEndpoint client = null;
        if (handle != 0) {
            client = new CommsEndpoint(handle);
        }
        return client;
    }

    public void connect(int aName) throws CommsException {
        this.checkHandle();
        int rc = this._connect(this.iHandle, aName);
        if (rc != 0) {
            throw new CommsException("connect failed, address=" + aName);
        }
    }

    public void disconnect() throws CommsException {
        this.checkHandle();
        int rc = this._disconnect(this.iHandle);
        if (rc != 0) {
            throw new CommsException("disconnect failed");
        }
    }

    public void destroy() {
        if (this.iHandle != 0) {
            if (this.iReleaseHandle) {
                this._release(this.iHandle);
            } else {
                this._detach(this.iHandle);
            }
        }
        this.iHandle = 0;
    }

    private native int _create();

    private native int _connect(int var1, int var2);

    private native int _disconnect(int var1);

    private static native int _find(String var0);

    static {
        Jvm.loadSystemLibrary("javacomms");
    }
}

