/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.comms;

import com.nokia.mj.impl.utils.Logger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public class CommsMessage {
    private int iMessageId;
    private int iReceiver;
    private int iSender;
    private int iModuleId;
    private int iMessageRef;
    private int iIsTrusted;
    private ByteArrayInputStream iInputStream = null;
    private ByteArrayOutputStream iOutputStream = new ByteArrayOutputStream();
    private static final int MESSAGE_HEADER_LENGTH = 28;
    private static final String DEFAULT_CHARSET = "UTF-8";

    public CommsMessage() {
    }

    public CommsMessage(byte[] aRawMessage) {
        this();
        if (aRawMessage == null || aRawMessage.length < 28) {
            throw new IllegalArgumentException("aRawMessage is null or too short");
        }
        this.fromByteArray(aRawMessage);
    }

    public byte[] toByteArray() {
        byte[] msg = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            dos.writeInt(this.reverseBytes(this.iMessageId));
            dos.writeInt(this.reverseBytes(28 + this.iOutputStream.size()));
            dos.writeInt(this.reverseBytes(this.iReceiver));
            dos.writeInt(this.reverseBytes(this.iSender));
            dos.writeInt(this.reverseBytes(this.iModuleId));
            dos.writeInt(this.reverseBytes(this.iMessageRef));
            dos.writeInt(this.reverseBytes(this.iIsTrusted));
            byte[] data = this.iOutputStream.toByteArray();
            dos.write(data, 0, data.length);
            msg = baos.toByteArray();
        }
        catch (Exception e) {
            Logger.ELOG(3, "CommsMessage.toByteArray failed", e);
        }
        return msg;
    }

    private void fromByteArray(byte[] aRawMessage) {
        try {
            this.iInputStream = new ByteArrayInputStream(aRawMessage);
            DataInputStream dis = new DataInputStream(this.iInputStream);
            this.iMessageId = this.reverseBytes(dis.readInt());
            int length = this.reverseBytes(dis.readInt()) - 28;
            this.iReceiver = this.reverseBytes(dis.readInt());
            this.iSender = this.reverseBytes(dis.readInt());
            this.iModuleId = this.reverseBytes(dis.readInt());
            this.iMessageRef = this.reverseBytes(dis.readInt());
            this.iIsTrusted = this.reverseBytes(dis.readInt());
        }
        catch (Exception e) {
            Logger.ELOG(3, "CommsMessage.fromByteArray failed", e);
        }
    }

    public int getMessageId() {
        return this.iMessageId;
    }

    public void setMessageId(int aMessageId) {
        this.iMessageId = aMessageId;
    }

    public int getModuleId() {
        return this.iModuleId;
    }

    public void setModuleId(int aModuleId) {
        this.iModuleId = aModuleId;
    }

    public int getReceiver() {
        return this.iReceiver;
    }

    public void setReceiver(int aReceiver) {
        this.iReceiver = aReceiver;
    }

    public int getSender() {
        return this.iSender;
    }

    public void setSender(int aSender) {
        this.iSender = aSender;
    }

    public int getMessageRef() {
        return this.iMessageRef;
    }

    public void setMessageRef(int aMessageRef) {
        this.iMessageRef = aMessageRef;
    }

    public boolean isTrusted() {
        return this.iIsTrusted != 0;
    }

    public void replyTo(CommsMessage aMessage) {
        this.setModuleId(aMessage.getModuleId());
        this.setMessageId(aMessage.getMessageId());
        this.setMessageRef(aMessage.getMessageRef());
        this.setReceiver(aMessage.getSender());
        this.setSender(aMessage.getReceiver());
    }

    public void write(int aValue) {
        String num = "" + aValue;
        this.write(num);
    }

    public void write(String aValue) {
        if (aValue == null) {
            throw new IllegalArgumentException("aValue is null");
        }
        try {
            this.write(aValue.getBytes(DEFAULT_CHARSET));
        }
        catch (UnsupportedEncodingException e) {
            Logger.ELOG(3, "CommsMessage.write failed", e);
        }
    }

    public void write(byte[] aValue) {
        if (aValue == null) {
            throw new IllegalArgumentException("aValue is null");
        }
        try {
            DataOutputStream dos = new DataOutputStream(this.iOutputStream);
            String len = "" + aValue.length + " ";
            byte[] bytes = len.getBytes(DEFAULT_CHARSET);
            dos.write(bytes, 0, bytes.length);
            dos.write(aValue, 0, aValue.length);
        }
        catch (IOException e) {
            Logger.ELOG(3, "CommsMessage.write failed", e);
        }
    }

    public int readInt() {
        String str = this.readString();
        int i = 0;
        try {
            i = Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            Logger.WLOG(3, "CommsMessage.readInt failed", e);
        }
        return i;
    }

    public String readString() {
        byte[] bytes = this.readBytes();
        String str = "";
        try {
            str = new String(bytes, 0, bytes.length, DEFAULT_CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            Logger.ELOG(3, "CommsMessage.readString failed", e);
        }
        return str;
    }

    public byte[] readBytes() {
        if (this.iInputStream == null) {
            return new byte[0];
        }
        int length = this.readLength(this.iInputStream);
        byte[] bytes = new byte[length];
        this.iInputStream.read(bytes, 0, bytes.length);
        return bytes;
    }

    private int readLength(ByteArrayInputStream bais) {
        int length = 0;
        try {
            byte b;
            int i;
            byte[] len = new byte[10];
            byte delim = 32;
            DataInputStream dis = new DataInputStream(bais);
            for (i = 0; i < len.length && (b = dis.readByte()) != delim; ++i) {
                len[i] = b;
            }
            String str = new String(len, 0, i, DEFAULT_CHARSET);
            length = Integer.parseInt(str);
        }
        catch (IOException e) {
            Logger.WLOG(3, "CommsMessage.readLength failed", e);
        }
        return length;
    }

    private int reverseBytes(int aValue) {
        int b1 = aValue >> 0 & 0xFF;
        int b2 = aValue >> 8 & 0xFF;
        int b3 = aValue >> 16 & 0xFF;
        int b4 = aValue >> 24 & 0xFF;
        return b1 << 24 | b2 << 16 | b3 << 8 | b4 << 0;
    }
}

