/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.file;

import com.nokia.mj.impl.file.FileLogger;
import com.nokia.mj.impl.file.FileSystemUtils;
import com.nokia.mj.impl.fileutils.FileUTF8Handler;
import java.io.IOException;
import java.util.Vector;

final class FileConnectionURL {
    private static String FILE_SIMPLE = "file:///";
    private static String FILE_LOCALHOST = "file://localhost/";
    private String iInitialUrl;
    private String iRootPath;
    private String iPath;
    private String iName;

    public FileConnectionURL(String aUrl) throws IOException {
        this(aUrl, true);
    }

    public FileConnectionURL(String aUrl, boolean aUnescapeUrl) throws IOException {
        this(aUrl, aUrl, aUnescapeUrl);
    }

    public FileConnectionURL(String aInitialUrl, String aUrl, boolean aUnescapeUrl) throws IOException {
        this.iInitialUrl = aInitialUrl;
        String unescapedUrl = aUrl;
        unescapedUrl = aUnescapeUrl ? FileUTF8Handler.decode(aUrl) : aUrl;
        unescapedUrl = unescapedUrl.replace('|', ':');
        FileConnectionURL.checkFileUrlValidity(unescapedUrl);
        String path = null;
        path = unescapedUrl;
        if (this.iInitialUrl.startsWith(FILE_LOCALHOST)) {
            path = unescapedUrl.substring(FILE_LOCALHOST.length());
        } else if (this.iInitialUrl.startsWith(FILE_SIMPLE)) {
            path = unescapedUrl.substring(FILE_SIMPLE.length());
        }
        String actualPath = path;
        if (actualPath.length() < 3 && actualPath.charAt(1) == ':') {
            actualPath = actualPath + "/";
        }
        FileLogger.Log("FileConnectionURL: Resolved  Path: " + actualPath);
        Vector roots = FileSystemUtils.listRoots();
        for (int i = 0; i < roots.size(); ++i) {
            if (!actualPath.toLowerCase().startsWith(((String)roots.elementAt(i)).toLowerCase()) && !actualPath.startsWith((String)roots.elementAt(i))) continue;
            this.iRootPath = actualPath.substring(0, ((String)roots.elementAt(i)).length());
            FileLogger.Log("FileConnectionURL: Root Path: " + this.iRootPath);
        }
        String filePath = actualPath.substring(this.iRootPath.length());
        FileLogger.Log("FileConnectionURL: File Path: " + filePath);
        if (filePath.endsWith("/")) {
            filePath = filePath.substring(0, filePath.length() - 1);
        }
        this.iPath = filePath.substring(0, filePath.lastIndexOf(47) + 1);
        this.iName = filePath.substring(filePath.lastIndexOf(47) + 1);
    }

    public String getPath() {
        String retVal = !this.iRootPath.startsWith("/") ? "/" + this.iRootPath + this.iPath : this.iRootPath + this.iPath;
        if (retVal == null) {
            return "";
        }
        return retVal;
    }

    public String getName() {
        if (this.iName != null) {
            return this.iName;
        }
        return "";
    }

    public String getUrl() {
        return FileUTF8Handler.encode(this.iInitialUrl);
    }

    public static void checkFileUrlValidity(String aFileUrl) {
        boolean result = true;
        String name = aFileUrl;
        if (name.indexOf(42) != -1 || name.indexOf(92) != -1) {
            throw new IllegalArgumentException();
        }
        if (name.indexOf(63) != -1 || name.indexOf(60) != -1 || name.indexOf(60) != -1) {
            throw new IllegalArgumentException();
        }
        if (name.indexOf("/./") != -1 || name.indexOf("/../") != -1 || name.indexOf("/..") != -1 || name.endsWith("/.")) {
            throw new IllegalArgumentException();
        }
    }
}

