/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.file;

import com.nokia.mj.impl.file.FileAccessHelper;
import com.nokia.mj.impl.file.FileInternalPermission;
import com.nokia.mj.impl.file.FileLogger;
import com.nokia.mj.impl.file.FileSystemUtils;
import com.nokia.mj.impl.fileutils.DriveInfo;
import com.nokia.mj.impl.fileutils.DriveListener;
import com.nokia.mj.impl.fileutils.DriveUtilities;
import com.nokia.mj.impl.rt.support.ApplicationUtils;
import com.nokia.mj.impl.rt.support.Jvm;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.io.file.FileSystemListener;

public final class FileSystemRegistryImpl
implements DriveListener {
    private static Vector iListeners = new Vector();
    private static Object iListenerLock = new Object();
    private static FileSystemRegistryImpl iDriveListener;

    private FileSystemRegistryImpl() {
    }

    public static Enumeration listRoots() {
        FileLogger.Log("--> FileSystemRegistry.listRoots()");
        ApplicationUtils appUtils = ApplicationUtils.getInstance();
        FileInternalPermission perm = new FileInternalPermission("", "read");
        appUtils.checkPermission(perm);
        String domain = FileSystemUtils.getProtectionDomain();
        Vector rootVector = FileSystemUtils.listRoots();
        Vector retValue = new Vector();
        for (int index = 0; index < rootVector.size(); ++index) {
            if (!FileAccessHelper.accessAllowed((String)rootVector.elementAt(index), "read", domain, false)) continue;
            retValue.addElement(rootVector.elementAt(index));
        }
        FileLogger.Log("<-- FileSystemRegistry.listRoots()");
        return retValue.elements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean addFileSystemListener(FileSystemListener aListener) {
        FileLogger.Log("--> FileSystemregistryImpl.addFileSystemListener()");
        if (aListener == null) {
            throw new NullPointerException("Argument passed was null");
        }
        ApplicationUtils appUtils = ApplicationUtils.getInstance();
        FileInternalPermission perm = new FileInternalPermission("", "read");
        appUtils.checkPermission(perm);
        boolean regSuccess = true;
        Object object = iListenerLock;
        synchronized (object) {
            iListeners.addElement(aListener);
            if (1 == iListeners.size()) {
                iDriveListener = new FileSystemRegistryImpl();
                regSuccess = DriveUtilities.registerListener(iDriveListener);
            }
        }
        FileLogger.Log("<-- FileSystemregistryImpl.addFileSystemListener()  returns: " + regSuccess);
        return regSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeFileSystemListener(FileSystemListener aListener) {
        FileLogger.Log("--> FileSystemregistryImpl.removeFileSystemListener()");
        if (aListener == null) {
            throw new NullPointerException("Argument passed was null");
        }
        boolean unregStatus = true;
        Object object = iListenerLock;
        synchronized (object) {
            iListeners.removeElement(aListener);
            if (0 == iListeners.size()) {
                unregStatus = DriveUtilities.unregisterListener(iDriveListener);
                iDriveListener = null;
            }
        }
        FileLogger.Log("<-- FileSystemregistryImpl.removeFileSystemListener() returns: " + unregStatus);
        return unregStatus;
    }

    static void notifyListeners(int aStatus, String aRoot) {
        FileLogger.Log("--> FileSystemregistryImpl.notifyListeners()");
        FileSystemListener tmpObj = null;
        for (int index = 0; index < iListeners.size(); ++index) {
            tmpObj = (FileSystemListener)iListeners.elementAt(index);
            tmpObj.rootChanged(aStatus, aRoot);
        }
        FileLogger.Log("<-- FileSystemregistryImpl.notifyListeners()");
    }

    public void driveChanged(int aOperation, DriveInfo aDriveInfo) {
        FileLogger.Log("--> FileSystemregistryImpl.driveChanged()");
        if (aOperation == 1) {
            FileSystemRegistryImpl.notifyListeners(0, aDriveInfo.iRootPath.replace('\\', '/'));
        }
        if (aOperation == 2) {
            FileSystemRegistryImpl.notifyListeners(1, aDriveInfo.iRootPath.replace('\\', '/'));
        }
        FileLogger.Log("<-- FileSystemregistryImpl.driveChanged()");
    }

    static {
        try {
            Jvm.loadSystemLibrary("javafile");
        }
        catch (Exception e) {
            FileLogger.ELog("Unable to load javafile native library");
        }
    }
}

