/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.fileutils;

import com.nokia.mj.impl.comms.CommsEndpoint;
import com.nokia.mj.impl.comms.CommsListener;
import com.nokia.mj.impl.comms.CommsMessage;
import com.nokia.mj.impl.comms.exception.CommsException;
import com.nokia.mj.impl.fileutils.DriveInfo;
import com.nokia.mj.impl.fileutils.DriveListener;
import com.nokia.mj.impl.fileutils.DriveObserverMessages;
import com.nokia.mj.impl.utils.Logger;
import java.util.Vector;

final class DriveListenerImpl
implements CommsListener {
    private static Vector iDriveListeners = null;
    private static CommsEndpoint iComms = null;
    private static boolean iCommsOwner = false;
    private static DriveListenerImpl iDriveListenerImpl = null;

    DriveListenerImpl() {
    }

    public static boolean registerListenerStatic(DriveListener aListener) {
        Logger.LOG(13, 4, "--> DriveListenerImpl.registerListenerStatic()");
        boolean regSuccess = DriveListenerImpl.getInstance().registerListener(aListener);
        Logger.LOG(13, 4, "<-- DriveListenerImpl.registerListenerStatic() returns " + regSuccess);
        return regSuccess;
    }

    public static boolean unregisterListenerStatic(DriveListener aListener) {
        Logger.LOG(13, 4, "--> DriveListenerImpl.unregisterListenerStatic()");
        boolean unregSuccess = DriveListenerImpl.getInstance().unregisterListener(aListener);
        Logger.LOG(13, 4, "<-- DriveListenerImpl.unregisterListenerStatic() returns " + unregSuccess);
        return unregSuccess;
    }

    private static Vector getListeners() {
        if (null == iDriveListeners) {
            iDriveListeners = new Vector();
        }
        return iDriveListeners;
    }

    private static CommsEndpoint getComms() {
        if (null == iComms) {
            iComms = CommsEndpoint.find("javacaptain");
            if (null == iComms) {
                iComms = new CommsEndpoint();
                iComms.connect(10000);
                iCommsOwner = true;
            }
            iComms.registerListener(51, DriveListenerImpl.getInstance());
        }
        return iComms;
    }

    private static DriveListenerImpl getInstance() {
        if (null == iDriveListenerImpl) {
            iDriveListenerImpl = new DriveListenerImpl();
        }
        return iDriveListenerImpl;
    }

    boolean registerListener(DriveListener aListener) {
        Logger.LOG(13, 4, "--> DriveListenerImpl.registerListener()");
        boolean regSuccess = true;
        try {
            Logger.LOG(13, 4, "    listeners before " + DriveListenerImpl.getListeners().size());
            if (DriveListenerImpl.getListeners().size() == 0 && null != DriveListenerImpl.getComms()) {
                DriveObserverMessages.subscribeEvents(DriveListenerImpl.getComms(), false);
            }
            DriveListenerImpl.getListeners().addElement(aListener);
            Logger.LOG(13, 4, "    listeners after " + DriveListenerImpl.getListeners().size());
        }
        catch (CommsException e) {
            regSuccess = false;
            Logger.ELOG(13, "registerListener failed", e);
        }
        Logger.LOG(13, 4, "<-- DriveListenerImpl.registerListener() returns " + regSuccess);
        return regSuccess;
    }

    boolean unregisterListener(DriveListener aListener) {
        Logger.LOG(13, 4, "--> DriveListenerImpl.unregisterListener()");
        boolean unregSuccess = true;
        Logger.LOG(13, 4, "    listeners before " + DriveListenerImpl.getListeners().size());
        DriveListenerImpl.getListeners().removeElement(aListener);
        Logger.LOG(13, 4, "    listeners after " + DriveListenerImpl.getListeners().size());
        try {
            if (DriveListenerImpl.getListeners().size() == 0 && null != DriveListenerImpl.getComms()) {
                DriveObserverMessages.subscribeEvents(DriveListenerImpl.getComms(), true);
                DriveListenerImpl.getComms().unregisterListener(51);
                if (iCommsOwner) {
                    DriveListenerImpl.getComms().destroy();
                    iCommsOwner = false;
                }
                iComms = null;
            }
        }
        catch (CommsException e) {
            unregSuccess = false;
            Logger.ELOG(13, "unregisterListener failed", e);
        }
        Logger.LOG(13, 4, "<-- DriveListenerImpl.unregisterListener()");
        return unregSuccess;
    }

    public void processMessage(CommsMessage aMessage) {
        Logger.LOG(13, 4, "--> DriveListenerImpl.processMessage()");
        switch (aMessage.getMessageId()) {
            case 3: {
                int oper = aMessage.readInt();
                DriveInfo drive = DriveObserverMessages.extractDriveInfo(aMessage);
                int listenersCount = DriveListenerImpl.getListeners().size();
                for (int i = 0; i < listenersCount; ++i) {
                    DriveListener listener = (DriveListener)DriveListenerImpl.getListeners().elementAt(i);
                    listener.driveChanged(oper, drive);
                }
                break;
            }
        }
        Logger.LOG(13, 4, "<-- DriveListenerImpl.processMessage()");
    }
}

