/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.fileutils;

import com.nokia.mj.impl.fileutils.FileStreamHandler;
import java.io.IOException;
import java.io.InputStream;

class FileInputStream
extends InputStream {
    private static int EOF = -1;
    private FileStreamHandler iDataSource;
    private boolean iIsClosed;
    private final Object iCloseLock;
    private final byte[] iSingleByte;
    private byte[] iMarkBuffer;
    private int iMarkBufferOffset;
    private int iMarkLength;
    private boolean iReadFromMarkBuffer;
    private int iMarkReadOffset;

    public FileInputStream(FileStreamHandler aDataSource) {
        this.iDataSource = aDataSource;
        this.iIsClosed = false;
        this.iCloseLock = new Object();
        this.iSingleByte = new byte[1];
        this.iMarkBuffer = null;
        this.iMarkBufferOffset = 0;
        this.iMarkLength = 0;
        this.iReadFromMarkBuffer = false;
        this.iMarkReadOffset = 0;
    }

    public int read() throws IOException {
        if (this.read(this.iSingleByte, 0, 1) == EOF) {
            return EOF;
        }
        return this.iSingleByte[0] & 0xFF;
    }

    public synchronized int read(byte[] aBytes, int aOffset, int aLength) throws IOException {
        this.throwIfClosed();
        FileStreamHandler.checkIOParams(aBytes, aOffset, aLength);
        if (aLength == 0) {
            return 0;
        }
        int retVal = this.handleMarkAndReset(aBytes, aOffset, aLength);
        retVal = 0 == retVal ? (retVal = EOF) : retVal;
        return retVal;
    }

    private int handleMarkAndReset(byte[] aBytes, int aOffset, int aLength) throws IOException {
        if (this.iMarkLength > 0) {
            if (!this.iReadFromMarkBuffer) {
                int retVal = this.iDataSource.readBytes(aBytes, aOffset, aLength);
                if (this.iMarkBufferOffset + retVal > this.iMarkLength) {
                    this.iMarkLength = 0;
                    this.iMarkBuffer = null;
                    this.iMarkBufferOffset = 0;
                } else {
                    System.arraycopy((Object)aBytes, aOffset, (Object)this.iMarkBuffer, this.iMarkBufferOffset, retVal);
                    this.iMarkBufferOffset += retVal;
                }
                return retVal;
            }
            if (aLength <= this.iMarkBufferOffset - this.iMarkReadOffset) {
                System.arraycopy((Object)this.iMarkBuffer, this.iMarkReadOffset, (Object)aBytes, aOffset, aLength);
                this.iMarkReadOffset += aLength;
                return aLength;
            }
            int readableData = this.iMarkBufferOffset - this.iMarkReadOffset;
            System.arraycopy((Object)this.iMarkBuffer, this.iMarkReadOffset, (Object)aBytes, aOffset, readableData);
            this.iMarkReadOffset += readableData;
            int nativeRead = this.iDataSource.readBytes(aBytes, aOffset + readableData, aLength - readableData);
            if (nativeRead > 0) {
                if (this.iMarkBufferOffset == this.iMarkLength) {
                    this.iMarkBuffer = null;
                    this.iMarkLength = 0;
                    this.iMarkBufferOffset = 0;
                    this.iReadFromMarkBuffer = false;
                } else if (this.iMarkBufferOffset + nativeRead <= this.iMarkLength) {
                    System.arraycopy((Object)aBytes, aOffset + readableData, (Object)this.iMarkBuffer, this.iMarkBufferOffset, nativeRead);
                    this.iMarkBufferOffset += nativeRead;
                    this.iMarkReadOffset += nativeRead;
                } else {
                    this.iMarkBuffer = null;
                    this.iMarkLength = 0;
                    this.iMarkBufferOffset = 0;
                    this.iReadFromMarkBuffer = false;
                }
            } else {
                this.iMarkBuffer = null;
                this.iMarkLength = 0;
                this.iMarkBufferOffset = 0;
                this.iReadFromMarkBuffer = false;
            }
            return readableData + nativeRead;
        }
        return this.iDataSource.readBytes(aBytes, aOffset, aLength);
    }

    public synchronized int available() throws IOException {
        this.throwIfClosed();
        return (int)this.iDataSource.available();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.iCloseLock;
        synchronized (object) {
            if (!this.iIsClosed) {
                this.iIsClosed = true;
                this.iDataSource.stopRead();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isClosed() {
        Object object = this.iCloseLock;
        synchronized (object) {
            return this.iIsClosed;
        }
    }

    public boolean markSupported() {
        return true;
    }

    public synchronized void mark(int aReadLimit) {
        if (aReadLimit <= 0) {
            return;
        }
        if (this.iReadFromMarkBuffer) {
            int readableData = this.iMarkBufferOffset - this.iMarkReadOffset;
            int lengthToCopy = readableData < aReadLimit ? readableData : aReadLimit;
            byte[] tempBuffer = new byte[aReadLimit];
            System.arraycopy((Object)this.iMarkBuffer, this.iMarkReadOffset, (Object)tempBuffer, 0, lengthToCopy);
            this.iMarkBuffer = tempBuffer;
            this.iMarkBufferOffset = lengthToCopy;
            this.iMarkLength = aReadLimit;
            this.iMarkReadOffset = 0;
            if (readableData > aReadLimit) {
                this.iDataSource.skip(aReadLimit - readableData);
            }
        } else {
            this.iMarkBuffer = new byte[aReadLimit];
            this.iMarkBufferOffset = 0;
            this.iMarkLength = aReadLimit;
            this.iReadFromMarkBuffer = false;
        }
    }

    public synchronized void reset() throws IOException {
        if (this.iMarkLength <= 0) {
            throw new IOException("Point of mark operation is invalid");
        }
        this.iReadFromMarkBuffer = true;
        this.iMarkReadOffset = 0;
    }

    protected synchronized void throwIfClosed() throws IOException {
        if (this.iIsClosed) {
            throw new IOException("InputStream closed");
        }
    }
}

