/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.fileutils;

final class FileURL {
    private static String FILE_PREFIX = "file://";
    private static String FILE_VALID_START_1 = "file:///";
    private static String FILE_VALID_START_2 = "file://localhost/";
    public static final String S60_FILE_SEPARATOR = "\\";
    public static final String LINUX_FILE_SEPARATOR = "/";
    private boolean iIsS60Path = false;
    private String iUnescapedPath;
    private String iTargetPath;
    private String iTargetName;
    private String iSeparatorUsed;

    public FileURL(String aName) {
        String initialPath = aName;
        String path = "";
        if (aName.trim().length() <= 0) {
            throw new IllegalArgumentException();
        }
        if (aName.startsWith(FILE_PREFIX)) {
            this.validateUrlStart(aName);
            path = initialPath.substring(initialPath.indexOf(47, FILE_PREFIX.length()) + 1);
            if (initialPath.indexOf(S60_FILE_SEPARATOR) != -1) {
                throw new IllegalArgumentException();
            }
        } else {
            path = aName;
        }
        int endIndex = 0;
        String tempName = path;
        while (tempName.indexOf("//") != -1) {
            endIndex = path.indexOf("//");
            tempName = path.substring(0, endIndex);
            if (endIndex >= path.length()) continue;
            tempName = tempName + path.substring(endIndex + 1);
        }
        path = tempName;
        FileURL.checkPathValidity(path);
        this.iUnescapedPath = path;
        this.iIsS60Path = this.iUnescapedPath.indexOf(S60_FILE_SEPARATOR) != -1;
        int index = 0;
        if (this.iIsS60Path) {
            this.iSeparatorUsed = S60_FILE_SEPARATOR;
            index = this.iUnescapedPath.lastIndexOf(92, this.iUnescapedPath.length() - 2);
        } else {
            this.iSeparatorUsed = LINUX_FILE_SEPARATOR;
            index = this.iUnescapedPath.lastIndexOf(47, this.iUnescapedPath.length() - 2);
        }
        this.iTargetName = this.iUnescapedPath.substring(index + 1);
        this.iTargetPath = this.iUnescapedPath.substring(0, index + 1);
    }

    private void validateUrlStart(String url) {
        if (url.startsWith(FILE_VALID_START_1) || url.startsWith(FILE_VALID_START_2)) {
            return;
        }
        throw new IllegalArgumentException();
    }

    public String getPath() {
        return this.iTargetPath;
    }

    public String getName() {
        return this.iTargetName;
    }

    public String getFullPath() {
        return this.iTargetPath + this.iTargetName;
    }

    protected String getSeparatorUsed() {
        return this.iSeparatorUsed;
    }

    public String getUrl() {
        String aUrl = FILE_VALID_START_1 + this.iTargetPath + this.iTargetName;
        String value = "";
        for (int i = 0; i < aUrl.length(); ++i) {
            char ch = aUrl.charAt(i);
            if (ch == '\\') {
                value = value + LINUX_FILE_SEPARATOR;
                continue;
            }
            boolean isLetter = ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z';
            boolean isDigit = ch >= '0' && ch <= '9';
            value = isLetter || isDigit ? value + ch : value + FileURL.stringToHex("" + ch);
        }
        return value;
    }

    private static final void checkPathValidity(String name) {
        String separator = System.getProperty("file.separator");
        if (separator.equals(S60_FILE_SEPARATOR)) {
            FileURL.makeS60SpecificChecks(name);
        } else {
            FileURL.makeLinuxSpecificChecks(name);
        }
        if (name.indexOf(42) != -1 || name.indexOf(63) != -1 || name.indexOf(60) != -1 || name.indexOf(62) != -1 || name.indexOf(59) != -1 || name.indexOf("//") != -1 || name.indexOf("..") != -1 || name.endsWith("/.")) {
            throw new IllegalArgumentException(name);
        }
    }

    private static final void makeS60SpecificChecks(String name) {
        int firstIndexOfColon = name.indexOf(58);
        int indexOfColon = name.indexOf(58, firstIndexOfColon + 1);
        if (indexOfColon != -1) {
            throw new IllegalArgumentException(name);
        }
        if (name.indexOf(S60_FILE_SEPARATOR) != -1) {
            if (name.indexOf(LINUX_FILE_SEPARATOR) != -1) {
                throw new IllegalArgumentException(name);
            }
            if (firstIndexOfColon > name.indexOf(S60_FILE_SEPARATOR)) {
                throw new IllegalArgumentException(name);
            }
        } else if (firstIndexOfColon > name.indexOf(LINUX_FILE_SEPARATOR)) {
            throw new IllegalArgumentException(name);
        }
    }

    private static final void makeLinuxSpecificChecks(String name) {
        if (name.indexOf(58) != -1) {
            throw new IllegalArgumentException(name);
        }
        if (name.indexOf(S60_FILE_SEPARATOR) != -1) {
            throw new IllegalArgumentException(name);
        }
    }

    public static final String stringToHex(String str) {
        if (str == null) {
            return "";
        }
        int length = str.length();
        StringBuffer result = new StringBuffer(length * 4);
        FileURL.stringToHex(str, result);
        return result.toString();
    }

    public static final void stringToHex(String str, StringBuffer out) {
        if (str == null) {
            return;
        }
        int length = str.length();
        for (int pos = 0; pos < length; ++pos) {
            int cur_char = str.charAt(pos);
            int this_char = cur_char;
            if (this_char < 127 && cur_char != 32) {
                out.append((char)this_char);
                continue;
            }
            for (int digit = 0; digit < 4; ++digit) {
                int this_digit = this_char & 0xF000;
                this_char <<= 4;
                this_digit >>= 12;
                if (digit == 2) {
                    out.append('%');
                }
                if (digit < 2) continue;
                if (this_digit >= 10) {
                    out.append((char)(this_digit + 87));
                    continue;
                }
                out.append((char)(this_digit + 48));
            }
        }
    }
}

