/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.fileutils;

import com.nokia.mj.impl.fileutils.FileDRMContentHandler;
import com.nokia.mj.impl.fileutils.FilePlatformSpecifics;
import com.nokia.mj.impl.fileutils.FileStreamHandler;
import com.nokia.mj.impl.fileutils.FileURL;
import com.nokia.mj.impl.fileutils.FileUTF8Handler;
import com.nokia.mj.impl.rt.support.Finalizer;
import com.nokia.mj.impl.rt.support.Jvm;
import com.nokia.mj.impl.utils.Logger;
import com.nokia.mj.impl.utils.Tokenizer;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;

public final class FileUtility {
    private FileURL iTarget;
    private Finalizer iFinalizer;
    private FileStreamHandler iStreamHandler;
    private int iDrmIntent;
    private boolean iExecuteIntent;

    public FileUtility(String aFilePath) {
        this(aFilePath, 3, false);
    }

    public FileUtility(String aFilePath, int aDrmIntent, boolean aExecuteIntent) {
        this.iTarget = new FileURL(aFilePath);
        this.iFinalizer = this.registerFinalize();
        this.iStreamHandler = null;
        this.iDrmIntent = aDrmIntent;
        this.iExecuteIntent = aExecuteIntent;
    }

    private Finalizer registerFinalize() {
        return new Finalizer(){

            public void finalizeImpl() {
                FileUtility.this.doFinalize();
            }
        };
    }

    public static FileUtility createTempFile(String aPrefix, String aSuffix, FileUtility aDirectory) throws IOException {
        String file;
        Logger.LOG(13, 4, "--> FileUtility.createTempFile() Prefix: " + aPrefix + " Suffix: " + aSuffix);
        if (aPrefix.length() < 3 || null == aDirectory) {
            throw new IllegalArgumentException("Directory passed is null or  file prefix is invalid");
        }
        if (!aDirectory.exists()) {
            Logger.WLOG(13, "    FileUtility.createTempFile(): Directory specified does not exist.");
            throw new IOException("Directory to create temp file does not exist: " + aDirectory);
        }
        if (!aDirectory.isDirectory()) {
            Logger.WLOG(13, "    FileUtility.createTempFile(): Argument passed is a file.");
            throw new IOException("Path specified specified is a file: " + aDirectory);
        }
        if (null == aSuffix) {
            aSuffix = ".tmp";
        }
        Random generator = new Random();
        int generated = 0;
        String parent = aDirectory.getPath() + aDirectory.getName();
        char separator = '/';
        if (parent.indexOf(92) != -1) {
            separator = '\\';
        }
        if (!parent.endsWith("" + separator)) {
            parent = parent + separator;
        }
        do {
            generated = generator.nextInt();
            String midString = "" + generated;
            midString = midString.substring(midString.length() - 5);
            file = aPrefix + midString + aSuffix;
        } while (FileUtility._exists(parent + file));
        Logger.LOG(13, 13, "    FileUtility.createTempFile(): Attempting to create " + parent + file);
        FileUtility newTempFile = new FileUtility(parent + file);
        if (!newTempFile.createNewFile()) {
            Logger.WLOG(13, "    FileUtility.createTempFile(): Create failed.");
            throw new IOException("Unable to create file: " + newTempFile);
        }
        Logger.LOG(13, 4, "<-- FileUtility.createTempFile()");
        return newTempFile;
    }

    public static String resolveDrive(String aPath) {
        Logger.LOG(13, 4, "--> FileUtility.resolveDrive() Path: " + aPath);
        String retVal = null;
        String path = aPath;
        try {
            retVal = FilePlatformSpecifics.resolveDrive(path);
        }
        catch (Exception e) {
            retVal = null;
        }
        Logger.LOG(13, 4, "<-- FileUtility.resolveDrive() returns: " + retVal);
        return retVal;
    }

    public static String getCanonicalPath(String aPath) throws IOException {
        char separator;
        Logger.LOG(13, 4, "--> FileUtility.getCanonicalPath() Path: " + aPath);
        String tmpPath = aPath;
        if (tmpPath.endsWith("/") || tmpPath.endsWith("\\")) {
            tmpPath = aPath.substring(0, aPath.length() - 1);
        }
        if (tmpPath.indexOf("/") != -1) {
            separator = '/';
            if (tmpPath.indexOf("\\") != -1) {
                throw new IllegalArgumentException("Invalid path separator: " + aPath);
            }
        } else {
            separator = '\\';
            if (tmpPath.indexOf("/") != -1) {
                throw new IllegalArgumentException("Invalid path separator: " + aPath);
            }
        }
        String[] pathTokens = Tokenizer.split(tmpPath, "" + separator);
        String initialPath = pathTokens[0];
        if (pathTokens == null) {
            initialPath = "";
        }
        initialPath = initialPath + separator;
        String path = FileUtility._getRealPath(initialPath);
        int count = 1;
        String sub = null;
        while (count < pathTokens.length) {
            sub = pathTokens[count];
            ++count;
            if (sub == null || sub.equals(".")) continue;
            if (sub.equals("..")) {
                if (path.indexOf(separator) == path.lastIndexOf(separator)) continue;
                path = path.substring(0, path.lastIndexOf(separator, path.length() - 2));
            } else {
                if (!path.endsWith("" + separator)) {
                    path = path + separator;
                }
                path = path + sub;
            }
            if (count != pathTokens.length) {
                path = path + separator;
            }
            path = FileUtility._getRealPath(path);
        }
        String toReturn = FileUtility._getRealPath(path);
        Logger.LOG(13, 4, "<-- FileUtility.getCanonicalPath(): " + toReturn);
        return toReturn;
    }

    public static String getContentId(String aPath) {
        return FilePlatformSpecifics.getContentId(aPath);
    }

    private void createStreamHandler() {
        if (null == this.iStreamHandler) {
            String name = this.iTarget.getFullPath();
            if (FileDRMContentHandler.isDRMProtectedFile(name)) {
                Logger.LOG(13, 4, "FileUtility.checkStreamHandler(): Choosing DRM content handler");
                this.iStreamHandler = new FileDRMContentHandler(name, this.iDrmIntent, this.iExecuteIntent);
            } else {
                Logger.LOG(13, 4, "FileUtility.checkStreamHandler(): Choosing normal stream handler");
                this.iStreamHandler = new FileStreamHandler(name);
            }
        }
    }

    public InputStream openInputStream() throws IOException {
        if (!this.exists()) {
            throw new IOException("Path specified does not exist: " + this.iTarget.getFullPath());
        }
        if (this.isDirectory()) {
            throw new IOException("Path specified is a directory: " + this.iTarget.getFullPath());
        }
        this.createStreamHandler();
        this.iStreamHandler.openFileForReading();
        return this.iStreamHandler.openInputStream();
    }

    public DataInputStream openDataInputStream() throws IOException {
        if (!this.exists()) {
            throw new IOException("Path specified does not exist: " + this.iTarget.getFullPath());
        }
        if (this.isDirectory()) {
            throw new IOException("Path specified is a directory: " + this.iTarget.getFullPath());
        }
        this.createStreamHandler();
        this.iStreamHandler.openFileForReading();
        return this.iStreamHandler.openDataInputStream();
    }

    public OutputStream openOutputStream() throws IOException {
        if (!this.exists()) {
            throw new IOException("Path specified does not exist: " + this.iTarget.getFullPath());
        }
        if (this.isDirectory()) {
            throw new IOException("Path specified is a directory: " + this.iTarget.getFullPath());
        }
        this.createStreamHandler();
        this.iStreamHandler.openFileForWriting(0L);
        return this.iStreamHandler.openOutputStream();
    }

    public DataOutputStream openDataOutputStream() throws IOException {
        if (!this.exists()) {
            throw new IOException("Path specified does not exist: " + this.iTarget.getFullPath());
        }
        if (this.isDirectory()) {
            throw new IOException("Path specified is a directory: " + this.iTarget.getFullPath());
        }
        this.createStreamHandler();
        this.iStreamHandler.openFileForWriting(0L);
        return this.iStreamHandler.openDataOutputStream();
    }

    public OutputStream openOutputStream(long aByteOffset) throws IOException {
        if (aByteOffset < 0L) {
            throw new IllegalArgumentException();
        }
        if (!this.exists()) {
            throw new IOException("Path specified does not exist: " + this.iTarget.getFullPath());
        }
        if (this.isDirectory()) {
            throw new IOException("Path specified is a directory: " + this.iTarget.getFullPath());
        }
        this.createStreamHandler();
        this.iStreamHandler.openFileForWriting(aByteOffset);
        return this.iStreamHandler.openOutputStream();
    }

    public boolean isFile() {
        return this._isFile(this.iTarget.getFullPath());
    }

    public boolean isDirectory() {
        return this._isDirectory(this.iTarget.getFullPath());
    }

    public boolean exists() {
        return FileUtility._exists(this.iTarget.getFullPath());
    }

    public boolean canRead() {
        if (!this.exists()) {
            return false;
        }
        return this._canRead(this.iTarget.getFullPath());
    }

    public boolean canWrite() {
        if (!this.exists()) {
            return false;
        }
        return this._canWrite(this.iTarget.getFullPath());
    }

    public boolean isHidden(String aPath) {
        return this._isHidden(aPath);
    }

    public boolean isHidden() {
        if (!this.exists()) {
            return false;
        }
        return this._isHidden(this.iTarget.getFullPath());
    }

    public void setReadable(boolean aReadable) throws IOException {
        if (!this.exists()) {
            throw new IOException("Path specified does not exist: " + this.iTarget.getFullPath());
        }
        if (this.canRead() == aReadable) {
            return;
        }
        this._setReadable(this.iTarget.getFullPath(), aReadable);
    }

    public void setWritable(boolean aWritable) throws IOException {
        if (!this.exists()) {
            throw new IOException("Path specified does not exist: " + this.iTarget.getFullPath());
        }
        if (this.canWrite() == aWritable) {
            return;
        }
        if (this.iStreamHandler != null) {
            this.iStreamHandler.closeInputStreams();
            this.iStreamHandler.closeFileStream();
        }
        this._setWritable(this.iTarget.getFullPath(), aWritable);
    }

    public void setHidden(boolean aHidden) throws IOException {
        if (!this.exists()) {
            throw new IOException("Path specified does not exist: " + this.iTarget.getFullPath());
        }
        if (this.isHidden() == aHidden) {
            return;
        }
        if (this.iStreamHandler != null) {
            this.iStreamHandler.closeInputStreams();
            this.iStreamHandler.closeFileStream();
        }
        FilePlatformSpecifics.setHidden(this, aHidden);
    }

    public long fileSize() throws IOException {
        if (!FileUtility._exists(this.iTarget.getFullPath())) {
            return -1L;
        }
        if (!this.isFile()) {
            throw new IOException("Path specified is a directory: " + this.iTarget.getFullPath());
        }
        return this._fileSize(this.iTarget.getFullPath());
    }

    public long directorySize(boolean aIncludeSubDirs) throws IOException {
        if (!FileUtility._exists(this.iTarget.getFullPath())) {
            return -1L;
        }
        if (!this.isDirectory()) {
            throw new IOException("Path specified specified is a file: " + this.iTarget.getFullPath());
        }
        return this._dirSize(this.iTarget.getFullPath(), aIncludeSubDirs);
    }

    public long totalSize() {
        return this._totalSize(this.iTarget.getFullPath());
    }

    public long availableSize() {
        return this._availableSize(this.iTarget.getFullPath());
    }

    public long usedSize() {
        return this._usedSize(this.iTarget.getFullPath());
    }

    public long lastModified() {
        long value = this._lastModified(this.iTarget.getFullPath());
        return value * 1000L;
    }

    public String getName() {
        String name = this.iTarget.getName();
        return name;
    }

    public String getPath() {
        String name = this.iTarget.getPath();
        return name;
    }

    public FileUtility getParentFile() {
        String name = this.iTarget.getPath();
        if (null == name) {
            return null;
        }
        return new FileUtility(name);
    }

    public String getAbsolutePath() {
        return this.iTarget.getFullPath();
    }

    public String getURL() {
        return this.iTarget.getUrl();
    }

    public boolean createNewFile() throws IOException, SecurityException {
        String toCreate = this.iTarget.getFullPath();
        if (toCreate.endsWith("\\") || toCreate.endsWith("/")) {
            throw new IOException("Path specified is a directory: " + this.iTarget.getFullPath());
        }
        return this._createNewFile(toCreate);
    }

    public boolean mkdir() throws IOException, SecurityException {
        String toCreate = this.iTarget.getFullPath();
        if (this.exists()) {
            return false;
        }
        if (toCreate.endsWith("\\") || toCreate.endsWith("/")) {
            toCreate = toCreate.substring(0, toCreate.length() - 1);
        }
        return this._createNewDirectory(toCreate);
    }

    public boolean mkdirs() throws IOException, SecurityException {
        String fullPath = this.iTarget.getFullPath();
        String separator = "/";
        if (fullPath.indexOf("\\") != -1) {
            separator = "\\";
        }
        String[] pathTokens = Tokenizer.split(fullPath, separator);
        String progressivePath = "";
        for (int i = 1; i < pathTokens.length - 1; ++i) {
            if (pathTokens[i].equals("")) {
                throw new IllegalArgumentException();
            }
            FileUtility.checkRenameParameters(pathTokens[i]);
        }
        for (int dirs = 0; dirs < pathTokens.length; ++dirs) {
            if (pathTokens[dirs].equals("")) {
                progressivePath = progressivePath + separator;
                continue;
            }
            if (!FileUtility._exists(progressivePath = progressivePath + pathTokens[dirs]) && !this._createNewDirectory(progressivePath)) {
                return false;
            }
            progressivePath = progressivePath + separator;
        }
        return true;
    }

    public boolean delete() throws SecurityException {
        if (!this.canWrite()) {
            return false;
        }
        if (this.iStreamHandler != null) {
            this.iStreamHandler.closeInputStreams();
            this.iStreamHandler.closeOutputStreams();
        }
        return this._delete(this.iTarget.getFullPath());
    }

    public boolean rename(String aNewName) throws IOException, SecurityException {
        String toRename = aNewName.trim();
        if ((toRename = FileUTF8Handler.decode(toRename)).endsWith("\n")) {
            toRename = toRename.substring(0, toRename.length() - 1);
        }
        FileUtility.checkRenameParameters(toRename);
        if (!this.exists()) {
            throw new IOException("Path specified does not exist: " + this.iTarget.getFullPath());
        }
        if ((toRename.endsWith("\\") || toRename.endsWith("/")) && this.isFile()) {
            throw new IllegalArgumentException("Path specified specified is a file: " + this.iTarget.getFullPath());
        }
        String renameTo = this.iTarget.getPath() + toRename;
        FileURL newUrl = new FileURL(renameTo);
        if (FileUtility._exists(renameTo)) {
            throw new IOException();
        }
        if (this.iStreamHandler != null) {
            this.iStreamHandler.closeInputStreams();
            this.iStreamHandler.closeOutputStreams();
        }
        if (this._renameFile(this.iTarget.getFullPath(), newUrl.getFullPath())) {
            this.iTarget = newUrl;
            if (this.iStreamHandler != null) {
                this.iStreamHandler = new FileStreamHandler(this.iTarget.getFullPath());
            }
            return true;
        }
        return false;
    }

    public boolean renameTo(String aNewName) throws IOException {
        String renameTo = aNewName.trim();
        if (renameTo.endsWith("\n")) {
            renameTo = renameTo.substring(0, renameTo.length() - 1);
        }
        if (!this.exists()) {
            throw new IOException("Path specified does not exist: " + this.iTarget.getFullPath());
        }
        FileURL newUrl = new FileURL(renameTo);
        String separator = this.iTarget.getSeparatorUsed();
        FileUtility temp = new FileUtility(aNewName);
        if (renameTo.indexOf(separator) == -1) {
            throw new IllegalArgumentException("Invalid parameter");
        }
        FileUtility parentPath = temp.getParentFile();
        if (!parentPath.exists()) {
            parentPath.mkdirs();
        }
        parentPath = null;
        if (this.iStreamHandler != null) {
            this.iStreamHandler.closeInputStreams();
            this.iStreamHandler.closeOutputStreams();
        }
        if (this._renameFile(this.iTarget.getFullPath(), newUrl.getFullPath())) {
            this.iTarget = newUrl;
            if (this.iStreamHandler != null) {
                this.iStreamHandler = new FileStreamHandler(this.iTarget.getFullPath());
            }
            return true;
        }
        return false;
    }

    public String[] listFileArray(boolean aIncludeHidden) throws IOException {
        if (!FileUtility._exists(this.iTarget.getFullPath())) {
            throw new IOException("Path specified does not exist: " + this.iTarget.getFullPath());
        }
        if (this.isFile()) {
            throw new IOException("Path specified specified is a file: " + this.iTarget.getFullPath());
        }
        String fileListString = "";
        String path = this.iTarget.getFullPath();
        if (path.endsWith("/") || path.endsWith("\\")) {
            path = path.substring(0, path.length() - 1);
        }
        path = path.replace('\\', '/');
        fileListString = this._listDirContents(path, aIncludeHidden);
        String[] splitStrings = Tokenizer.split(fileListString, "*");
        String[] trimmed = new String[splitStrings.length - 1];
        for (int index = 0; index < splitStrings.length - 1; ++index) {
            trimmed[index] = splitStrings[index];
        }
        return trimmed;
    }

    public Vector listFiles(String aFilter, boolean aIncludeHidden) throws IOException {
        String filter = FileUtility.trimFilter(aFilter);
        FileUtility.checkFilter(filter);
        if (!FileUtility._exists(this.iTarget.getFullPath())) {
            throw new IOException("Path specified does not exist: " + this.iTarget.getFullPath());
        }
        if (this.isFile()) {
            throw new IOException("Path specified specified is a file: " + this.iTarget.getFullPath());
        }
        Vector fileList = new Vector();
        String[] splitStrings = this.listFileArray(aIncludeHidden);
        boolean matchFlag = false;
        for (int i = 0; i < splitStrings.length; ++i) {
            splitStrings[i] = splitStrings[i].trim();
            if (splitStrings[i].equals("")) continue;
            matchFlag = false;
            matchFlag = FileUtility.matchString(filter.toLowerCase(), splitStrings[i].toLowerCase());
            if (splitStrings[i].equals("./") || splitStrings[i].equals("../")) {
                matchFlag = false;
            }
            if (this.iTarget.getSeparatorUsed() != "/") {
                splitStrings[i] = splitStrings[i].replace('/', '\\');
            }
            if (!matchFlag) continue;
            fileList.addElement(splitStrings[i]);
        }
        return fileList;
    }

    public Enumeration list(String aFilter, boolean aIncludeHidden) throws IOException {
        Vector fileList = this.listFiles(aFilter, aIncludeHidden);
        return fileList.elements();
    }

    public Enumeration list() throws IOException {
        return this.list("", false);
    }

    public FileUtility[] listFiles() throws IOException {
        Vector fileList = this.listFiles("", false);
        FileUtility[] files = new FileUtility[fileList.size()];
        for (int i = 0; i < fileList.size(); ++i) {
            String element = this.iTarget.getFullPath();
            if (!element.endsWith(this.iTarget.getSeparatorUsed())) {
                element = element + this.iTarget.getSeparatorUsed();
            }
            files[i] = new FileUtility(element + fileList.elementAt(i));
        }
        return files;
    }

    public void truncate(long aByteOffset) throws IOException {
        if (aByteOffset < 0L) {
            throw new IllegalArgumentException("Argument value cannot be negative");
        }
        if (!this.exists()) {
            throw new IOException("File does not exist " + this.iTarget.getFullPath());
        }
        if (this.isDirectory()) {
            throw new IOException("Connection is a directory " + this.iTarget.getFullPath());
        }
        if (aByteOffset > this.fileSize()) {
            return;
        }
        this._truncate(this.iTarget.getFullPath(), aByteOffset);
    }

    private synchronized void doFinalize() {
        if (this.iFinalizer == null) {
            return;
        }
        this.iFinalizer = null;
        this.iStreamHandler = null;
    }

    public String toString() {
        return this.getAbsolutePath();
    }

    private static final void checkRenameParameters(String aName) throws IOException {
        boolean result = true;
        if (aName.indexOf(42) != -1 || aName.indexOf(92) != -1 || aName.indexOf(47) != -1 && !aName.endsWith("/") || aName.endsWith("//")) {
            throw new IllegalArgumentException();
        }
        if (aName.indexOf(63) != -1 || aName.indexOf(60) != -1 || aName.indexOf(60) != -1 || aName.indexOf(58) != -1 || aName.indexOf(124) != -1) {
            throw new IOException();
        }
    }

    private static String trimFilter(String aFilter) {
        String filter = FileUTF8Handler.decode(aFilter);
        filter = filter.trim();
        return filter;
    }

    private static void checkFilter(String aFilter) {
        if (aFilter.indexOf(63) != -1 || aFilter.indexOf(":") != -1 || aFilter.indexOf("/") != -1 || aFilter.indexOf("\\") != -1 || aFilter.indexOf("//") != -1 || aFilter.indexOf("|") != -1 || aFilter.indexOf("<") != -1 || aFilter.indexOf(">") != -1) {
            throw new IllegalArgumentException();
        }
    }

    public static boolean matchString(String aFilter, String aName) {
        Logger.LOG(13, 4, "--> FileUtility.matchString():  Filter: " + aFilter + " Name: " + aName);
        String filter = aFilter;
        filter = FileUtility.trimFilter(filter);
        if (filter.equals("*")) {
            Logger.LOG(13, 4, "<-- FileUtility.matchString(): returns true");
            return true;
        }
        String[] tokens = Tokenizer.split(filter, "*");
        int prevTokenEndIndex = 0;
        boolean matchFlag = true;
        prevTokenEndIndex = 0;
        matchFlag = true;
        int j = 0;
        for (j = 0; j < tokens.length; ++j) {
            if (tokens[j].equals("")) continue;
            int index = aName.indexOf(tokens[j], prevTokenEndIndex);
            if (-1 != index) {
                if (index >= prevTokenEndIndex) {
                    prevTokenEndIndex = aName.indexOf(tokens[j]) + tokens[j].length();
                    matchFlag = true;
                    continue;
                }
                matchFlag = false;
                break;
            }
            matchFlag = false;
            break;
        }
        if (matchFlag) {
            if (!filter.startsWith("*") && !aName.startsWith(tokens[0])) {
                matchFlag = false;
            }
            if (!filter.endsWith("*") && !aName.endsWith(tokens[tokens.length - 1])) {
                matchFlag = false;
            }
        }
        Logger.LOG(13, 4, "<-- FileUtility.matchString(): returns: " + matchFlag);
        return matchFlag;
    }

    private static native boolean _exists(String var0);

    private static native String _getRealPath(String var0) throws IOException;

    private native long _availableSize(String var1);

    private native boolean _canRead(String var1);

    private native boolean _canWrite(String var1);

    private native boolean _createNewDirectory(String var1) throws IOException, SecurityException;

    private native boolean _createNewFile(String var1) throws IOException, SecurityException;

    private native boolean _delete(String var1) throws SecurityException;

    private native long _dirSize(String var1, boolean var2);

    private native long _fileSize(String var1) throws IOException;

    private native boolean _isDirectory(String var1);

    private native boolean _isFile(String var1);

    private native boolean _isHidden(String var1);

    private native long _lastModified(String var1);

    private native String _listDirContents(String var1, boolean var2);

    private native boolean _renameFile(String var1, String var2) throws IOException, SecurityException;

    private native void _setReadable(String var1, boolean var2) throws IOException;

    private native void _setWritable(String var1, boolean var2) throws IOException;

    private native long _totalSize(String var1);

    private native void _truncate(String var1, long var2) throws IOException;

    private native long _usedSize(String var1);

    static {
        try {
            Jvm.loadSystemLibrary("javafileutils");
        }
        catch (Exception e) {
            Logger.ELOG(13, "Unable to load javafileutils dll");
        }
    }
}

