/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.gcf.protocol.btgoep;

import com.intel.bluetooth.UtilsStringTokenizer;
import com.nokia.mj.impl.bluetooth.BTOBEXPermission;
import com.nokia.mj.impl.bluetooth.utils.DebugLog;
import com.nokia.mj.impl.bluetooth.utils.PushUrlValidator;
import com.nokia.mj.impl.gcf.PushValidator;
import com.nokia.mj.impl.rt.support.ApplicationUtils;
import com.nokia.mj.impl.utils.Uid;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;

public class PushValidatorImpl
extends PushValidator {
    private static final String BTGOEP_PREFIX = "btgoep://";
    private static final String AUTHENTICATE = "authenticate";
    private static final String AUTHORIZE = "authorize";
    private static final String ENCRYPT = "encrypt";
    private static final String MASTER = "master";
    private static final String NAME = "name";
    private Vector pushBaseUris;
    private static final String BLACKLIST = "blacklist";
    private static final String AUTHENTICATED = "authenticated";
    private static final String AUTHORIZED = "authorized";
    private static Hashtable srvParams = new Hashtable();
    private static Hashtable filterParams = new Hashtable();

    public void validate(String aUri, String aFilter, Uid aSuiteUid, String aMidletName, boolean aIsStaticRegistration) throws IOException {
        DebugLog.debug(" +  BTGOEP PushValidator: Validate(): Uri: " + aUri + " Filter: " + aFilter);
        String host = null;
        String name = aUri;
        int hostEnd = name.indexOf(58, BTGOEP_PREFIX.length());
        if (hostEnd > -1) {
            host = name.substring(BTGOEP_PREFIX.length(), hostEnd);
            if (!host.equalsIgnoreCase("localhost")) {
                DebugLog.error(" -  BTGOEP PushValidator: Validate(): Not a host!");
                throw new IllegalArgumentException();
            }
        } else {
            DebugLog.error(" -  BTGOEP PushValidator: Validate(): Not proper format");
            throw new IllegalArgumentException();
        }
        String paramsStr = name.substring(hostEnd + 1);
        UtilsStringTokenizer urlTokens = new UtilsStringTokenizer(paramsStr, ";");
        if (urlTokens.hasMoreTokens()) {
            String uuid = urlTokens.nextToken();
            PushUrlValidator.checkUuidLength(uuid);
            PushUrlValidator.checkHexDig(uuid);
            PushUrlValidator.validateParams(srvParams, urlTokens);
        }
        if (aFilter != null || !aFilter.equals("") || !aFilter.equals("*")) {
            UtilsStringTokenizer filterTokens = new UtilsStringTokenizer(aFilter, ";");
            PushUrlValidator.validateFilterParams(filterParams, filterTokens);
        }
        String baseUri = this.getBaseURI(aUri);
        if (aIsStaticRegistration) {
            if (this.pushBaseUris == null) {
                this.pushBaseUris = new Vector();
                this.pushBaseUris.addElement(baseUri);
            } else {
                for (int indx = 0; indx < this.pushBaseUris.size(); ++indx) {
                    String uri = (String)this.pushBaseUris.elementAt(indx);
                    if (!uri.equalsIgnoreCase(baseUri)) continue;
                    throw new IllegalArgumentException();
                }
                this.pushBaseUris.addElement(aUri);
            }
        }
        Uid suiteUid = null;
        String commsName = null;
        if (aIsStaticRegistration) {
            suiteUid = aSuiteUid;
            commsName = "InstallerJavaCaptain";
        } else {
            commsName = "javacaptain";
        }
        if (PushValidator.isRegisteredPushUriStartingWith(baseUri, suiteUid, commsName)) {
            if (aIsStaticRegistration) {
                throw new IllegalArgumentException();
            }
            throw new IOException();
        }
        ApplicationUtils appUtils = ApplicationUtils.getInstance();
        BTOBEXPermission permission = new BTOBEXPermission("*", "server");
        appUtils.checkPermission(permission);
        PushUrlValidator.checkPowerAndDiscoverability(aMidletName, aIsStaticRegistration);
        DebugLog.debug(" -  BTGOEP PushValidator: Validate()");
    }

    private String getBaseURI(String aUri) {
        int endIndex = aUri.indexOf(";");
        String baseUri = endIndex < 0 ? aUri : aUri.substring(0, endIndex);
        return baseUri;
    }

    static {
        srvParams.put(AUTHENTICATE, AUTHENTICATE);
        srvParams.put(ENCRYPT, ENCRYPT);
        srvParams.put(MASTER, MASTER);
        srvParams.put(AUTHORIZE, AUTHORIZE);
        srvParams.put(NAME, NAME);
        filterParams.put(AUTHENTICATED, AUTHENTICATED);
        filterParams.put(AUTHORIZED, AUTHORIZED);
        filterParams.put(BLACKLIST, BLACKLIST);
    }
}

