/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.gcf.protocol.mms;

import com.nokia.mj.impl.gcf.utils.ConnectionBaseInterface;
import com.nokia.mj.impl.mms.MMSAddress;
import com.nokia.mj.impl.mms.MMSConnectionImpl;
import com.nokia.mj.impl.mms.MMSPermissionImpl;
import com.nokia.mj.impl.rt.support.ApplicationUtils;
import com.nokia.mj.impl.rt.support.Jvm;
import com.nokia.mj.impl.utils.Logger;
import java.io.IOException;
import javax.microedition.io.Connection;

public class Protocol
implements ConnectionBaseInterface {
    private final String MMS_PROTOCOL = "mms:";

    public Protocol() {
        Logger.LOG(15, 4, "Mms Protocol");
    }

    public Connection openPrim(String aName, int aMode, boolean aTimeouts) throws IOException {
        return this.openConnection(aName, aMode, aTimeouts);
    }

    public Connection openConnection(String aUri, int aMode, boolean aTimeouts) throws IOException {
        Logger.LOG(15, 4, "opening MMS Connection");
        String uri = "mms:" + aUri;
        MMSConnectionImpl conn = null;
        MMSAddress.validateUrl(uri);
        ApplicationUtils appUtils = ApplicationUtils.getInstance();
        MMSPermissionImpl permission = new MMSPermissionImpl("mms://*", "open");
        if (MMSAddress.getConnectionMode(aUri)) {
            appUtils.checkPermission(permission);
            Logger.LOG(15, 4, "Creating MMS Server Connection");
            conn = new MMSConnectionImpl(uri, true);
        } else {
            if (aMode == 1) {
                throw new IllegalArgumentException("MMS Client connection not allowed in READ Mode");
            }
            appUtils.checkPermission(permission);
            Logger.LOG(15, 4, "Creating MMS Client Connection");
            conn = new MMSConnectionImpl(uri, false);
        }
        conn.open();
        return conn;
    }

    static {
        try {
            Jvm.loadSystemLibrary("javawmamms");
        }
        catch (Exception e) {
            Logger.LOG(15, 1, e.toString());
        }
    }
}

