/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.gcf.protocol.sms;

import com.nokia.mj.impl.gcf.utils.ConnectionBaseInterface;
import com.nokia.mj.impl.rt.support.ApplicationUtils;
import com.nokia.mj.impl.rt.support.Jvm;
import com.nokia.mj.impl.sms.SMSConnectionImpl;
import com.nokia.mj.impl.sms.SMSPermissionImpl;
import com.nokia.mj.impl.smscbs.utils.WmaUrl;
import com.nokia.mj.impl.utils.Logger;
import java.io.IOException;
import javax.microedition.io.Connection;

public class Protocol
implements ConnectionBaseInterface {
    public Protocol() {
        Logger.LOG(15, 4, "Sms Protocol");
    }

    public Connection openPrim(String aName, int aMode, boolean aTimeouts) throws IOException {
        return this.openConnection(aName, aMode, aTimeouts);
    }

    public Connection openConnection(String aUri, int aMode, boolean aTimeouts) throws IOException {
        Logger.LOG(15, 4, "opening Sms Connection");
        SMSConnectionImpl msgConnection = null;
        WmaUrl smsuri = new WmaUrl(aUri, "sms:");
        smsuri.validateUri();
        ApplicationUtils appUtils = ApplicationUtils.getInstance();
        SMSPermissionImpl permission = new SMSPermissionImpl("sms://*", "open");
        if (smsuri.isServerModeConnection()) {
            appUtils.checkPermission(permission);
            Logger.LOG(15, 4, " creating Sms server connection");
            msgConnection = new SMSConnectionImpl(smsuri, true);
        } else {
            if (aMode == 1) {
                throw new IllegalArgumentException("Invalid Open Mode for SmsConnection");
            }
            appUtils.checkPermission(permission);
            Logger.LOG(15, 4, "creating Sms client connection");
            msgConnection = new SMSConnectionImpl(smsuri, false);
        }
        msgConnection.open();
        return msgConnection;
    }

    static {
        try {
            Jvm.loadSystemLibrary("javawma");
        }
        catch (Exception e) {
            Logger.LOG(15, 4, e.toString());
        }
    }
}

