/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.gcf.protocol.socket;

import com.nokia.mj.impl.connectionmanager.AccessPoint;
import com.nokia.mj.impl.connectionmanager.ConnectionManager;
import com.nokia.mj.impl.gcf.protocol.socket.SocketPermissionImpl;
import com.nokia.mj.impl.gcf.utils.ConnectionBaseInterface;
import com.nokia.mj.impl.gcf.utils.UrlParser;
import com.nokia.mj.impl.rt.support.ApplicationInfo;
import com.nokia.mj.impl.rt.support.ApplicationUtils;
import com.nokia.mj.impl.rt.support.Jvm;
import com.nokia.mj.impl.socket.ServerSocketConnectionImpl;
import com.nokia.mj.impl.socket.SocketConnectionImpl;
import com.nokia.mj.impl.utils.Logger;
import com.nokia.mj.impl.utils.Uid;
import java.io.IOException;
import javax.microedition.io.Connection;

public class Protocol
implements ConnectionBaseInterface {
    public Connection openConnection(String aUri, int aMode, boolean aTimeouts) throws IOException {
        ApplicationUtils appUtils;
        String temp;
        int equalindex;
        String apnstring = null;
        String urls = null;
        int apnid = -1;
        int index = -1;
        String fullurl = "socket:" + aUri;
        ConnectionManager cminstance = null;
        AccessPoint apn = null;
        index = aUri.indexOf(";nokia_netid=");
        if (index != -1) {
            apnstring = aUri.substring(index);
            equalindex = apnstring.indexOf(61);
            if (equalindex != -1) {
                temp = apnstring.substring(equalindex + 1);
                try {
                    apnid = Integer.parseInt(temp);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Invalid URL: " + fullurl);
                }
            } else {
                throw new IllegalArgumentException("Invalid URL: " + fullurl);
            }
            urls = aUri.substring(0, index);
        } else {
            index = aUri.indexOf(";nokia_apnid=");
            if (index != -1) {
                apnstring = aUri.substring(index);
                equalindex = apnstring.indexOf(61);
                if (equalindex != -1) {
                    temp = apnstring.substring(equalindex + 1);
                    try {
                        apnid = Integer.parseInt(temp);
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("Invalid URL: " + fullurl);
                    }
                } else {
                    throw new IllegalArgumentException("Invalid URL: " + fullurl);
                }
                urls = aUri.substring(0, index);
            } else {
                urls = aUri;
            }
        }
        Logger.LOG(14, 4, "socket +openConnection -after removing nokia_apnid : " + urls);
        UrlParser SocURL = new UrlParser("socket", urls);
        Logger.LOG(14, 4, "socket - protocol class : port = " + SocURL.port);
        if ((SocURL.getPort() == 8080 || SocURL.getPort() == 443 || SocURL.getPort() == 80) && ApplicationInfo.getInstance().getRuntimeType().equals("MIDP") && ApplicationInfo.getInstance().getProtectionDomain().equals("UTPD")) {
            Logger.LOG(14, 4, "Throwing security exception for restricted port");
            throw new SecurityException("Unable to open socket connection: port " + SocURL.getPort() + " is restricted");
        }
        if (SocURL.host == null) {
            Logger.LOG(14, 4, "socket - protocol class : server connection");
            appUtils = ApplicationUtils.getInstance();
            SocketPermissionImpl per = new SocketPermissionImpl("socket://");
            appUtils.checkPermission(per);
            Logger.LOG(14, 4, "socket - protocol class : after security check");
            return new ServerSocketConnectionImpl(SocURL, aMode);
        }
        Logger.LOG(14, 4, "socket - protocol class : client connection");
        if (SocURL.port == -1) {
            throw new IllegalArgumentException("Invalid URL: " + fullurl);
        }
        appUtils = ApplicationUtils.getInstance();
        SocketPermissionImpl per = new SocketPermissionImpl("socket://*");
        appUtils.checkPermission(per);
        Logger.LOG(14, 4, "socket - protocol class : after security check");
        cminstance = ConnectionManager.getInstance();
        Logger.LOG(14, 4, "after getting ConnectionManager instance");
        try {
            Uid appSuite = ApplicationInfo.getInstance().getSuiteUid();
            try {
                apn = cminstance.getNetworkAccessPoint(appSuite, aUri);
            }
            catch (Exception e) {
                Logger.LOG(14, 4, "+secureconnection Protocol getNetworkAccessPoint threw Exception");
            }
            Logger.LOG(14, 4, "apn.getType = " + apn.getType() + " apn.getNapId= " + apn.getNapId());
        }
        catch (Exception e) {
            Logger.LOG(14, 4, "getSuiteUid exception ");
        }
        return new SocketConnectionImpl(SocURL, aMode, -1, cminstance, apn);
    }

    public Connection openPrim(String name, int mode, boolean timeouts) throws IOException {
        return this.openConnection(name, mode, timeouts);
    }

    static {
        try {
            Jvm.loadSystemLibrary("javasocket");
        }
        catch (Exception e) {
            Logger.LOG(14, 1, e.toString());
        }
    }
}

