/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.gcf.utils;

import com.nokia.mj.impl.gcf.utils.StreamConnectionBase;
import com.nokia.mj.impl.gcf.utils.StreamsLogger;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;

public class OutputStreamBase
extends OutputStream {
    protected boolean iIsClosed;
    protected StreamConnectionBase iStreamBase;
    protected final Object iCloseLock;
    private final byte[] iSingleByte;
    private final byte[] iBuffer;
    private int iBufferOffset;

    protected OutputStreamBase(StreamConnectionBase aEndPoint, Object aCloseLock, boolean aCreateBuffer) {
        StreamsLogger.Log(2, " +   OutputStreamBase: Constructor");
        this.iStreamBase = aEndPoint;
        this.iIsClosed = false;
        this.iSingleByte = new byte[1];
        this.iBuffer = (byte[])(aCreateBuffer ? new byte[this.iStreamBase.iBufferSize] : null);
        this.iCloseLock = aCloseLock;
        StreamsLogger.Log(2, " -   OutputStreamBase: Constructor");
    }

    protected OutputStreamBase(StreamConnectionBase aEndPoint, Object aCloseLock) {
        this.iStreamBase = aEndPoint;
        this.iIsClosed = false;
        this.iSingleByte = new byte[1];
        this.iBuffer = new byte[this.iStreamBase.iBufferSize];
        this.iCloseLock = aCloseLock;
    }

    public synchronized void write(int aByte) throws IOException {
        this.iSingleByte[0] = (byte)(aByte & 0xFF);
        this.write(this.iSingleByte, 0, 1);
    }

    public synchronized void write(byte[] aBytes, int aOffset, int aLength) throws IOException {
        StreamsLogger.Log(2, " +   OutputStreamBase: write()");
        if (this.iIsClosed) {
            throw new IOException("OutputStream closed");
        }
        StreamConnectionBase.checkIOParams(aBytes, aOffset, aLength);
        if (this.iBufferOffset + aLength > this.iStreamBase.iBufferSize) {
            this.flush();
        }
        if (aLength > this.iStreamBase.iBufferSize) {
            int nLeftToWrite = aLength;
            int offset = aOffset;
            while (nLeftToWrite > 0) {
                int nBytesToWrite = Math.min(nLeftToWrite, this.iStreamBase.iBufferSize);
                try {
                    StreamsLogger.Log(3, "     OutputStreamBase: write(): Writing to StreamBase");
                    this.iStreamBase.writeBytes(aBytes, offset, nBytesToWrite);
                }
                catch (InterruptedIOException ie) {
                    ie.bytesTransferred = aLength - nLeftToWrite;
                    throw ie;
                }
                nLeftToWrite -= nBytesToWrite;
                offset += nBytesToWrite;
            }
        } else {
            StreamsLogger.Log(3, "     OutputStreamBase: write(): Writing to Internal cache");
            System.arraycopy((Object)aBytes, aOffset, (Object)this.iBuffer, this.iBufferOffset, aLength);
            this.iBufferOffset += aLength;
        }
        StreamsLogger.Log(2, " -   OutputStreamBase: write()");
    }

    public synchronized void flush() throws IOException {
        StreamsLogger.Log(2, " +   OutputStreamBase: flush()");
        if (this.iBufferOffset > 0) {
            this.iStreamBase.writeBytes(this.iBuffer, 0, this.iBufferOffset);
            this.iBufferOffset = 0;
        }
        StreamsLogger.Log(2, " -   OutputStreamBase: flush()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        StreamsLogger.Log(2, " +   OutputStreamBase: close()");
        this.flush();
        Object object = this.iCloseLock;
        synchronized (object) {
            if (!this.iIsClosed) {
                this.iIsClosed = true;
                this.iStreamBase.cancelWrite();
                this.iStreamBase = null;
            }
        }
        StreamsLogger.Log(2, " -   OutputStreamBase: close()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        Object object = this.iCloseLock;
        synchronized (object) {
            return this.iIsClosed;
        }
    }
}

