/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.gcf.utils;

import com.nokia.mj.impl.gcf.utils.StreamConnectionBase;
import com.nokia.mj.impl.gcf.utils.StreamsLogger;
import java.io.InterruptedIOException;

class Prefetch
implements Runnable {
    private final byte[] iBuffer;
    private final int STARTED = 0;
    private final int RUNNING = 1;
    private final int CANCELLED = 2;
    private final int CLOSED = 3;
    private int iState;
    private int iReadResult;
    private StreamConnectionBase iEndpoint;
    private Object iPrefetchLock = new Object();
    private Object iStartLock = new Object();
    private Object iPrefetchDoneLock = new Object();
    private Thread me;
    private boolean iWaitingToPick = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Prefetch(StreamConnectionBase aEndpoint) {
        StreamsLogger.Log(2, " +  Prefetch: Constructor");
        this.iEndpoint = aEndpoint;
        this.iBuffer = new byte[this.iEndpoint.iBufferSize];
        this.me = new Thread(this);
        this.iState = 0;
        this.iReadResult = 0;
        Object object = this.iStartLock;
        synchronized (object) {
            try {
                this.me.start();
                StreamsLogger.Log(3, "    Prefetch: Constructor: Waiting for Thread to start");
                this.iStartLock.wait();
            }
            catch (Exception e) {
                StreamsLogger.ELog("Prefetch Constructor! " + e);
            }
        }
        this.iState = 1;
        StreamsLogger.Log(2, " -  Prefetch: Constructor");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        StreamsLogger.Log(2, " +   Prefetch: run()");
        while (this.iState != 3) {
            Object object = this.iPrefetchLock;
            synchronized (object) {
                Object object2 = this.iPrefetchDoneLock;
                synchronized (object2) {
                    StreamsLogger.Log(3, "     Prefetch: run(): Notifying iPrefetchDoneLock");
                    this.iPrefetchDoneLock.notify();
                }
                if (this.iState == 0) {
                    object2 = this.iStartLock;
                    synchronized (object2) {
                        StreamsLogger.Log(3, "     Prefetch: run(): Notifying iStartLock");
                        this.iStartLock.notify();
                    }
                    this.iState = 1;
                }
                if (this.iState != 2 && this.iEndpoint != null) {
                    this.iReadResult = this.iEndpoint.readData(this.iBuffer);
                }
                if (this.iState == 2) {
                    break;
                }
                try {
                    StreamsLogger.Log(3, "     Prefetch: run(): Waiting for someone to pick up data");
                    this.iWaitingToPick = true;
                    this.iPrefetchLock.wait();
                    this.iWaitingToPick = false;
                    StreamsLogger.Log(3, "     Prefetch: run(): Data taken");
                }
                catch (InterruptedException ex) {
                    StreamsLogger.ELog("Prefetch: Run()! " + ex);
                }
            }
        }
        StreamsLogger.Log(2, " -   Prefetch: run()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int getPrefetched(byte[] aBytes) throws InterruptedIOException {
        StreamsLogger.Log(2, " +   Prefetch: getPrefetched()");
        int result = 0;
        Object object = this.iPrefetchDoneLock;
        synchronized (object) {
            Object object2 = this.iPrefetchLock;
            synchronized (object2) {
                if (this.iState == 2) {
                    StreamsLogger.WLog("     Prefetch: getPrefetched(): Read was cancelled");
                    throw new InterruptedIOException();
                }
                result = this.iReadResult;
                if (result >= 0) {
                    System.arraycopy((Object)this.iBuffer, 0, (Object)aBytes, 0, this.iEndpoint.iBufferSize);
                    this.iReadResult = 0;
                }
                StreamsLogger.Log(3, "     Prefetch: getPrefetched(): Notifying iPrefetchLock");
                this.iPrefetchLock.notifyAll();
            }
            try {
                StreamsLogger.Log(3, "     Prefetch: getPrefetched(): Waiting for prefetch to resume");
                this.iPrefetchDoneLock.wait();
            }
            catch (Exception e) {
                StreamsLogger.ELog("Prefetch: getPrefetched()!: " + e);
            }
        }
        StreamsLogger.Log(2, " -   Prefetch: getPrefetched(): result: " + result);
        return result;
    }

    public int getResult() {
        return this.iReadResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        StreamsLogger.Log(2, " +   Prefetch: close()");
        this.iState = 2;
        if (this.iWaitingToPick) {
            StreamsLogger.Log(3, "     Prefetch: close(): Waiting for block");
            Object object = this.iPrefetchLock;
            synchronized (object) {
                StreamsLogger.Log(3, "     Prefetch: close(): Notified");
                this.iPrefetchLock.notify();
            }
        }
        this.me = null;
        this.iEndpoint = null;
        StreamsLogger.Log(2, " -   Prefetch: close()");
    }
}

