/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.installer.ui.eswt;

import com.nokia.mj.impl.installer.ui.ApplicationInfo;
import com.nokia.mj.impl.installer.ui.InstallInfo;
import com.nokia.mj.impl.installer.ui.InstallerUiTexts;
import com.nokia.mj.impl.installer.ui.eswt.CertificateDetailsView;
import com.nokia.mj.impl.installer.ui.eswt.ConfirmationViewBase;
import com.nokia.mj.impl.security.midp.common.SigningCertificate;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class InstallDetailsView
extends ConfirmationViewBase {
    private CertificateDetailsView iCertificateDetailsView = null;
    private InstallInfo iInstallInfo = null;
    private Image iSuiteIcon = null;
    private Combo iDriveSelector = null;
    private Button iRetainDataButton = null;

    protected InstallDetailsView() {
    }

    protected InstallDetailsView(Composite aParent, String aTitle, InstallInfo aInstallInfo, Image aSuiteIcon) {
        super(aParent, 8);
        this.iInstallInfo = aInstallInfo;
        this.iSuiteIcon = aSuiteIcon;
        this.setTitle(aTitle);
        this.setCommands(InstallerUiTexts.get("ok"), InstallerUiTexts.get("cancel"));
    }

    protected void createView() {
        SigningCertificate[] certs;
        ApplicationInfo[] apps;
        GridData gridData = null;
        int horizontalSpan = this.getColumns() - 1;
        int labelStyle = 64;
        if (this.iSuiteIcon != null) {
            try {
                Label iconLabel = this.createLabel(this.iSuiteIcon, 2, 0);
                horizontalSpan = this.getColumns() - 3;
            }
            catch (Throwable t) {
                horizontalSpan = this.getColumns() - 1;
                this.logError("Exception while setting icon", t);
            }
        }
        String title = InstallerUiTexts.get("query", new String[]{this.iInstallInfo.getName()});
        if (this.iInstallInfo.getOldVersion() != null) {
            title = InstallerUiTexts.get("update_query", new String[]{this.iInstallInfo.getName(), this.iInstallInfo.getOldVersion(), this.iInstallInfo.getVersion()});
        }
        Label titleLabel = this.createLabel(title, horizontalSpan, labelStyle);
        titleLabel.setFont(this.getBoldFont());
        boolean identified = this.iInstallInfo.getCertificates() != null;
        Label securityIconLabel = this.createSecurityLabel(identified);
        horizontalSpan = this.getColumns();
        Label nameLabel = this.createLabel(InstallerUiTexts.get("app_details_name", new String[]{this.iInstallInfo.getName()}), horizontalSpan, labelStyle);
        if (identified) {
            Label vendorLabel = this.createLabel(InstallerUiTexts.get("app_details_vendor", new String[]{this.iInstallInfo.getVendor()}), horizontalSpan, labelStyle);
        }
        Label versionLabel = this.createLabel(InstallerUiTexts.get("app_details_version", new String[]{this.iInstallInfo.getVersion()}), horizontalSpan, labelStyle);
        long size = 0L;
        if (this.iInstallInfo.getJarSize() > 0L) {
            size += this.iInstallInfo.getJarSize();
        }
        if (this.iInstallInfo.getDataSize() > 0L) {
            size += this.iInstallInfo.getDataSize();
        }
        if (size > 0L) {
            Label sizeLabel = this.createLabel(InstallerUiTexts.get("app_details_size_kb", new String[]{Long.toString(1L + size / 1024L)}), horizontalSpan, labelStyle);
        }
        if (!((apps = this.iInstallInfo.getApplications()) == null || apps.length <= 0 || apps.length <= 1 && this.iInstallInfo.getName().equals(apps[0].getName()))) {
            Label appsLabel = this.createLabel(InstallerUiTexts.get("app_details_apps_list"), horizontalSpan, labelStyle);
            for (int i = 0; i < apps.length; ++i) {
                Label appLabel = this.createLabel(InstallerUiTexts.get("application_name", new String[]{apps[i].getName()}), horizontalSpan, labelStyle);
            }
        }
        Label drivesLabel = this.createLabel(InstallerUiTexts.get("app_details_install_to_drive"), horizontalSpan, labelStyle);
        this.iDriveSelector = new Combo(this.getComposite(), 8);
        gridData = new GridData(768);
        gridData.horizontalSpan = horizontalSpan;
        this.iDriveSelector.setLayoutData((Object)gridData);
        int[] driveIds = this.iInstallInfo.getDriveIds();
        int[] driveTypes = this.iInstallInfo.getDriveTypes();
        long[] driveFreeSpaces = this.iInstallInfo.getDriveFreeSpaces();
        int driveIndex = 0;
        if (driveIds != null && driveTypes != null && driveFreeSpaces != null) {
            for (int i = 0; i < driveIds.length && i < driveTypes.length && i < driveFreeSpaces.length; ++i) {
                this.iDriveSelector.add(this.getDriveString(driveIds[i], driveTypes[i], driveFreeSpaces[i]));
                if (this.iInstallInfo.getDriveId() != driveIds[i]) continue;
                driveIndex = i;
            }
            this.iDriveSelector.select(driveIndex);
        }
        if (this.iInstallInfo.getRetainData() != null) {
            this.iRetainDataButton = new Button(this.getComposite(), 32);
            gridData = new GridData(768);
            gridData.horizontalSpan = horizontalSpan;
            this.iRetainDataButton.setLayoutData((Object)gridData);
            this.iRetainDataButton.setSelection(this.iInstallInfo.getRetainData().booleanValue());
            this.iRetainDataButton.setText(InstallerUiTexts.get("update_retain_user_data"));
        }
        if ((certs = this.iInstallInfo.getCertificates()) != null) {
            int i = 0;
            while (i < 1) {
                Link certLink = new Link(this.getComposite(), 0);
                certLink.setText("<a>" + InstallerUiTexts.get("view_cert_details") + "</a>");
                final int certIndex = i++;
                certLink.addListener(13, new Listener(){

                    public void handleEvent(Event aEvent) {
                        InstallDetailsView.this.openCertsView(certIndex);
                    }
                });
                gridData = new GridData(768);
                gridData.horizontalSpan = horizontalSpan;
                certLink.setLayoutData((Object)gridData);
            }
        }
    }

    protected void getDataFromView() {
        if (this.iDriveSelector != null && !this.iDriveSelector.isDisposed()) {
            int selectionIndex = this.iDriveSelector.getSelectionIndex();
            int drive = -1;
            if (selectionIndex >= 0) {
                drive = this.iInstallInfo.getDriveIds()[selectionIndex];
            }
            this.iInstallInfo.setDriveId(drive);
            this.log("Selected drive: " + drive);
        }
        if (this.iRetainDataButton != null && !this.iRetainDataButton.isDisposed()) {
            boolean selection = this.iRetainDataButton.getSelection();
            this.iInstallInfo.setRetainData(selection);
            this.log("RetainData: " + selection);
        }
    }

    protected int getStyle() {
        return 512;
    }

    protected void screenOrientationChanged() {
        super.screenOrientationChanged();
        if (this.iCertificateDetailsView != null) {
            this.iCertificateDetailsView.screenOrientationChanged();
        }
    }

    private void openCertsView(int aCertIndex) {
        this.iCertificateDetailsView = new CertificateDetailsView((Composite)new Shell(this.getShell(), this.getShell().getStyle()), this.getTitle(), this.iInstallInfo, aCertIndex);
        this.iCertificateDetailsView.setInstallerUi(this.getInstallerUi());
        new Thread(new Runnable(){

            public void run() {
                if (InstallDetailsView.this.iCertificateDetailsView.confirm()) {
                    InstallDetailsView.this.log("certificateDetailsView confirmed");
                    InstallDetailsView.this.confirmOk();
                } else {
                    InstallDetailsView.this.log("certificateDetailsView cancelled");
                }
                InstallDetailsView.this.iCertificateDetailsView.dispose();
                InstallDetailsView.this.iCertificateDetailsView = null;
            }
        }, "InstallerUiCertViewThread").start();
    }

    private String getDriveString(int aId, int aType, long aFreeSpace) {
        String driveLetter = "0";
        if (aId >= 0 || aId < 26) {
            driveLetter = new String(new char[]{(char)(65 + aId)});
        }
        int freeSpace = (int)aFreeSpace;
        int prefix = 0;
        if (aFreeSpace >= 0x40000000L) {
            freeSpace = (int)(aFreeSpace / 0x40000000L);
            prefix = 3;
        } else if (aFreeSpace >= 0x100000L) {
            freeSpace = (int)(aFreeSpace / 0x100000L);
            prefix = 2;
        } else {
            freeSpace = (int)(aFreeSpace / 1024L);
            prefix = 1;
        }
        String textId = null;
        Object[] textParams = new Object[]{driveLetter, new Integer(freeSpace)};
        block0 : switch (aType) {
            case 0: {
                switch (prefix) {
                    case 0: {
                        textId = "drive_type_unknown";
                        textParams = new String[]{driveLetter};
                        break;
                    }
                    case 1: {
                        textId = "drive_type_unknown_kb";
                        break;
                    }
                    case 2: {
                        textId = "drive_type_unknown_mb";
                        break;
                    }
                    case 3: {
                        textId = "drive_type_unknown_gb";
                    }
                }
                break;
            }
            case 1: {
                switch (prefix) {
                    case 0: {
                        textId = "drive_type_phone_memory";
                        textParams = new String[]{driveLetter};
                        break;
                    }
                    case 1: {
                        textId = "drive_type_phone_memory_kb";
                        break;
                    }
                    case 2: {
                        textId = "drive_type_phone_memory_mb";
                        break;
                    }
                    case 3: {
                        textId = "drive_type_phone_memory_gb";
                    }
                }
                break;
            }
            case 2: {
                switch (prefix) {
                    case 0: {
                        textId = "drive_type_memory_card";
                        textParams = new String[]{driveLetter};
                        break;
                    }
                    case 1: {
                        textId = "drive_type_memory_card_kb";
                        break;
                    }
                    case 2: {
                        textId = "drive_type_memory_card_mb";
                        break;
                    }
                    case 3: {
                        textId = "drive_type_memory_card_gb";
                    }
                }
                break;
            }
            case 3: {
                switch (prefix) {
                    case 0: {
                        textId = "drive_type_internal_mass_memory";
                        textParams = new String[]{driveLetter};
                        break block0;
                    }
                    case 1: {
                        textId = "drive_type_internal_mass_memory_kb";
                        break block0;
                    }
                    case 2: {
                        textId = "drive_type_internal_mass_memory_mb";
                        break block0;
                    }
                    case 3: {
                        textId = "drive_type_internal_mass_memory_gb";
                    }
                }
            }
        }
        return InstallerUiTexts.get(textId, textParams);
    }
}

