/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.installer.ui.eswt;

import com.nokia.mj.impl.fileutils.FileUtility;
import com.nokia.mj.impl.installer.ui.DownloadInfo;
import com.nokia.mj.impl.installer.ui.InstallInfo;
import com.nokia.mj.impl.installer.ui.InstallerUi;
import com.nokia.mj.impl.installer.ui.InstallerUiListener;
import com.nokia.mj.impl.installer.ui.InstallerUiTexts;
import com.nokia.mj.impl.installer.ui.LaunchAppInfo;
import com.nokia.mj.impl.installer.ui.MinimalUi;
import com.nokia.mj.impl.installer.ui.PermissionInfo;
import com.nokia.mj.impl.installer.ui.UninstallInfo;
import com.nokia.mj.impl.installer.ui.eswt.InstallConfirmationView;
import com.nokia.mj.impl.installer.ui.eswt.LaunchAppQueryView;
import com.nokia.mj.impl.installer.ui.eswt.PermissionConfirmationView;
import com.nokia.mj.impl.installer.ui.eswt.ProgressView;
import com.nokia.mj.impl.installer.ui.eswt.SubProgressView;
import com.nokia.mj.impl.installer.ui.eswt.UninstallConfirmationView;
import com.nokia.mj.impl.installer.ui.eswt.UsernamePasswordView;
import com.nokia.mj.impl.rt.ui.RuntimeUi;
import com.nokia.mj.impl.rt.ui.RuntimeUiFactory;
import com.nokia.mj.impl.utils.ResourceUtil;
import com.nokia.mj.impl.utils.StartUpTrace;
import com.nokia.mj.impl.utils.exception.InstallerExceptionBase;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class InstallerUiEswt
extends InstallerUi {
    private static final int SHELL_STYLE = 67584;
    private static final int PROGRESS_SHELL_STYLE = 67584;
    private static final int PROGRESS_BAR_MODE_ONE = 1;
    private static final int PROGRESS_BAR_MODE_TWO = 2;
    private static final int PROGRESS_BAR_MODE_COMBINED = 3;
    private static final int PROGRESS_BAR_MODE = 1;
    private static final int DL_PROGRESS_START = 0;
    private static final int DL_PROGRESS_END = 60;
    private Shell iParent = null;
    private SubProgressView iProgressView = null;
    private ProgressView iDlProgressView = null;
    private ProgressView iOcspProgressView = null;
    private InstallConfirmationView iInstallConfirmationView = null;
    private UninstallConfirmationView iUninstallConfirmationView = null;
    private PermissionConfirmationView iPermissionConfirmationView = null;
    private UsernamePasswordView iUsernamePasswordView = null;
    private LaunchAppQueryView iLaunchAppQueryView = null;
    private Object iInitWaitObject = new Object();
    private Object iExitWaitObject = new Object();
    private boolean iUiThreadExists = false;
    private String iAppName = null;
    private Image iSecurityIcon = null;
    private boolean iInstallConfirmed = false;
    private boolean iUninstallConfirmed = false;
    private boolean iProgressBarUpdateTraced = false;
    private boolean iMinimalUiEnabled = true;
    private static Hashtable iImageTable = null;

    public void init(int aMode, InstallerUiListener aListener) {
        super.init(aMode, aListener);
        StartUpTrace.doTrace("InstallerUiEswt init");
        iImageTable = new Hashtable();
        this.iUiThreadExists = true;
        new Thread(new Runnable(){

            public void run() {
                InstallerUiEswt.this.uiMain();
            }
        }, "InstallerUiMainThread").start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uiMain() {
        InstallerUiEswt.log("uiMain: thread started");
        try {
            Display display = new Display();
            StartUpTrace.doTrace("InstallerUiEswt display created");
            Display.setAppName((String)"");
            this.iParent = new Shell(display);
            StartUpTrace.doTrace("InstallerUiEswt shell created");
            this.iProgressView = new SubProgressView((Composite)new Shell(this.iParent, 67584), this.getTitle());
            this.iProgressView.setInstallerUi(this);
            this.iProgressView.setSubText(InstallerUiTexts.get("download_progress"));
            this.iParent.addControlListener((ControlListener)new CListener(this));
            InstallerUiEswt.log("InstallerUiEswt CListener added");
            display.addListener(12, new Listener(){

                public void handleEvent(Event aEvent) {
                    InstallerUi.log("Dispose event for display");
                }
            });
            Object object = this.iInitWaitObject;
            synchronized (object) {
                this.iInitWaitObject.notify();
            }
            StartUpTrace.doTrace("InstallerUiEswt ready");
            if (this.iMode == 1 && this.getOcspIndicator()) {
                this.setOcspIndicator(this.getOcspIndicator());
            } else if (this.iMode == 3 && this.iAppConversionTotal > 0) {
                this.updateAppConversionIndicator(this.iAppConversionCurrent, this.iAppConversionTotal);
            }
            while (this.isUiReady()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
            display.dispose();
            InstallerUiEswt.log("uiMain: display disposed");
            object = this.iExitWaitObject;
            synchronized (object) {
                this.iExitWaitObject.notify();
            }
        }
        catch (Throwable t) {
            InstallerUiEswt.logError("Exception in uiMain", t);
            Object object = this.iInitWaitObject;
            synchronized (object) {
                this.iUiThreadExists = false;
                this.iInitWaitObject.notify();
            }
            object = this.iExitWaitObject;
            synchronized (object) {
                this.iExitWaitObject.notify();
            }
        }
        this.iUiThreadExists = false;
        InstallerUiEswt.log("uiMain: thread ended");
    }

    public void cancelConfirmations() {
        super.cancelConfirmations();
        if (this.iInstallConfirmationView != null) {
            this.iInstallConfirmationView.confirmCancel();
        }
        if (this.iUninstallConfirmationView != null) {
            this.iUninstallConfirmationView.confirmCancel();
        }
        if (this.iPermissionConfirmationView != null) {
            this.iPermissionConfirmationView.confirmCancel();
        }
        if (this.iUsernamePasswordView != null) {
            this.iUsernamePasswordView.confirmCancel();
        }
        if (this.iLaunchAppQueryView != null) {
            this.iLaunchAppQueryView.confirmCancel();
        }
    }

    public boolean confirm(InstallInfo aInstallInfo) {
        super.confirm(aInstallInfo);
        this.waitForUi();
        boolean result = true;
        if (!this.isUiReady()) {
            result = false;
            if (this.iMinimalUiEnabled) {
                result = MinimalUi.confirmStatic(aInstallInfo);
                InstallerUiEswt.log("MinimalUi installation confirmation returns " + result);
                return result;
            }
            throw new RuntimeException("JavaInstallerUi not ready");
        }
        if (result) {
            StartUpTrace.doTrace("InstallerUiEswt confirm");
            if (this.iInstallConfirmationView == null) {
                Display display = this.iParent.getDisplay();
                display.syncExec(new Runnable(){

                    public void run() {
                        InstallerUiEswt.this.iInstallConfirmationView = new InstallConfirmationView((Composite)InstallerUiEswt.this.createNewShell(67584));
                    }
                });
                this.iInstallConfirmationView.setInstallerUi(this);
            }
            result = this.iInstallConfirmationView.confirm(aInstallInfo);
        }
        if (result) {
            this.iInstallConfirmed = true;
            this.iAppName = aInstallInfo.getName();
            if (this.iUsernamePasswordView != null) {
                this.iUsernamePasswordView.setAppName(this.iAppName);
            }
            if (this.iDlProgressView != null && !this.iDlProgressView.isOpened()) {
                this.iDlProgressView.open();
            }
        }
        InstallerUiEswt.log("Installation confirmation returns " + result);
        return result;
    }

    public boolean confirmPermissions(PermissionInfo aPermissionInfo) {
        super.confirmPermissions(aPermissionInfo);
        this.waitForUi();
        if (!this.isUiReady()) {
            aPermissionInfo.setPermissionAllowed(false);
            return true;
        }
        if (this.iPermissionConfirmationView == null) {
            Display display = this.iParent.getDisplay();
            display.syncExec(new Runnable(){

                public void run() {
                    InstallerUiEswt.this.iPermissionConfirmationView = new PermissionConfirmationView((Composite)InstallerUiEswt.this.createNewShell(67584));
                }
            });
            this.iPermissionConfirmationView.setInstallerUi(this);
        }
        boolean result = this.iPermissionConfirmationView.confirm(this.iInstallInfo, aPermissionInfo);
        InstallerUiEswt.log("Permission confirmation returns " + result + ", user selection " + aPermissionInfo.isPermissionAllowed());
        return result;
    }

    public boolean confirm(UninstallInfo aUninstallInfo) {
        super.confirm(aUninstallInfo);
        this.waitForUi();
        boolean result = true;
        if (!this.isUiReady()) {
            result = false;
            if (this.iMinimalUiEnabled) {
                result = MinimalUi.confirmStatic(aUninstallInfo);
                InstallerUiEswt.log("MinimalUi uninstallation confirmation returns " + result);
                return result;
            }
            throw new RuntimeException("JavaInstallerUi not ready");
        }
        if (result) {
            StartUpTrace.doTrace("InstallerUiEswt confirm");
            if (this.iUninstallConfirmationView == null) {
                Display display = this.iParent.getDisplay();
                display.syncExec(new Runnable(){

                    public void run() {
                        InstallerUiEswt.this.iUninstallConfirmationView = new UninstallConfirmationView((Composite)InstallerUiEswt.this.createNewShell(67584));
                    }
                });
                this.iUninstallConfirmationView.setInstallerUi(this);
            }
            result = this.iUninstallConfirmationView.confirm(aUninstallInfo);
        }
        if (result) {
            this.iUninstallConfirmed = true;
        }
        InstallerUiEswt.log("Uninstallation confirmation returns " + result);
        return result;
    }

    public void started() {
        super.started();
        if (!this.isUiReady()) {
            return;
        }
        this.iProgressView.open();
    }

    public void updateProgress(int aProgress) {
        super.updateProgress(aProgress);
        if (!this.iInstallConfirmed && !this.iUninstallConfirmed) {
            return;
        }
        if (!this.isUiReady()) {
            return;
        }
        if (!this.iProgressView.isOpened()) {
            this.iProgressView.open();
        }
        if (!this.iProgressBarUpdateTraced) {
            StartUpTrace.doTrace("InstallerUiEswt progress " + aProgress + " %");
            this.iProgressBarUpdateTraced = true;
        }
        if (this.iMode == 1) {
            // empty if block
        }
        this.iProgressView.updateProgress(aProgress);
        if (aProgress == 100 && this.iProgressView.isVisible()) {
            this.iProgressView.setVisible(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ended() {
        super.ended();
        if (!this.isUiReady()) {
            return;
        }
        if (this.iInstallConfirmationView != null) {
            this.iInstallConfirmationView.dispose();
            this.iInstallConfirmationView = null;
        }
        if (this.iUninstallConfirmationView != null) {
            this.iUninstallConfirmationView.dispose();
            this.iUninstallConfirmationView = null;
        }
        if (this.iPermissionConfirmationView != null) {
            this.iPermissionConfirmationView.dispose();
            this.iPermissionConfirmationView = null;
        }
        if (this.iUsernamePasswordView != null) {
            this.iUsernamePasswordView.dispose();
            this.iUsernamePasswordView = null;
        }
        if (this.iLaunchAppQueryView != null) {
            this.iLaunchAppQueryView.dispose();
            this.iLaunchAppQueryView = null;
        }
        if (this.iDlProgressView != null) {
            this.iDlProgressView.dispose();
            this.iDlProgressView = null;
        }
        if (this.iOcspProgressView != null) {
            this.iOcspProgressView.dispose();
            this.iOcspProgressView = null;
        }
        if (this.iProgressView != null) {
            this.iProgressView.dispose();
            this.iProgressView = null;
        }
        Display display = this.iParent.getDisplay();
        display.syncExec(new Runnable(){

            public void run() {
                InstallerUiEswt.this.iParent.dispose();
            }
        });
        InstallerUiEswt.log("ended: parent disposed");
        Object object = this.iExitWaitObject;
        synchronized (object) {
            try {
                if (!display.isDisposed()) {
                    this.iExitWaitObject.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        InstallerUiEswt.log("ended returns");
    }

    public void started(DownloadInfo aDownloadInfo) {
        super.started(aDownloadInfo);
        if (!this.isUiReady()) {
            return;
        }
    }

    public void updateProgress(DownloadInfo aDownloadInfo) {
        super.updateProgress(aDownloadInfo);
        if (!this.iInstallConfirmed && !this.iUninstallConfirmed) {
            return;
        }
        if (!this.isUiReady()) {
            return;
        }
        if (!this.iProgressView.isOpened()) {
            this.iProgressView.open();
        }
        if (this.iMode == 1) {
            // empty if block
        }
        if (this.iDlProgressView == null) {
            final boolean indeterminate = aDownloadInfo.getTotalSize() <= 0L;
            this.iParent.getDisplay().syncExec(new Runnable(){

                public void run() {
                    InstallerUiEswt.this.iDlProgressView = new ProgressView((Composite)InstallerUiEswt.this.createNewShell(67584), InstallerUiTexts.get("download_progress"), indeterminate);
                }
            });
            this.iDlProgressView.setInstallerUi(this);
            this.iDlProgressView.addCancelCommand();
        }
        if (this.iInstallConfirmed && !this.iDlProgressView.isOpened()) {
            this.iDlProgressView.open();
        }
        if (aDownloadInfo.getTotalSize() > 0L) {
            int progress = (int)(aDownloadInfo.getCurrentSize() * 100L / aDownloadInfo.getTotalSize());
            this.iDlProgressView.updateProgress(progress);
        }
    }

    public void ended(DownloadInfo aDownloadInfo) {
        super.ended(aDownloadInfo);
        if (!this.isUiReady()) {
            return;
        }
        if (this.iDlProgressView != null) {
            this.iDlProgressView.dispose();
            this.iDlProgressView = null;
        } else {
            this.iProgressView.removeCancelCommand();
            this.iProgressView.removeSubProgress();
        }
    }

    public void setOcspIndicator(boolean aOn) {
        super.setOcspIndicator(aOn);
        this.waitForUi();
        if (!this.isUiReady()) {
            InstallerUiEswt.log("UI not ready, could not set OCSP indicator to " + aOn);
            return;
        }
        if (aOn) {
            if (this.iOcspProgressView == null) {
                this.iParent.getDisplay().syncExec(new Runnable(){

                    public void run() {
                        InstallerUiEswt.this.iOcspProgressView = new ProgressView((Composite)InstallerUiEswt.this.createNewShell(67584), InstallerUiTexts.get("ocsp_check_progress"), true);
                    }
                });
                this.iOcspProgressView.setInstallerUi(this);
                this.iOcspProgressView.addCancelCommand();
            }
            if (this.iOcspProgressView != null) {
                if (!this.iOcspProgressView.isOpened()) {
                    this.iOcspProgressView.open();
                }
                if (!this.iOcspProgressView.isVisible()) {
                    this.iOcspProgressView.setVisible(true);
                }
            }
        } else if (this.iOcspProgressView != null) {
            if (this.iOcspProgressView.isVisible()) {
                this.iOcspProgressView.setVisible(false);
            }
            this.iOcspProgressView.dispose();
            this.iOcspProgressView = null;
        }
    }

    public void updateAppConversionIndicator(int aCurrent, int aTotal) {
        super.updateAppConversionIndicator(aCurrent, aTotal);
        if (!this.isUiReady()) {
            InstallerUiEswt.log("UI not ready, could not update app conversion indicator");
            return;
        }
        int progress = 101;
        if (aTotal > 0) {
            progress = aCurrent * 100 / aTotal;
        }
        if (progress <= 100) {
            this.iProgressView.setText(this.getTitle());
            this.iProgressView.updateProgress(progress);
            if (!this.iProgressView.isOpened()) {
                this.iProgressView.removeCancelCommand();
                this.iProgressView.open();
            }
            if (!this.iProgressView.isVisible()) {
                this.iProgressView.setVisible(true);
            }
            this.iParent.getDisplay().syncExec(new Runnable(){

                public void run() {
                    InstallerUiEswt.this.iParent.setMaximized(true);
                }
            });
        } else {
            this.iProgressView.updateProgress(100);
            if (this.iProgressView.isVisible()) {
                this.iProgressView.setVisible(false);
            }
            this.ended();
        }
    }

    public void error(InstallerExceptionBase aInstallerException) {
        super.error(aInstallerException);
        this.waitForUi();
        boolean identified = false;
        if (this.iInstallInfo != null) {
            if (this.iInstallInfo.getCertificates() != null) {
                identified = true;
            }
        } else if (this.iUninstallInfo != null && this.iUninstallInfo.getCertificates() != null) {
            identified = true;
        }
        String tmpTitle = "";
        if (this.iMode == 1) {
            tmpTitle = InstallerUiTexts.get("failed");
        } else if (this.iMode == 2) {
            tmpTitle = InstallerUiTexts.get("uninst_failed");
        }
        if (this.iProgressView != null) {
            this.iProgressView.setVisible(false);
        }
        RuntimeUi runtimeUi = RuntimeUiFactory.getRuntimeUi(identified);
        runtimeUi.error(tmpTitle, aInstallerException);
        runtimeUi.destroy();
    }

    public String[] getUsernamePassword(String aUrl) {
        this.waitForUi();
        if (!this.isUiReady()) {
            return null;
        }
        if (this.iUsernamePasswordView == null) {
            Display display = this.iParent.getDisplay();
            display.syncExec(new Runnable(){

                public void run() {
                    InstallerUiEswt.this.iUsernamePasswordView = new UsernamePasswordView((Composite)InstallerUiEswt.this.createNewShell(67584));
                }
            });
            this.iUsernamePasswordView.setInstallerUi(this);
        }
        this.iUsernamePasswordView.setAppName(this.iAppName);
        String[] usernamePassword = this.iUsernamePasswordView.getUsernamePassword(aUrl);
        this.iUsernamePasswordView.dispose();
        this.iUsernamePasswordView = null;
        if (usernamePassword != null) {
            InstallerUiEswt.log("Username: " + usernamePassword[0]);
        } else {
            InstallerUiEswt.log("No username and password provided");
        }
        return usernamePassword;
    }

    public boolean launchAppQuery(LaunchAppInfo aLaunchAppInfo) {
        this.waitForUi();
        if (!this.isUiReady() || this.iConfirmationsCanceled) {
            return false;
        }
        if (this.iLaunchAppQueryView == null) {
            Display display = this.iParent.getDisplay();
            display.syncExec(new Runnable(){

                public void run() {
                    InstallerUiEswt.this.iLaunchAppQueryView = new LaunchAppQueryView((Composite)InstallerUiEswt.this.createNewShell(67584));
                }
            });
            this.iLaunchAppQueryView.setInstallerUi(this);
        }
        boolean result = this.iLaunchAppQueryView.launchAppQuery(aLaunchAppInfo);
        this.iLaunchAppQueryView.dispose();
        this.iLaunchAppQueryView = null;
        InstallerUiEswt.log("LaunchAppQuery returns " + result + " for " + aLaunchAppInfo);
        return result;
    }

    protected Image getSecurityIcon(Display aDisplay, boolean aIdentified) {
        if (this.iSecurityIcon != null) {
            return this.iSecurityIcon;
        }
        String iconFilename = "java_untrusted.png";
        if (aIdentified) {
            iconFilename = "java_trusted.png";
        }
        String resourceDir = ResourceUtil.getResourceDir(0);
        int i = 1;
        while (this.iSecurityIcon == null && resourceDir != null) {
            this.iSecurityIcon = InstallerUiEswt.loadImage(aDisplay, resourceDir + iconFilename, false);
            resourceDir = ResourceUtil.getResourceDir(i);
            ++i;
        }
        return this.iSecurityIcon;
    }

    protected static Image loadImage(Display aDisplay, InputStream aInputStream, String aImageName) {
        return InstallerUiEswt.loadImage(aDisplay, aInputStream, aImageName, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Image loadImage(Display aDisplay, String aImageFilename, boolean aScaleImage) {
        Image result = null;
        InputStream imageInputStream = null;
        try {
            FileUtility imageFile = new FileUtility(aImageFilename);
            if (imageFile.exists()) {
                imageInputStream = imageFile.openInputStream();
                result = InstallerUiEswt.loadImage(aDisplay, imageInputStream, aImageFilename, aScaleImage);
            }
        }
        catch (IOException ioe) {
            InstallerUiEswt.log("Can not get InputStream for " + aImageFilename + ": " + ioe);
        }
        finally {
            if (imageInputStream != null) {
                try {
                    imageInputStream.close();
                    imageInputStream = null;
                }
                catch (IOException ioe) {
                    InstallerUiEswt.logError("Closing image InputStream failed", ioe);
                }
            }
        }
        return result;
    }

    private static Image loadImage(Display aDisplay, InputStream aInputStream, String aImageName, boolean aScaleImage) {
        Image result = null;
        if (aImageName != null) {
            result = (Image)iImageTable.get(aImageName);
        }
        if (result != null) {
            InstallerUiEswt.log("Using already loaded image " + aImageName);
            return result;
        }
        try {
            long startTime = System.currentTimeMillis();
            ImageData[] imageDatas = new ImageLoader().load(aInputStream);
            ImageData imageData = imageDatas[0];
            if (aScaleImage) {
                Point bestSize = InstallerUiEswt.getBestImageSize(imageData.width, imageData.height);
                if (bestSize.x != imageData.width || bestSize.y != imageData.height) {
                    imageData = imageData.scaledTo(bestSize.x, bestSize.y);
                    InstallerUiEswt.log("Image " + aImageName + " scaled from " + imageDatas[0].width + "x" + imageDatas[0].height + " to " + bestSize.x + "x" + bestSize.y);
                }
            }
            result = new Image((Device)aDisplay, imageData);
            long endTime = System.currentTimeMillis();
            InstallerUiEswt.log("Loaded image " + aImageName + " (load time " + (endTime - startTime) + " ms)");
            iImageTable.put(aImageName, result);
        }
        catch (Throwable t) {
            InstallerUiEswt.log("Can not load image " + aImageName + ": " + t);
        }
        return result;
    }

    private static Point getBestImageSize(int aWidth, int aHeight) {
        int MAX_WIDTH = 50;
        int MAX_HEIGHT = 50;
        Point result = new Point(aWidth, aHeight);
        if (result.x > 50 || result.y > 50) {
            if (result.x >= 50) {
                result.x = 50;
                result.y = 50 * aHeight / aWidth;
            }
            if (result.y >= 50) {
                result.x = 50 * aWidth / aHeight;
                result.y = 50;
            }
        }
        return result;
    }

    protected boolean isUiReady() {
        if (this.iProgressView == null) {
            InstallerUiEswt.log("ui not ready, iProgressView is null");
            return false;
        }
        if (this.iProgressView.isDisposed()) {
            InstallerUiEswt.log("ui not ready, iProgressView is disposed");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForUi() {
        Object object = this.iInitWaitObject;
        synchronized (object) {
            try {
                if (this.iUiThreadExists && this.iProgressView == null) {
                    this.iInitWaitObject.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private Shell createNewShell(int aStyle) {
        if (this.iProgressView != null) {
            return new Shell(this.iProgressView.getShell(), aStyle);
        }
        return new Shell(this.iParent, aStyle);
    }

    private void screenOrientationChanged() {
        if (this.iProgressView != null) {
            this.iProgressView.screenOrientationChanged();
        }
        if (this.iDlProgressView != null) {
            this.iDlProgressView.screenOrientationChanged();
        }
        if (this.iOcspProgressView != null) {
            this.iOcspProgressView.screenOrientationChanged();
        }
        if (this.iInstallConfirmationView != null) {
            this.iInstallConfirmationView.screenOrientationChanged();
        }
        if (this.iUninstallConfirmationView != null) {
            this.iUninstallConfirmationView.screenOrientationChanged();
        }
        if (this.iPermissionConfirmationView != null) {
            this.iPermissionConfirmationView.screenOrientationChanged();
        }
        if (this.iUsernamePasswordView != null) {
            this.iUsernamePasswordView.screenOrientationChanged();
        }
        if (this.iLaunchAppQueryView != null) {
            this.iLaunchAppQueryView.screenOrientationChanged();
        }
    }

    private static class CListener
    implements ControlListener {
        private InstallerUiEswt iInstallerUi = null;

        CListener(InstallerUiEswt aInstallerUi) {
            this.iInstallerUi = aInstallerUi;
        }

        public void controlMoved(ControlEvent aEvent) {
            InstallerUiEswt.log("CListener.controlMoved: " + aEvent);
        }

        public void controlResized(ControlEvent aEvent) {
            InstallerUiEswt.log("CListener.controlResized: " + aEvent);
            this.iInstallerUi.screenOrientationChanged();
        }
    }
}

