/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.location;

import com.nokia.mj.impl.security.common.PermissionBase;
import com.nokia.mj.impl.security.utils.SecurityPromptMessage;
import java.security.Permission;
import java.security.PermissionCollection;

public class LocationPermission
extends PermissionBase {
    public String iAction = null;

    public LocationPermission(String aName, String aAction) {
        super(aName);
        this.iAction = aAction;
    }

    public String getSecurityPromptQuestion() {
        if (LocationPermission.matchActions(this.iAction, "position")) {
            return SecurityPromptMessage.getInstance().getText("positioning_data_usage", null);
        }
        if (LocationPermission.matchActions(this.iAction, "orientation")) {
            return SecurityPromptMessage.getInstance().getText("orientation_data_usage", null);
        }
        if (LocationPermission.matchActions(this.iAction, "read") || LocationPermission.matchActions(this.iAction, "write") || LocationPermission.matchActions(this.iAction, "category") || LocationPermission.matchActions(this.iAction, "management")) {
            return SecurityPromptMessage.getInstance().getText("landmark_data_usage", null);
        }
        if (LocationPermission.matchActions(this.iAction, "registerlistener")) {
            return SecurityPromptMessage.getInstance().getText("proximity_listener_registration", null);
        }
        return null;
    }

    public String toString() {
        String result = null;
        if (LocationPermission.matchActions(this.iAction, "position")) {
            result = "javax.microedition.location.Location";
        } else if (LocationPermission.matchActions(this.iAction, "orientation")) {
            result = "javax.microedition.location.Orientation";
        } else if (LocationPermission.matchActions(this.iAction, "read")) {
            result = "javax.microedition.location.LandmarkStore.read";
        } else if (LocationPermission.matchActions(this.iAction, "write")) {
            result = "javax.microedition.location.LandmarkStore.write";
        } else if (LocationPermission.matchActions(this.iAction, "category")) {
            result = "javax.microedition.location.LandmarkStore.category";
        } else if (LocationPermission.matchActions(this.iAction, "management")) {
            result = "javax.microedition.location.LandmarkStore.management";
        } else if (LocationPermission.matchActions(this.iAction, "registerlistener")) {
            result = "javax.microedition.location.ProximityListener";
        }
        return result;
    }

    public boolean implies(Permission perm) {
        if (perm instanceof LocationPermission) {
            LocationPermission permission = (LocationPermission)perm;
            if (LocationPermission.matchActions(this.iAction, permission.iAction)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return 0;
    }

    public boolean equals(Object obj) {
        return true;
    }

    public String getActions() {
        return "";
    }

    public PermissionCollection newPermissionCollection() {
        return null;
    }
}

