/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.pim;

import com.nokia.mj.impl.pim.PIMListImpl;
import com.nokia.mj.impl.pim.PIMPermissionImpl;
import com.nokia.mj.impl.pim.utils.NativeError;
import com.nokia.mj.impl.rt.support.ApplicationUtils;
import com.nokia.mj.impl.rt.support.Finalizer;
import com.nokia.mj.impl.rt.support.ShutdownListener;
import javax.microedition.pim.FieldFullException;
import javax.microedition.pim.PIMException;
import javax.microedition.pim.PIMItem;
import javax.microedition.pim.PIMList;
import javax.microedition.pim.UnsupportedFieldException;

public abstract class PIMItemImpl
implements PIMItem {
    protected static final String PIM_NULL_ARRAY_ELEMENT = "T&%3#";
    private Finalizer iFinalizer;
    protected int iItemHandle = -1;
    protected int iItemType = -1;
    protected PIMListImpl iList;

    protected PIMItemImpl() {
        this.setShutdownListener();
        this.iFinalizer = this.registerForFinalization();
    }

    protected PIMItemImpl(int aItemHandle) {
        this();
        this.iItemHandle = aItemHandle;
    }

    protected PIMItemImpl(int aItemHandle, PIMListImpl aList) {
        this(aItemHandle);
        this.iList = aList;
    }

    public Finalizer registerForFinalization() {
        return new Finalizer(){

            public void finalizeImpl() {
                PIMItemImpl.this.doFinalize();
            }
        };
    }

    void doFinalize() {
        if (this.iFinalizer == null) {
            return;
        }
        this.iFinalizer = null;
        if (this.iItemHandle != 0) {
            this._dispose(this.iItemHandle);
            this.iItemHandle = 0;
        }
    }

    private void setShutdownListener() {
        ApplicationUtils appUtils = ApplicationUtils.getInstance();
        appUtils.addShutdownListener(new ShutdownListener(){

            public void shuttingDown() {
                if (PIMItemImpl.this.iItemHandle != 0) {
                    PIMItemImpl.this._dispose(PIMItemImpl.this.iItemHandle);
                    PIMItemImpl.this.iItemHandle = 0;
                }
            }
        });
    }

    int jniNativeHandle() {
        return this.iItemHandle;
    }

    int getItemType() {
        return this.iItemType;
    }

    void removeListAssociation() {
        this.iList = null;
    }

    protected void baseCopyFrom(PIMItem aItem) {
        int[] fields = aItem.getFields();
        for (int fieldIndex = 0; fieldIndex < fields.length; ++fieldIndex) {
            int field = fields[fieldIndex];
            int numValues = aItem.countValues(field);
            int fieldDataType = this._fieldDataType(this.iItemHandle, field);
            for (int valueIndex = 0; valueIndex < numValues; ++valueIndex) {
                int attributes = aItem.getAttributes(field, valueIndex);
                try {
                    switch (fieldDataType) {
                        case 1: {
                            boolean value = aItem.getBoolean(field, valueIndex);
                            this.addBoolean(field, attributes, value);
                            break;
                        }
                        case 2: {
                            long value = aItem.getDate(field, valueIndex);
                            this.addDate(field, attributes, value);
                            break;
                        }
                        case 3: {
                            int value = aItem.getInt(field, valueIndex);
                            this.addInt(field, attributes, value);
                            break;
                        }
                        case 0: {
                            byte[] value = aItem.getBinary(field, valueIndex);
                            this.addBinary(field, attributes, value, 0, value.length);
                            break;
                        }
                        case 4: {
                            String value = aItem.getString(field, valueIndex);
                            this.addString(field, attributes, value);
                            break;
                        }
                        case 5: {
                            String[] value = aItem.getStringArray(field, valueIndex);
                            this.addStringArray(field, attributes, value);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Invalid field data type: " + fieldDataType);
                        }
                    }
                    continue;
                }
                catch (UnsupportedFieldException ufe) {
                    continue;
                }
                catch (FieldFullException ffe) {
                    // empty catch block
                }
            }
        }
        String[] categories = aItem.getCategories();
        for (int categoryIndex = 0; categoryIndex < categories.length; ++categoryIndex) {
            try {
                this.addToCategory(categories[categoryIndex]);
                continue;
            }
            catch (PIMException pe) {
                // empty catch block
            }
        }
    }

    void checkBinaryHandlingArguments(byte[] aValue, int aOffset, int aLength) {
        if (aValue == null) {
            throw new NullPointerException("Value is null");
        }
        if (aValue.length == 0) {
            throw new IllegalArgumentException("Value is empty.");
        }
        if (aOffset < 0 || aOffset >= aValue.length) {
            throw new IllegalArgumentException("Invalid offset: " + aOffset);
        }
        if (aLength <= 0) {
            throw new IllegalArgumentException("Invalid length: " + aLength);
        }
    }

    abstract String getShortInfo();

    public synchronized PIMList getPIMList() {
        return this.iList;
    }

    public synchronized void commit() throws PIMException {
        if (this.iList == null) {
            throw new PIMException("Item does not belong to a list", 1);
        }
        if (!this.iList.isOpen()) {
            throw new PIMException("Commit operation failed:List is closed", 2);
        }
        this.iList.checkModeMinimum(2);
        ApplicationUtils appUtils = ApplicationUtils.getInstance();
        String action = null;
        switch (this.iList.getListType()) {
            case 1: {
                action = "write_contacts";
                break;
            }
            case 2: {
                action = "write_events";
                break;
            }
            case 3: {
                action = "write_todos";
            }
        }
        PIMPermissionImpl per = new PIMPermissionImpl(action, this.getShortInfo(), this.iList.getName(), 2);
        appUtils.checkPermission(per);
        int err = this._commit(this.iItemHandle);
        NativeError.handleItemCommitError(err);
        this.iList.itemCommitted(this);
    }

    public synchronized boolean isModified() {
        return this._isModified(this.iItemHandle);
    }

    public synchronized int[] getFields() {
        int[] fields = this._getFields(this.iItemHandle);
        if (fields == null) {
            throw new OutOfMemoryError();
        }
        return fields;
    }

    public synchronized byte[] getBinary(int aField, int aIndex) {
        int[] error = new int[1];
        byte[] value = this._getBinary(this.iItemHandle, aField, aIndex, error);
        NativeError.handleFieldHandlingError(error[0], aField, aIndex);
        return value;
    }

    public synchronized void addBinary(int aField, int aAttributes, byte[] aValue, int aOffset, int aLength) {
        this.checkBinaryHandlingArguments(aValue, aOffset, aLength);
        int error = this._addBinary(this.iItemHandle, aField, aAttributes, aValue, aOffset, aLength);
        NativeError.handleFieldHandlingError(error, aField);
    }

    public synchronized void setBinary(int aField, int aIndex, int aAttributes, byte[] aValue, int aOffset, int aLength) {
        this.checkBinaryHandlingArguments(aValue, aOffset, aLength);
        int error = this._setBinary(this.iItemHandle, aField, aIndex, aAttributes, aValue, aOffset, aLength);
        NativeError.handleFieldHandlingError(error, aField, aIndex);
    }

    public synchronized long getDate(int aField, int aIndex) {
        int[] error = new int[1];
        long value = this._getDate(this.iItemHandle, aField, aIndex, error);
        NativeError.handleFieldHandlingError(error[0], aField, aIndex);
        return value;
    }

    public synchronized void addDate(int aField, int aAttributes, long aValue) {
        int error = this._addDate(this.iItemHandle, aField, aAttributes, aValue);
        NativeError.handleFieldHandlingError(error, aField);
    }

    public synchronized void setDate(int aField, int aIndex, int aAttributes, long aValue) {
        int error = this._setDate(this.iItemHandle, aField, aIndex, aAttributes, aValue);
        NativeError.handleFieldHandlingError(error, aField, aIndex);
    }

    public synchronized int getInt(int aField, int aIndex) {
        int[] error = new int[1];
        int value = this._getInt(this.iItemHandle, aField, aIndex, error);
        NativeError.handleFieldHandlingError(error[0], aField, aIndex);
        return value;
    }

    public synchronized void addInt(int aField, int aAttributes, int aValue) {
        int error = this._addInt(this.iItemHandle, aField, aAttributes, aValue);
        NativeError.handleFieldHandlingError(error, aField);
    }

    public synchronized void setInt(int aField, int aIndex, int aAttributes, int aValue) {
        int error = this._setInt(this.iItemHandle, aField, aIndex, aAttributes, aValue);
        NativeError.handleFieldHandlingError(error, aField, aIndex);
    }

    public synchronized String getString(int aField, int aIndex) {
        int[] error = new int[1];
        String value = this._getString(this.iItemHandle, aField, aIndex, error);
        NativeError.handleFieldHandlingError(error[0], aField, aIndex);
        return value;
    }

    public synchronized void addString(int aField, int aAttributes, String aValue) {
        if (aValue == null) {
            throw new NullPointerException("Value is null");
        }
        int error = this._addString(this.iItemHandle, aField, aAttributes, aValue);
        NativeError.handleFieldHandlingError(error, aField);
    }

    public synchronized void setString(int aField, int aIndex, int aAttributes, String aValue) {
        if (aValue == null) {
            throw new NullPointerException("Value is null");
        }
        int error = this._setString(this.iItemHandle, aField, aIndex, aAttributes, aValue);
        NativeError.handleFieldHandlingError(error, aField, aIndex);
    }

    public synchronized boolean getBoolean(int aField, int aIndex) {
        int[] error = new int[1];
        boolean value = this._getBoolean(this.iItemHandle, aField, aIndex, error);
        NativeError.handleFieldHandlingError(error[0], aField, aIndex);
        return value;
    }

    public synchronized void addBoolean(int aField, int aAttributes, boolean aValue) {
        int error = this._addBoolean(this.iItemHandle, aField, aAttributes, aValue);
        NativeError.handleFieldHandlingError(error, aField);
    }

    public synchronized void setBoolean(int aField, int aIndex, int aAttributes, boolean aValue) {
        int error = this._setBoolean(this.iItemHandle, aField, aIndex, aAttributes, aValue);
        NativeError.handleFieldHandlingError(error, aField, aIndex);
    }

    public synchronized String[] getStringArray(int aField, int aIndex) {
        int[] error = new int[1];
        String[] value = this._getStringArray(this.iItemHandle, aField, aIndex, error);
        NativeError.handleFieldHandlingError(error[0], aField, aIndex);
        this.unTagNullArrayElements(value);
        return value;
    }

    public synchronized void addStringArray(int aField, int aAttributes, String[] aValue) {
        if (aValue == null) {
            throw new NullPointerException("Value is null");
        }
        String[] taggedValue = this.tagNullArrayElements(aValue);
        int error = this._addStringArray(this.iItemHandle, aField, aAttributes, taggedValue);
        NativeError.handleFieldHandlingError(error, aField);
    }

    public synchronized void setStringArray(int aField, int aIndex, int aAttributes, String[] aValue) {
        if (aValue == null) {
            throw new NullPointerException("Value is null");
        }
        String[] taggedValue = this.tagNullArrayElements(aValue);
        int error = this._setStringArray(this.iItemHandle, aField, aIndex, aAttributes, taggedValue);
        NativeError.handleFieldHandlingError(error, aField, aIndex);
    }

    public synchronized int countValues(int aField) {
        int numValues = this._countValues(this.iItemHandle, aField);
        if (numValues < 0) {
            NativeError.handleFieldHandlingError(numValues, aField);
        }
        return numValues;
    }

    public synchronized void removeValue(int aField, int aIndex) {
        int error = this._removeValue(this.iItemHandle, aField, aIndex);
        NativeError.handleFieldHandlingError(error, aField, aIndex);
    }

    public synchronized int getAttributes(int aField, int aIndex) {
        int[] error = new int[1];
        int attributes = this._getAttributes(this.iItemHandle, aField, aIndex, error);
        NativeError.handleFieldHandlingError(error[0], aField, aIndex);
        return attributes;
    }

    public synchronized void addToCategory(String aCategory) throws PIMException {
        if (aCategory == null) {
            throw new NullPointerException("Category is null");
        }
        int error = this._addToCategory(this.iItemHandle, aCategory);
        NativeError.handleCategoryHandlingError(error, aCategory);
    }

    public synchronized void removeFromCategory(String aCategory) {
        if (aCategory == null) {
            throw new NullPointerException("Category is null");
        }
        this._removeFromCategory(this.iItemHandle, aCategory);
    }

    public synchronized String[] getCategories() {
        String[] categories = this._getCategories(this.iItemHandle);
        if (categories == null) {
            throw new OutOfMemoryError();
        }
        return categories;
    }

    public synchronized int maxCategories() {
        return this._maxCategories(this.iItemHandle);
    }

    protected String[] tagNullArrayElements(String[] aStringArray) {
        String[] taggedArray = new String[aStringArray.length];
        for (int i = 0; i < aStringArray.length; ++i) {
            taggedArray[i] = aStringArray[i] == null ? PIM_NULL_ARRAY_ELEMENT : aStringArray[i];
        }
        return taggedArray;
    }

    protected void unTagNullArrayElements(String[] aStringArray) {
        for (int i = 0; i < aStringArray.length; ++i) {
            if (!PIM_NULL_ARRAY_ELEMENT.equals(aStringArray[i])) continue;
            aStringArray[i] = null;
        }
    }

    protected boolean isFieldSupportedAndPresent(int aField) {
        return (this.iList == null || this.iList.isSupportedField(aField)) && this.countValues(aField) > 0;
    }

    private native void _dispose(int var1);

    private native int _fieldDataType(int var1, int var2);

    private native int _commit(int var1);

    private native boolean _isModified(int var1);

    private native int[] _getFields(int var1);

    private native byte[] _getBinary(int var1, int var2, int var3, int[] var4);

    private native int _addBinary(int var1, int var2, int var3, byte[] var4, int var5, int var6);

    private native int _setBinary(int var1, int var2, int var3, int var4, byte[] var5, int var6, int var7);

    private native long _getDate(int var1, int var2, int var3, int[] var4);

    private native int _addDate(int var1, int var2, int var3, long var4);

    private native int _setDate(int var1, int var2, int var3, int var4, long var5);

    private native int _getInt(int var1, int var2, int var3, int[] var4);

    private native int _addInt(int var1, int var2, int var3, int var4);

    private native int _setInt(int var1, int var2, int var3, int var4, int var5);

    private native String _getString(int var1, int var2, int var3, int[] var4);

    private native int _addString(int var1, int var2, int var3, String var4);

    private native int _setString(int var1, int var2, int var3, int var4, String var5);

    private native boolean _getBoolean(int var1, int var2, int var3, int[] var4);

    private native int _addBoolean(int var1, int var2, int var3, boolean var4);

    private native int _setBoolean(int var1, int var2, int var3, int var4, boolean var5);

    private native String[] _getStringArray(int var1, int var2, int var3, int[] var4);

    private native int _addStringArray(int var1, int var2, int var3, String[] var4);

    private native int _setStringArray(int var1, int var2, int var3, int var4, String[] var5);

    private native int _countValues(int var1, int var2);

    private native int _removeValue(int var1, int var2, int var3);

    private native int _getAttributes(int var1, int var2, int var3, int[] var4);

    private native int _addToCategory(int var1, String var2);

    private native void _removeFromCategory(int var1, String var2);

    private native String[] _getCategories(int var1);

    private native int _maxCategories(int var1);
}

