/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.pim;

import com.nokia.mj.impl.pim.GenericException;
import com.nokia.mj.impl.pim.ItemTable;
import com.nokia.mj.impl.pim.PIMItemImpl;
import com.nokia.mj.impl.pim.PIMManager;
import com.nokia.mj.impl.pim.PIMPermissionImpl;
import com.nokia.mj.impl.pim.utils.NativeError;
import com.nokia.mj.impl.rt.support.ApplicationUtils;
import com.nokia.mj.impl.rt.support.Finalizer;
import com.nokia.mj.impl.rt.support.ShutdownListener;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.pim.FieldFullException;
import javax.microedition.pim.PIMException;
import javax.microedition.pim.PIMItem;
import javax.microedition.pim.PIMList;
import javax.microedition.pim.UnsupportedFieldException;

public abstract class PIMListImpl
implements PIMList {
    private static final int LABEL_TYPE_FIELD = 1;
    private static final int LABEL_TYPE_ATTRIBUTE = 2;
    private static final int LABEL_TYPE_ARRAY_ELEMENT = 3;
    protected static final int ENUMERATION_ITEMS_ALL = 0;
    protected static final int ENUMERATION_ITEMS_MATCHING_ITEM = 1;
    protected static final int ENUMERATION_ITEMS_MATCHING_STRING = 2;
    protected static final int ENUMERATION_ITEMS_MATCHING_CATEGORY = 3;
    private Finalizer iFinalizer;
    protected int iListHandle;
    protected ItemTable iItems;
    private int iMode = 0;
    private boolean iIsOpen = true;

    PIMListImpl(int aListHandle, int aMode) {
        this.iListHandle = aListHandle;
        this.setShutdownListener();
        this.iFinalizer = this.registerForFinalization();
        this.iMode = aMode;
        this.iItems = new ItemTable();
    }

    public Finalizer registerForFinalization() {
        return new Finalizer(){

            public void finalizeImpl() {
                PIMListImpl.this.doFinalize();
            }
        };
    }

    void doFinalize() {
        if (this.iFinalizer == null) {
            return;
        }
        this.iFinalizer = null;
        if (this.iListHandle != 0) {
            this._dispose(this.iListHandle);
            this.iListHandle = 0;
        }
    }

    private void setShutdownListener() {
        ApplicationUtils appUtils = ApplicationUtils.getInstance();
        appUtils.addShutdownListener(new ShutdownListener(){

            public void shuttingDown() {
                if (PIMListImpl.this.iListHandle != 0) {
                    PIMListImpl.this._dispose(PIMListImpl.this.iListHandle);
                    PIMListImpl.this.iListHandle = 0;
                }
            }
        });
    }

    abstract int getListType();

    boolean isOpen() {
        return this.iIsOpen;
    }

    void itemCommitted(PIMItemImpl aCommittedItem) {
        if (!this.iItems.containsItem(aCommittedItem)) {
            int committedItemHandle = aCommittedItem.jniNativeHandle();
            int error = this._addCommittedItem(this.iListHandle, committedItemHandle);
            if (!NativeError.checkSuccess(error)) {
                throw new GenericException("General error:" + error);
            }
            this.iItems.addItem(aCommittedItem);
        }
    }

    protected PIMItemImpl createItem() {
        int[] err = new int[1];
        int itemHandle = this._createItem(this.iListHandle, err);
        if (!NativeError.checkSuccess(err[0])) {
            throw new GenericException("General error:" + err[0]);
        }
        PIMItemImpl item = this.createAssociatedItem(itemHandle);
        return item;
    }

    protected void removeItem(PIMItem aItem) throws PIMException {
        if (aItem == null) {
            throw new NullPointerException("Item is null");
        }
        if (!(aItem instanceof PIMItemImpl)) {
            throw new PIMException("Removal failed:Invalid item", 1);
        }
        if (!this.isOpen()) {
            throw new PIMException("Removal failed:List is closed", 2);
        }
        PIMItemImpl item = (PIMItemImpl)aItem;
        if (!this.iItems.containsItem(item)) {
            throw new PIMException("Removal failed:Item is not in the List", 1);
        }
        ApplicationUtils appUtils = ApplicationUtils.getInstance();
        String action = null;
        switch (this.getListType()) {
            case 1: {
                action = "write_contacts";
                break;
            }
            case 2: {
                action = "write_events";
                break;
            }
            case 3: {
                action = "write_todos";
            }
        }
        PIMPermissionImpl per = new PIMPermissionImpl(action, item.getShortInfo(), this.getName(), 1);
        appUtils.checkPermission(per);
        int itemHandle = item.jniNativeHandle();
        int err = this._removeItem(this.iListHandle, itemHandle);
        NativeError.handleRemoveItemError(err);
        PIMItemImpl removedItem = this.iItems.removeItem(item);
        if (removedItem != null) {
            removedItem.removeListAssociation();
        }
    }

    protected void updateRevisionField(PIMItem aItem, int aField, int aAttributes) {
        PIMList list = aItem.getPIMList();
        if (list.isSupportedField(aField)) {
            Date thisDate = new Date();
            try {
                if (aItem.countValues(aField) > 0) {
                    aItem.setDate(aField, 0, aAttributes, thisDate.getTime());
                } else {
                    aItem.addDate(aField, aAttributes, thisDate.getTime());
                }
            }
            catch (UnsupportedFieldException ufe) {
            }
            catch (FieldFullException ffe) {
                // empty catch block
            }
        }
    }

    public synchronized String getName() {
        String name = this._getName(this.iListHandle);
        if (name == null) {
            throw new OutOfMemoryError();
        }
        return name;
    }

    public synchronized void close() throws PIMException {
        if (!this.iIsOpen) {
            throw new PIMException("List is already closed", 2);
        }
        this.iIsOpen = false;
        int err = this._close(this.iListHandle);
        NativeError.handlePIMListCloseError(err);
        this.iItems = null;
    }

    public synchronized Enumeration items() throws PIMException {
        this.ensurePimPermission(1);
        return this.doItems(0, 0, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Enumeration items(PIMItem aMatchingItem) throws PIMException {
        this.ensurePimPermission(1);
        if (aMatchingItem == null) {
            throw new NullPointerException("Item is null");
        }
        if (!(aMatchingItem instanceof PIMItemImpl)) {
            throw new PIMException("Invalid item", 1);
        }
        if (aMatchingItem.getPIMList() != this) {
            throw new IllegalArgumentException("The item does not originate from the list");
        }
        PIMItemImpl matchingItemImpl = (PIMItemImpl)aMatchingItem;
        Enumeration items = null;
        PIMItemImpl pIMItemImpl = matchingItemImpl;
        synchronized (pIMItemImpl) {
            int matchingItemHandle = matchingItemImpl.jniNativeHandle();
            items = this.doItems(1, matchingItemHandle, null);
        }
        return items;
    }

    public synchronized Enumeration items(String aMatchingValue) throws PIMException {
        this.ensurePimPermission(1);
        if (aMatchingValue == null) {
            throw new NullPointerException("Searching failed:String value is null");
        }
        return this.doItems(2, 0, aMatchingValue);
    }

    public synchronized Enumeration itemsByCategory(String aCategory) throws PIMException {
        this.ensurePimPermission(1);
        return this.doItems(3, 0, aCategory);
    }

    public synchronized String[] getCategories() throws PIMException {
        int[] error = new int[1];
        String[] categories = this._getCategories(this.iListHandle, error);
        NativeError.handleCategoryHandlingError(error[0]);
        return categories;
    }

    public synchronized boolean isCategory(String aCategory) throws PIMException {
        if (aCategory == null) {
            throw new NullPointerException("Category missing");
        }
        int[] error = new int[1];
        boolean isCategory = this._isCategory(this.iListHandle, aCategory, error);
        NativeError.handleCategoryHandlingError(error[0]);
        return isCategory;
    }

    public synchronized void addCategory(String aCategory) throws PIMException {
        this.ensurePimPermission(2);
        if (aCategory == null) {
            throw new NullPointerException("Category is null");
        }
        int[] error = new int[1];
        this._addCategory(this.iListHandle, aCategory, error);
        NativeError.handleCategoryHandlingError(error[0], aCategory);
    }

    public synchronized void deleteCategory(String aCategory, boolean aDeleteUnassignedItems) throws PIMException {
        this.checkModeMinimum(2);
        if (aCategory == null) {
            throw new NullPointerException("Category is null");
        }
        ApplicationUtils appUtils = ApplicationUtils.getInstance();
        String action = null;
        switch (this.getListType()) {
            case 1: {
                action = "write_contacts";
                break;
            }
            case 2: {
                action = "write_events";
                break;
            }
            case 3: {
                action = "write_todos";
            }
        }
        PIMPermissionImpl per = new PIMPermissionImpl(action, aCategory, this.getName(), 3);
        appUtils.checkPermission(per);
        int[] error = new int[1];
        int[] unassignedItemHandles = this._deleteCategory(this.iListHandle, aCategory, error);
        NativeError.handleCategoryHandlingError(error[0], aCategory);
        if (aDeleteUnassignedItems && unassignedItemHandles != null) {
            for (int i = 0; i < unassignedItemHandles.length; ++i) {
                int itemHandle = unassignedItemHandles[i];
                PIMItemImpl item = this.iItems.getItem(itemHandle);
                if (item == null) continue;
                this.removeItem(item);
            }
        }
    }

    public synchronized void renameCategory(String aCurrentCategory, String aNewCategory) throws PIMException {
        this.ensurePimPermission(2);
        if (aCurrentCategory == null || aNewCategory == null) {
            throw new NullPointerException("Category is null");
        }
        int error = this._renameCategory(this.iListHandle, aCurrentCategory, aNewCategory);
        if (NativeError.checkArgumentError(error)) {
            NativeError.handleCategoryHandlingError(error);
        } else {
            NativeError.handleCategoryHandlingError(error, aCurrentCategory);
        }
    }

    public synchronized int maxCategories() {
        return this._maxCategories(this.iListHandle);
    }

    public synchronized boolean isSupportedField(int aField) {
        return this._isSupportedField(this.iListHandle, aField);
    }

    public synchronized int[] getSupportedFields() {
        int[] supportedFields = this._getSupportedFields(this.iListHandle);
        if (supportedFields == null) {
            throw new OutOfMemoryError();
        }
        return supportedFields;
    }

    public synchronized boolean isSupportedAttribute(int aField, int aAttribute) {
        return this._isSupportedAttribute(this.iListHandle, aField, aAttribute);
    }

    public synchronized int[] getSupportedAttributes(int aField) {
        int[] error = new int[1];
        int[] supportedAttributes = this._getSupportedAttributes(this.iListHandle, aField, error);
        NativeError.handleFieldHandlingError(error[0], aField);
        return supportedAttributes;
    }

    public synchronized boolean isSupportedArrayElement(int aStringArrayField, int aArrayElement) {
        return this._isSupportedArrayElement(this.iListHandle, aStringArrayField, aArrayElement);
    }

    public synchronized int[] getSupportedArrayElements(int aStringArrayField) {
        int[] error = new int[1];
        int[] supportedArrayElements = this._getSupportedArrayElements(this.iListHandle, aStringArrayField, error);
        NativeError.handleFieldHandlingError(error[0], aStringArrayField);
        return supportedArrayElements;
    }

    public synchronized int getFieldDataType(int aField) {
        int[] error = new int[1];
        int fieldDataType = this._getFieldDataType(this.iListHandle, aField, error);
        NativeError.handleFieldHandlingError(error[0], aField);
        return fieldDataType;
    }

    public synchronized String getFieldLabel(int aField) {
        int[] labelSpec = new int[]{aField};
        int[] error = new int[1];
        String label = this._getLabel(this.iListHandle, 1, labelSpec, error);
        NativeError.handleFieldHandlingError(error[0], aField);
        return label;
    }

    public synchronized String getAttributeLabel(int aAttribute) {
        int[] labelSpec = new int[]{aAttribute};
        int[] error = new int[1];
        String label = this._getLabel(this.iListHandle, 2, labelSpec, error);
        NativeError.handlegetAttributeLabelError(error[0], aAttribute);
        return label;
    }

    public synchronized String getArrayElementLabel(int aStringArrayField, int aArrayElement) {
        int[] labelSpec = new int[]{aStringArrayField, aArrayElement};
        int[] error = new int[1];
        String label = this._getLabel(this.iListHandle, 3, labelSpec, error);
        NativeError.handleArrayElementLabelError(error[0]);
        return label;
    }

    public synchronized int maxValues(int aField) {
        int[] error = new int[1];
        int maxValues = this._maxValues(this.iListHandle, aField, error);
        NativeError.handleFieldHandlingError(error[0], aField);
        return maxValues;
    }

    public synchronized int stringArraySize(int aStringArrayField) {
        int[] error = new int[1];
        int stringArraySize = this._stringArraySize(this.iListHandle, aStringArrayField, error);
        NativeError.handleFieldHandlingError(error[0], aStringArrayField);
        return stringArraySize;
    }

    protected void updateList(int aMatchingItemHandle) throws PIMException {
        int[] error = new int[1];
        int[] newAndRemovedItemHandles = this._updateList(this.iListHandle, aMatchingItemHandle, error);
        NativeError.handleUpdateListError(error[0]);
        if (newAndRemovedItemHandles != null) {
            int itemHandle;
            int i;
            int removedItemsStart = 0;
            for (i = 0; i < newAndRemovedItemHandles.length; ++i) {
                if (newAndRemovedItemHandles[i] == 0) {
                    removedItemsStart = i + 1;
                    break;
                }
                itemHandle = newAndRemovedItemHandles[i];
                PIMItemImpl newItem = this.createAssociatedItem(itemHandle);
                this.iItems.addItem(newItem);
            }
            for (i = removedItemsStart; i < newAndRemovedItemHandles.length; ++i) {
                itemHandle = newAndRemovedItemHandles[i];
                PIMItemImpl item = this.iItems.removeItem(itemHandle);
                if (item == null) continue;
                item.removeListAssociation();
            }
        }
    }

    protected Enumeration doItems(int aEnumerationType, int aMatchingItemHandle, String aStringArg) throws PIMException {
        this.updateList(aMatchingItemHandle);
        int[] error = new int[1];
        int[] itemHandles = this._items(this.iListHandle, aEnumerationType, aMatchingItemHandle, aStringArg, error);
        return this.processItemsResults(itemHandles, error[0]);
    }

    protected Enumeration processItemsResults(int[] aItemHandles, int aError) throws PIMException {
        if (aItemHandles == null) {
            throw new OutOfMemoryError();
        }
        NativeError.handleProcessItemResultsError(aError);
        Vector items = new Vector(aItemHandles.length);
        for (int i = 0; i < aItemHandles.length; ++i) {
            int itemHandle = aItemHandles[i];
            PIMItemImpl item = this.iItems.getItem(itemHandle);
            if (item == null) continue;
            items.addElement(item);
        }
        return items.elements();
    }

    protected void ensurePimPermission(int aMode) {
        this.checkModeMinimum(aMode);
        PIMManager manager = (PIMManager)PIMManager.getInstance();
        manager.getPermission(this.getListType(), aMode);
    }

    protected abstract PIMItemImpl createAssociatedItem(int var1);

    boolean isModeMinimum(int aMode) {
        return (this.iMode & aMode) == aMode;
    }

    void checkModeMinimum(int aMode) {
        if (!this.isModeMinimum(aMode)) {
            throw new SecurityException();
        }
    }

    private native void _dispose(int var1);

    private native int _createItem(int var1, int[] var2);

    private native int _removeItem(int var1, int var2);

    private native int _addCommittedItem(int var1, int var2);

    private native String _getName(int var1);

    private native int _close(int var1);

    private native int[] _items(int var1, int var2, int var3, String var4, int[] var5);

    private native String[] _getCategories(int var1, int[] var2);

    private native boolean _isCategory(int var1, String var2, int[] var3);

    private native void _addCategory(int var1, String var2, int[] var3);

    private native int[] _deleteCategory(int var1, String var2, int[] var3);

    private native int _renameCategory(int var1, String var2, String var3);

    private native int _maxCategories(int var1);

    private native boolean _isSupportedField(int var1, int var2);

    private native int[] _getSupportedFields(int var1);

    private native boolean _isSupportedAttribute(int var1, int var2, int var3);

    private native int[] _getSupportedAttributes(int var1, int var2, int[] var3);

    private native boolean _isSupportedArrayElement(int var1, int var2, int var3);

    private native int[] _getSupportedArrayElements(int var1, int var2, int[] var3);

    private native int _getFieldDataType(int var1, int var2, int[] var3);

    private native String _getLabel(int var1, int var2, int[] var3, int[] var4);

    private native int _maxValues(int var1, int var2, int[] var3);

    private native int _stringArraySize(int var1, int var2, int[] var3);

    private native int[] _updateList(int var1, int var2, int[] var3);
}

