/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.pim;

import com.nokia.mj.impl.security.common.PermissionBase;
import com.nokia.mj.impl.security.utils.SecurityPromptMessage;
import java.security.Permission;
import java.security.PermissionCollection;

public class PIMPermissionImpl
extends PermissionBase {
    protected static final int OPERATION_ITEM_DELETION = 1;
    protected static final int OPERATION_ITEM_COMMIT = 2;
    protected static final int OPERATION_CATEGORY_DELETION = 3;
    protected static final String ACTION_READ_CONTACTS = "read_contacts";
    protected static final String ACTION_WRITE_CONTACTS = "write_contacts";
    protected static final String ACTION_READ_TODOS = "read_todos";
    protected static final String ACTION_WRITE_TODOS = "write_todos";
    protected static final String ACTION_READ_EVENTS = "read_events";
    protected static final String ACTION_WRITE_EVENTS = "write_events";
    int iOperation;
    String iListName = null;
    String iItemInfo = null;
    String iAction;

    PIMPermissionImpl(String aUri, String aAction) {
        super(aUri);
        this.iAction = aAction;
    }

    PIMPermissionImpl(String aAction, String aItemInfo, String aListName, int aOperation) {
        super("pim://*");
        this.iOperation = aOperation;
        this.iListName = aListName;
        this.iItemInfo = aItemInfo;
        this.iAction = aAction;
    }

    public String getSecurityPromptQuestion() {
        if (this.iOperation == 1) {
            if (this.iItemInfo == null) {
                return SecurityPromptMessage.getInstance().getText("deleting_unnamed_item", new String[]{this.iListName});
            }
            return SecurityPromptMessage.getInstance().getText("deleting_item", new String[]{this.iItemInfo, this.iListName});
        }
        if (this.iOperation == 2) {
            if (this.iItemInfo == null) {
                return SecurityPromptMessage.getInstance().getText("updating_unnamed_item", new String[]{this.iListName});
            }
            return SecurityPromptMessage.getInstance().getText("updating_item", new String[]{this.iItemInfo, this.iListName});
        }
        if (this.iOperation == 3) {
            return SecurityPromptMessage.getInstance().getText("deleting_category", new String[]{this.iItemInfo, this.iListName});
        }
        if (ACTION_READ_CONTACTS.equals(this.iAction)) {
            return SecurityPromptMessage.getInstance().getText("reading_contacts", null);
        }
        if (ACTION_READ_EVENTS.equals(this.iAction)) {
            return SecurityPromptMessage.getInstance().getText("reading_events", null);
        }
        if (ACTION_READ_TODOS.equals(this.iAction)) {
            return SecurityPromptMessage.getInstance().getText("reading_todos", null);
        }
        if (ACTION_WRITE_CONTACTS.equals(this.iAction)) {
            return SecurityPromptMessage.getInstance().getText("modifying_contacts", null);
        }
        if (ACTION_WRITE_EVENTS.equals(this.iAction)) {
            return SecurityPromptMessage.getInstance().getText("modifying_events", null);
        }
        if (ACTION_WRITE_TODOS.equals(this.iAction)) {
            return SecurityPromptMessage.getInstance().getText("modifying_todos", null);
        }
        if (PermissionBase.matchActions(this.iAction, "read_events,read_todos")) {
            return SecurityPromptMessage.getInstance().getText("listing_calendars", null);
        }
        if (PermissionBase.matchActions(this.iAction, "write_events,write_todos")) {
            if (this.iItemInfo == null) {
                return SecurityPromptMessage.getInstance().getText("adding_calendar", null);
            }
            return SecurityPromptMessage.getInstance().getText("deleting_calendar", new String[]{this.iItemInfo});
        }
        return null;
    }

    public String toString() {
        if (ACTION_READ_CONTACTS.equals(this.iAction)) {
            return "javax.microedition.pim.ContactList.read";
        }
        if (ACTION_READ_EVENTS.equals(this.iAction)) {
            return "javax.microedition.pim.EventList.read";
        }
        if (ACTION_READ_TODOS.equals(this.iAction)) {
            return "javax.microedition.pim.ToDoList.read";
        }
        if (ACTION_WRITE_CONTACTS.equals(this.iAction)) {
            return "javax.microedition.pim.ContactList.write";
        }
        if (ACTION_WRITE_EVENTS.equals(this.iAction)) {
            return "javax.microedition.pim.EventList.write";
        }
        if (ACTION_WRITE_TODOS.equals(this.iAction)) {
            return "javax.microedition.pim.ToDoList.write";
        }
        if (PermissionBase.matchActions(this.iAction, "read_events,read_todos")) {
            return "javax.microedition.pim.EventList.read, javax.microedition.pim.ToDoList.read";
        }
        if (PermissionBase.matchActions(this.iAction, "write_events,write_todos")) {
            return "javax.microedition.pim.EventList.write, javax.microedition.pim.ToDoList.write";
        }
        return null;
    }

    public boolean implies(Permission p) {
        if (p instanceof PIMPermissionImpl) {
            PIMPermissionImpl per = (PIMPermissionImpl)p;
            if (PermissionBase.matchActions(this.iAction, per.iAction)) {
                return true;
            }
        }
        return false;
    }

    public boolean equals(Object obj) {
        return true;
    }

    public int hashCode() {
        return 0;
    }

    public String getActions() {
        return this.iAction;
    }

    public PermissionCollection newPermissionCollection() {
        return null;
    }
}

