/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.properties.fileapi;

import com.nokia.mj.impl.file.FileSystemUtils;
import com.nokia.mj.impl.rt.support.SystemPropertyProvider;
import java.util.Hashtable;
import java.util.Vector;

public final class FileDynamicPropertyHandler
implements SystemPropertyProvider {
    private static final String FILECONN_DIR_GRAPHICS = "fileconn.dir.graphics";
    private static final String FILECONN_DIR_GRAPHICS_NAME = "fileconn.dir.graphics.name";
    private static final String FILECONN_DIR_MEMORYCARD = "fileconn.dir.memorycard";
    private static final String FILECONN_DIR_MEMORYCARD_NAME = "fileconn.dir.memorycard.name";
    private static final String FILECONN_DIR_MUSIC = "fileconn.dir.music";
    private static final String FILECONN_DIR_MUSIC_NAME = "fileconn.dir.music.name";
    private static final String FILECONN_DIR_PHOTOS = "fileconn.dir.photos";
    private static final String FILECONN_DIR_PHOTOS_NAME = "fileconn.dir.photos.name";
    private static final String FILECONN_DIR_PRIVATE = "fileconn.dir.private";
    private static final String FILECONN_DIR_PRIVATE_NAME = "fileconn.dir.private.name";
    private static final String FILECONN_DIR_RECORDINGS = "fileconn.dir.recordings";
    private static final String FILECONN_DIR_RECORDINGS_NAME = "fileconn.dir.recordings.name";
    private static final String FILECONN_DIR_ROOTS_NAMES = "fileconn.dir.roots.names";
    private static final String FILECONN_DIR_TONES = "fileconn.dir.tones";
    private static final String FILECONN_DIR_TONES_NAME = "fileconn.dir.tones.name";
    private static final String FILECONN_DIR_VIDEOS = "fileconn.dir.videos";
    private static final String FILECONN_DIR_VIDEOS_NAME = "fileconn.dir.videos.name";
    private static Hashtable iPropertyKeys = new Hashtable();
    private static Hashtable iLocalizedKeys;

    public String getProperty(String key) {
        String propertyValue = this.getURLValue(key);
        if (null != propertyValue) {
            return propertyValue;
        }
        propertyValue = this.getLocalizedValue(key);
        if (null != propertyValue) {
            return propertyValue;
        }
        if (key.equals(FILECONN_DIR_ROOTS_NAMES)) {
            return this.getRootNames();
        }
        if (key.equals(FILECONN_DIR_PRIVATE)) {
            return "file:///" + FileSystemUtils.getAppPrivateDir();
        }
        return null;
    }

    public boolean isStatic(String key) {
        if (key.equals(FILECONN_DIR_ROOTS_NAMES)) {
            return false;
        }
        return !key.equals(FILECONN_DIR_PRIVATE);
    }

    private String getURLValue(String propertyName) {
        Integer property = (Integer)iPropertyKeys.get(propertyName);
        if (null == property) {
            return null;
        }
        return FileSystemUtils.getPathOfProperty(property);
    }

    private String getLocalizedValue(String propertyName) {
        Integer property = (Integer)iLocalizedKeys.get(propertyName);
        if (null == property) {
            return null;
        }
        return FileSystemUtils.getLocalizedName(property);
    }

    private String getRootNames() {
        String retVal = "";
        try {
            Vector rootList = FileSystemUtils.getRootNames();
            for (int index = 0; index < rootList.size(); ++index) {
                retVal = retVal + rootList.elementAt(index);
                retVal = retVal + ";";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    static {
        iPropertyKeys.put(FILECONN_DIR_GRAPHICS, new Integer(2));
        iPropertyKeys.put(FILECONN_DIR_MEMORYCARD, new Integer(6));
        iPropertyKeys.put(FILECONN_DIR_MUSIC, new Integer(4));
        iPropertyKeys.put(FILECONN_DIR_PHOTOS, new Integer(0));
        iPropertyKeys.put(FILECONN_DIR_RECORDINGS, new Integer(5));
        iPropertyKeys.put(FILECONN_DIR_TONES, new Integer(3));
        iPropertyKeys.put(FILECONN_DIR_VIDEOS, new Integer(1));
        iLocalizedKeys = new Hashtable();
        iLocalizedKeys.put(FILECONN_DIR_GRAPHICS_NAME, new Integer(2));
        iLocalizedKeys.put(FILECONN_DIR_MEMORYCARD_NAME, new Integer(6));
        iLocalizedKeys.put(FILECONN_DIR_MUSIC_NAME, new Integer(4));
        iLocalizedKeys.put(FILECONN_DIR_PHOTOS_NAME, new Integer(0));
        iLocalizedKeys.put(FILECONN_DIR_RECORDINGS_NAME, new Integer(5));
        iLocalizedKeys.put(FILECONN_DIR_TONES_NAME, new Integer(3));
        iLocalizedKeys.put(FILECONN_DIR_VIDEOS_NAME, new Integer(1));
        iLocalizedKeys.put(FILECONN_DIR_PRIVATE_NAME, new Integer(8));
    }
}

