/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.rms;

import com.nokia.mj.impl.rms.Storage;
import com.nokia.mj.impl.rt.support.ApplicationInfo;
import com.nokia.mj.impl.rt.support.Jvm;
import com.nokia.mj.impl.storage.StorageAttribute;
import com.nokia.mj.impl.storage.StorageEntry;
import com.nokia.mj.impl.storage.StorageException;
import com.nokia.mj.impl.storage.StorageFactory;
import com.nokia.mj.impl.storage.StorageSession;
import com.nokia.mj.impl.utils.Logger;
import java.util.Hashtable;
import javax.microedition.rms.InvalidRecordIDException;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreFullException;
import javax.microedition.rms.RecordStoreNotFoundException;

public final class FileStorage
implements Storage {
    private String iName;
    private int iFileDescriptor;
    private RecordHeadersTable iHeadersTable;
    private RecordStoreHeader iStoreHeader;
    private RecordHeader iLastRecord;
    private int iNumLiveRecords;
    private long iLastUpdate;
    private int iVersion;
    private int iAuthMode;
    private int iNextRecordStoreId;
    private int iFirstRecOffset;
    private int iReservedID;
    private String iMIDletSuiteHomeDir;
    private boolean iOwner;
    private static final int MINIMAL_RECORD_SIZE = 26;
    private static final int AUTH_MODE_RO = 2;

    public FileStorage(String aStorageName) {
        this.iName = aStorageName;
        this.iReservedID = -1;
        this.iMIDletSuiteHomeDir = ApplicationInfo.getInstance().getRootPath();
        this.iOwner = true;
    }

    public void open(boolean aCreateIfNecessary, int aAuthmode, boolean aWritable) throws RecordStoreException, RecordStoreNotFoundException {
        boolean isExist;
        FileStorage.LOG("--> FileStorage.open(): " + this.iName);
        boolean bl = isExist = this._isFileExist(this.iName) == 0;
        if (!aCreateIfNecessary && !isExist) {
            FileStorage.WLOG("FileStorage.open(): record store does not exist " + this.iName);
            throw new RecordStoreNotFoundException("Record store does not exist: " + this.iName);
        }
        int ret = this._openFile(this.iName);
        if (ret == -1) {
            FileStorage.ELOG("FileStorage.open(): error open record store=" + this.iName);
            throw new RecordStoreException("Cannot open record store: " + this.iName);
        }
        this.iHeadersTable = new RecordHeadersTable();
        this.iStoreHeader = new RecordStoreHeader();
        if (!isExist) {
            FileStorage.LOG("    FileStorage.open(): new record store");
            this.iAuthMode = aWritable ? aAuthmode : aAuthmode | 2;
            this.iNextRecordStoreId = 1;
            this.iFirstRecOffset = 0;
            this.iVersion = -1;
            this.iStoreHeader.store();
        } else {
            FileStorage.LOG("    FileStorage.open(): record store exists");
            this.iStoreHeader.read();
            RecordHeader prevRec = null;
            int recordOffset = this.iFirstRecOffset;
            while (recordOffset > 0) {
                RecordHeader rec = new RecordHeader(recordOffset);
                if (!rec.isDeleted()) {
                    ++this.iNumLiveRecords;
                }
                if (prevRec != null) {
                    rec.iPrevRecId = prevRec.iRecordId;
                    prevRec.iNextRecId = rec.iRecordId;
                }
                this.iHeadersTable.put(rec);
                recordOffset = rec.getNextRecordOffset();
                prevRec = rec;
                FileStorage.LOG("    loaded record from file " + rec);
            }
            this.iLastRecord = prevRec;
        }
        FileStorage.LOG("<-- FileStorage.open()");
    }

    public void open(String aVendorName, String aSuiteName) throws RecordStoreException, RecordStoreNotFoundException, SecurityException {
        FileStorage.LOG("--> FileStorage.open()");
        String newHomedir = this.findSuiteHomeDir(aVendorName, aSuiteName);
        if (!newHomedir.equals(this.iMIDletSuiteHomeDir)) {
            this.iOwner = false;
        }
        this.iMIDletSuiteHomeDir = newHomedir;
        this.open(false, 0, true);
        if (this.iAuthMode == 0 && !this.iOwner) {
            FileStorage.WLOG("FileStorage.open(): not allowed to open record store " + this.iName + " vendor=" + aVendorName + " suite=" + aSuiteName);
            this.close();
            throw new SecurityException("Cannot open record store: " + this.iName + " " + aVendorName + " " + aSuiteName);
        }
        FileStorage.LOG("<-- FileStorage.open()");
    }

    public void close() {
        FileStorage.LOG("--> FileStorage.close(): " + this.iName);
        this._closeFile();
        FileStorage.LOG("<-- FileStorage.close()");
    }

    public void delete(String aRecordStoreName) throws RecordStoreException, RecordStoreNotFoundException {
        FileStorage.LOG("--> FileStorage.delete()" + aRecordStoreName);
        int rc = this._deleteFile(aRecordStoreName);
        FileStorage.LOG("<--FileStorage.delete()");
        if (rc != 0) {
            FileStorage.WLOG("FileStorage.delete(): not found " + aRecordStoreName);
            throw new RecordStoreNotFoundException("Record store does not exist: " + aRecordStoreName);
        }
    }

    public int getVersion() {
        return this.iVersion;
    }

    public long getLastUpdateTime() {
        return this.iLastUpdate;
    }

    public int addRecord(byte[] aData, int aOffset, int aNumBytes) throws RecordStoreException {
        return this.addRecord(aData, aOffset, aNumBytes, -1);
    }

    public int addRecord(byte[] aData, int aOffset, int aNumBytes, int aRecId) throws RecordStoreException {
        int id;
        FileStorage.LOG("--> FileStorage.addRecord() num bytes " + aNumBytes);
        this.ensureWritable();
        this.ensureFreeSpace(aNumBytes);
        if (aRecId != -1) {
            id = aRecId;
        } else if (this.iReservedID != -1) {
            id = this.iReservedID;
            this.iReservedID = -1;
        } else {
            id = this.iNextRecordStoreId++;
        }
        RecordHeader empty = this.getEmptyRecord(aNumBytes, id);
        FileStorage.LOG("    empty record: " + empty);
        if (empty != null) {
            FileStorage.LOG("    FileStorage.addRecord() empty slot: id: " + id + " offset: " + empty.iOffset);
            if (empty.iRecordId != id) {
                RecordHeader prev;
                this.iHeadersTable.remove(empty);
                RecordHeader next = empty.getSuccessor();
                if (next != null) {
                    next.iPrevRecId = id;
                }
                if ((prev = empty.getPredecessor()) != null) {
                    prev.iNextRecId = id;
                }
                empty.iRecordId = id;
                this.iHeadersTable.put(empty);
            }
            empty.iDataSize = aNumBytes;
            this.writeRecord(empty, aData, aOffset, aNumBytes);
            if (empty.iNextRecId == -1) {
                this.iLastRecord = empty;
            }
        } else {
            int offset;
            int prevRecId = this.iLastRecord == null ? -1 : this.iLastRecord.iRecordId;
            RecordHeader header = new RecordHeader(id, aNumBytes, prevRecId);
            if (this.iLastRecord != null) {
                offset = this.iLastRecord.getDataOffset() + this.iLastRecord.iTotalSize;
                this.iLastRecord.setSuccessor(offset, id);
                this.iLastRecord.updateHeader();
            } else {
                this.iFirstRecOffset = offset = 72;
            }
            header.setOffset(offset);
            this.iLastRecord = header;
            FileStorage.LOG("    FileStorage.addRecord() new slot: id: " + id + " offset: " + offset);
            this.writeRecord(header, aData, aOffset, aNumBytes);
            this.iHeadersTable.put(header);
        }
        ++this.iNumLiveRecords;
        this.iStoreHeader.store();
        FileStorage.LOG("<-- FileStorage.addRecord() record id: " + id);
        return id;
    }

    private void writeRecord(RecordHeader aHeader, byte[] aData, int aOffset, int aNumBytes) throws RecordStoreException {
        int res;
        byte[] record = new byte[aNumBytes + 16];
        System.arraycopy((Object)aHeader.getHeaderAsArray(), 0, (Object)record, 0, 16);
        if (aData != null) {
            System.arraycopy((Object)aData, aOffset, (Object)record, 16, aNumBytes);
        }
        if ((res = this._writeFile(record, 0, record.length, aHeader.iOffset)) != 0) {
            FileStorage.ELOG("FileStorage.writeRecord() failed");
            throw new RecordStoreException("Write operation failed");
        }
    }

    public int getRecord(int aRecordId, byte[] aBuffer, int aOffset) throws InvalidRecordIDException, RecordStoreException {
        FileStorage.LOG("--> FileStorage.getRecord(id, buf, offset): record id " + aRecordId);
        RecordHeader header = this.iHeadersTable.get(aRecordId);
        if (header == null || header.isDeleted()) {
            FileStorage.WLOG("FileStorage.getRecord(): invalid record id =" + aRecordId);
            throw new InvalidRecordIDException("Operation could not be completed because the record ID is invalid: " + aRecordId);
        }
        int ret = this._readFile(aBuffer, aOffset, header.iDataSize, header.getDataOffset());
        if (ret < header.iDataSize) {
            FileStorage.ELOG("FileStorage.getRecord(): Read operation could not be completed");
            throw new RecordStoreException("Read operation failed");
        }
        FileStorage.LOG("<-- FileStorage.getRecord(id, buf, offset): read " + ret + " bytes");
        return ret;
    }

    public void deleteRecord(int aRecordId) throws InvalidRecordIDException, RecordStoreException {
        this.deleteRecord(aRecordId, true);
    }

    public void deleteRecord(int aRecordId, boolean aKeepId) throws InvalidRecordIDException, RecordStoreException {
        FileStorage.LOG("--> FileStorage.deleteRecord(): record id " + aRecordId);
        this.ensureWritable();
        RecordHeader header = this.iHeadersTable.get(aRecordId);
        if (header == null || header.isDeleted()) {
            FileStorage.WLOG("FileStorage.deleteRecord(): invalid record id =" + aRecordId);
            throw new InvalidRecordIDException("Operation could not be completed because the record ID is invalid: " + aRecordId);
        }
        if (!aKeepId) {
            RecordHeader predecessor;
            this.iHeadersTable.remove(header);
            header.iRecordId = this.iNextRecordStoreId++;
            this.iHeadersTable.put(header);
            FileStorage.LOG("    FileStorage.deleteRecord(): new id for empty:" + aRecordId);
            RecordHeader successor = header.getSuccessor();
            if (successor != null) {
                successor.iPrevRecId = header.iRecordId;
            }
            if ((predecessor = header.getPredecessor()) != null) {
                predecessor.iNextRecId = header.iRecordId;
            }
        }
        header.setDeleted();
        header.updateHeader();
        --this.iNumLiveRecords;
        this.checkMerge(header);
        this.iStoreHeader.store();
        FileStorage.LOG("<-- FileStorage.deleteRecord()");
    }

    public void setRecord(int aRecordId, byte[] aNewData, int aOffset, int aNumBytes) throws InvalidRecordIDException, RecordStoreException, RecordStoreFullException {
        FileStorage.LOG("--> FileStorage.setRecord(): rec id " + aRecordId);
        this.ensureWritable();
        int oldSize = this.getRecordSize(aRecordId);
        int spaceRequired = aNumBytes - oldSize;
        spaceRequired = spaceRequired > 0 ? spaceRequired : 0;
        this.ensureFreeSpace(spaceRequired);
        RecordHeader header = this.iHeadersTable.get(aRecordId);
        if (header == null) {
            FileStorage.WLOG("FileStorage.setRecord(): invalid record id =" + aRecordId);
            throw new InvalidRecordIDException("Operation could not be completed because the record ID is invalid: " + aRecordId);
        }
        if (header.iTotalSize >= aNumBytes) {
            header.iDataSize = aNumBytes;
            this.writeRecord(header, aNewData, aOffset, aNumBytes);
            this.iStoreHeader.store();
        } else {
            this.deleteRecord(aRecordId, false);
            this.addRecord(aNewData, aOffset, aNumBytes, aRecordId);
        }
        FileStorage.LOG("<-- FileStorage.setRecord()");
    }

    public int getNumRecords() {
        return this.iNumLiveRecords;
    }

    public void setMode(int aAuthmode, boolean aWritable) throws RecordStoreException {
        if (!this.iOwner) {
            FileStorage.WLOG("FileStorage.setMode(): not allowed");
            throw new SecurityException("Only read operations allowed");
        }
        this.iAuthMode = aWritable ? aAuthmode : aAuthmode | 2;
        this.iStoreHeader.store();
    }

    public int getSize() {
        int size = this._getSize();
        FileStorage.LOG("<-->FileStorage.getSize(): size = " + size);
        return size;
    }

    public int getSizeAvailable() {
        int sizeAvail = this._getSizeAvailable();
        FileStorage.LOG("<-->FileStorage.getSizeAvailable(): available size = " + sizeAvail);
        return sizeAvail;
    }

    public int getRecordSize(int aRecordId) throws InvalidRecordIDException, RecordStoreException {
        RecordHeader header = this.iHeadersTable.get(aRecordId);
        if (header == null || header.isDeleted()) {
            FileStorage.WLOG("FileStorage.getRecordSize(): invalid record id=" + aRecordId);
            throw new InvalidRecordIDException("Operation could not be completed because the record ID is invalid: " + aRecordId);
        }
        FileStorage.LOG("<-->FileStorage.getRecordSize(): rec id = " + aRecordId + " size = " + header.iDataSize);
        return header.iDataSize;
    }

    public int getNextRecordID() throws RecordStoreException {
        if (this.iReservedID != -1) {
            return this.iReservedID;
        }
        int nextId = this.iReservedID = this.iNextRecordStoreId++;
        FileStorage.LOG("<-->FileStorage.getNextRecordID(): next id = " + nextId);
        return nextId;
    }

    public String[] listRecordStores() {
        return this._listRecordStores();
    }

    public int[] getRecordIDs() {
        int[] records = new int[this.iNumLiveRecords];
        int i = 0;
        for (RecordHeader header = this.iLastRecord; header != null; header = header.getPredecessor()) {
            if (header.isDeleted()) continue;
            records[i++] = header.iRecordId;
        }
        return records;
    }

    private RecordHeader getEmptyRecord(int aNumBytes, int aNewRecId) throws RecordStoreException {
        RecordHeader header;
        FileStorage.LOG("    getEmptyRecord(), bytes " + aNumBytes + " new rec id " + aNewRecId);
        for (header = this.iLastRecord; !(header == null || header.isDeleted() && header.iTotalSize >= aNumBytes); header = header.getPredecessor()) {
        }
        if (header != null) {
            return this.splitRecord(header, aNumBytes, aNewRecId);
        }
        return null;
    }

    private RecordHeader splitRecord(RecordHeader aRecToSplit, int aNumDataBytes, int aNewRecID) throws RecordStoreException {
        FileStorage.LOG("splitRecord(): num bytes needed " + aNumDataBytes + " new rec id " + aNewRecID);
        FileStorage.LOG("splitRecord(): record to split: " + aRecToSplit);
        if (aRecToSplit.getRecordFullSize() < aNumDataBytes + 16 + 26) {
            return aRecToSplit;
        }
        RecordHeader newRec = new RecordHeader(aNewRecID, aNumDataBytes, aRecToSplit.iRecordId);
        newRec.setSuccessor(aRecToSplit.getNextRecordOffset(), aRecToSplit.iNextRecId);
        int newRecOffset = aRecToSplit.getDataOffset() + aRecToSplit.iTotalSize - aNumDataBytes - 16;
        newRec.setOffset(newRecOffset);
        newRec.iTotalSize = aNumDataBytes;
        newRec.updateHeader();
        FileStorage.LOG("splitRecord(): new record " + newRec);
        this.iHeadersTable.put(newRec);
        RecordHeader successor = aRecToSplit.getSuccessor();
        if (successor != null) {
            successor.iPrevRecId = aNewRecID;
        }
        aRecToSplit.iTotalSize -= newRec.getRecordFullSize();
        aRecToSplit.setSuccessor(newRecOffset, aNewRecID);
        aRecToSplit.updateHeader();
        FileStorage.LOG("splitRecord(): modified record to split" + aRecToSplit);
        return newRec;
    }

    private void checkMerge(RecordHeader aCandidate) throws RecordStoreException {
        RecordHeader leftNeighbour;
        RecordHeader rightNeighbour = aCandidate.getSuccessor();
        if (rightNeighbour != null && rightNeighbour.isDeleted()) {
            this.mergeRecords(aCandidate, rightNeighbour);
        }
        if ((leftNeighbour = aCandidate.getPredecessor()) != null && leftNeighbour.isDeleted()) {
            this.mergeRecords(leftNeighbour, aCandidate);
            if (this.iLastRecord == leftNeighbour) {
                this.removeRecord(leftNeighbour);
            }
        }
        if (this.iLastRecord == aCandidate) {
            this.removeRecord(aCandidate);
        }
    }

    private void mergeRecords(RecordHeader aLeft, RecordHeader aRight) throws RecordStoreException {
        FileStorage.LOG("mergeRecords(): left neighbour to merge " + aLeft);
        FileStorage.LOG("mergeRecords(): right neighbour to merge " + aRight);
        aLeft.setSuccessor(aRight.getNextRecordOffset(), aRight.iNextRecId);
        RecordHeader successor = aLeft.getSuccessor();
        if (successor != null) {
            successor.iPrevRecId = aLeft.iRecordId;
        }
        aLeft.iTotalSize += aRight.getRecordFullSize();
        aLeft.updateHeader();
        this.iHeadersTable.remove(aRight);
        FileStorage.LOG("mergeRecords(): results of merge " + aLeft);
        if (aRight.iNextRecId == -1) {
            this.iLastRecord = aLeft;
        }
    }

    private void removeRecord(RecordHeader aRec) throws RecordStoreException {
        FileStorage.LOG("    removeRecord(): record to remove from file: " + aRec);
        RecordHeader leftNeighbour = aRec.getPredecessor();
        if (leftNeighbour != null) {
            leftNeighbour.setSuccessor(-1, -1);
            leftNeighbour.updateHeader();
        }
        this.iLastRecord = leftNeighbour;
        this.iHeadersTable.remove(aRec);
        int recFullSize = aRec.getRecordFullSize();
        int ret = this._truncateFile(this._getSize() - recFullSize);
        if (ret == -1) {
            FileStorage.ELOG("FileStorage.removeRecord(): error when truncate record store");
            throw new RecordStoreException("Resize operation failed");
        }
        if (this.iFirstRecOffset == aRec.iOffset) {
            this.iFirstRecOffset = 0;
        }
    }

    private static void setInt(int aValue, byte[] aData, int aOffset) {
        aData[aOffset++] = (byte)(aValue >> 24 & 0xFF);
        aData[aOffset++] = (byte)(aValue >> 16 & 0xFF);
        aData[aOffset++] = (byte)(aValue >> 8 & 0xFF);
        aData[aOffset] = (byte)(aValue & 0xFF);
    }

    private static void setLong(long aValue, byte[] aData, int aOffset) {
        aData[aOffset++] = (byte)(aValue >> 56 & 0xFFL);
        aData[aOffset++] = (byte)(aValue >> 48 & 0xFFL);
        aData[aOffset++] = (byte)(aValue >> 40 & 0xFFL);
        aData[aOffset++] = (byte)(aValue >> 32 & 0xFFL);
        aData[aOffset++] = (byte)(aValue >> 24 & 0xFFL);
        aData[aOffset++] = (byte)(aValue >> 16 & 0xFFL);
        aData[aOffset++] = (byte)(aValue >> 8 & 0xFFL);
        aData[aOffset] = (byte)(aValue & 0xFFL);
    }

    private static int getInt(byte[] aData, int aOffset) {
        int i = (aData[aOffset++] & 0xFF) << 24 | (aData[aOffset++] & 0xFF) << 16 | (aData[aOffset++] & 0xFF) << 8 | aData[aOffset] & 0xFF;
        return i;
    }

    private static long getLong(byte[] aData, int aOffset) {
        long l = ((long)aData[aOffset++] & 0xFFL) << 56 | ((long)aData[aOffset++] & 0xFFL) << 48 | ((long)aData[aOffset++] & 0xFFL) << 40 | ((long)aData[aOffset++] & 0xFFL) << 32 | ((long)aData[aOffset++] & 0xFFL) << 24 | ((long)aData[aOffset++] & 0xFFL) << 16 | ((long)aData[aOffset++] & 0xFFL) << 8 | (long)aData[aOffset] & 0xFFL;
        return l;
    }

    private static void LOG(String aStr) {
        Logger.LOG(5, 4, aStr);
    }

    private static void WLOG(String aStr) {
        Logger.WLOG(5, aStr);
    }

    private static void ELOG(String aStr) {
        Logger.ELOG(5, aStr);
    }

    private void ensureWritable() throws SecurityException {
        if (this.iOwner) {
            return;
        }
        if (this.iAuthMode != 1) {
            FileStorage.WLOG("FileStorage.ensureWritable(): throwing SecurityException");
            throw new SecurityException("Only read operations allowed");
        }
    }

    private void ensureFreeSpace(int aSize) throws RecordStoreFullException {
        int available = this.getSizeAvailable();
        if (available - aSize < 0) {
            FileStorage.WLOG("FileStorage.ensureFreeSpace(): record store full: available=" + available + " required=" + aSize);
            throw new RecordStoreFullException("Record store maximum size reached");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String findSuiteHomeDir(String aVendorName, String aSuiteName) throws RecordStoreNotFoundException {
        FileStorage.LOG("    FileStorage.findSuiteHomeDir()");
        StorageSession session = null;
        String suiteHomeDir = "";
        try {
            StorageAttribute attr = new StorageAttribute("PACKAGE_NAME", aSuiteName);
            StorageEntry query = new StorageEntry();
            query.addAttribute(attr);
            attr = new StorageAttribute("VENDOR", aVendorName);
            query.addAttribute(attr);
            attr = new StorageAttribute("ROOT_PATH", "");
            query.addAttribute(attr);
            session = StorageFactory.createSession();
            session.open();
            StorageEntry[] receivedEntries = session.search("APPLICATION_PACKAGE", query);
            if (receivedEntries == null || receivedEntries.length == 0) {
                FileStorage.WLOG("FileStorage.findSuiteHomeDir(): MIDlet suite does not exist: " + aVendorName + " " + aSuiteName);
                throw new RecordStoreNotFoundException("Cannot open record store: " + this.iName + " " + aVendorName + " " + aSuiteName);
            }
            suiteHomeDir = receivedEntries[0].getAttribute("ROOT_PATH").getValue();
        }
        catch (StorageException se) {
            FileStorage.ELOG("FileStorage.findSuiteHomeDir(): StorageException " + se.toString());
        }
        finally {
            if (session != null) {
                session.close();
                session.destroySession();
            }
        }
        FileStorage.LOG("    FileStorage.findSuiteHomeDir() suiteHomeDir=" + suiteHomeDir);
        return suiteHomeDir;
    }

    private static native void _init(String var0);

    private native int _isFileExist(String var1);

    private native int _deleteFile(String var1);

    private native int _openFile(String var1);

    private native int _closeFile();

    private native int _writeFile(byte[] var1, int var2, int var3, int var4);

    private native int _readFile(byte[] var1, int var2, int var3, int var4);

    private native int _getSize();

    private native int _getSizeAvailable();

    private native int _truncateFile(int var1);

    private native String[] _listRecordStores();

    static {
        Jvm.loadSystemLibrary("javarms");
        FileStorage._init(ApplicationInfo.getInstance().getRootPath());
    }

    private class RecordHeader {
        private static final int RECORD_ID = 0;
        private static final int NEXT_RECORD_OFFSET = 4;
        private static final int RECORD_SIZE = 8;
        private static final int RECORD_DATA_SIZE = 12;
        private static final int RECORD_HEADER_SIZE = 16;
        int iOffset;
        int iRecordId;
        int iTotalSize;
        int iDataSize;
        int iNextRecOffset;
        int iNextRecId;
        int iPrevRecId;

        public RecordHeader(int aOffset) throws RecordStoreException {
            byte[] header = new byte[16];
            this.iOffset = aOffset;
            this.iPrevRecId = -1;
            this.iNextRecId = -1;
            int ret = FileStorage.this._readFile(header, 0, 16, this.iOffset);
            if (ret < 16) {
                FileStorage.ELOG("RecordHeader.RecordHeader failed");
                throw new RecordStoreException("Read operation failed");
            }
            this.iRecordId = FileStorage.getInt(header, 0);
            this.iNextRecOffset = FileStorage.getInt(header, 4);
            this.iTotalSize = FileStorage.getInt(header, 8);
            this.iDataSize = FileStorage.getInt(header, 12);
        }

        public RecordHeader(int aRecId, int aDataSize, int aPrevRecId) {
            this.iOffset = 0;
            this.iRecordId = aRecId;
            this.iTotalSize = aDataSize;
            this.iDataSize = aDataSize;
            this.iNextRecOffset = 0;
            this.iNextRecId = -1;
            this.iPrevRecId = aPrevRecId;
        }

        public byte[] getHeaderAsArray() {
            byte[] header = new byte[16];
            FileStorage.setInt(this.iRecordId, header, 0);
            FileStorage.setInt(this.iNextRecOffset, header, 4);
            FileStorage.setInt(this.iTotalSize, header, 8);
            FileStorage.setInt(this.iDataSize, header, 12);
            return header;
        }

        public void setOffset(int aOffset) {
            this.iOffset = aOffset;
        }

        public void setSuccessor(int aNextRecOffset, int aNextRecId) {
            FileStorage.LOG("    RecordHeader.setSuccessor(): next rec offset " + aNextRecOffset + " next rec id: " + aNextRecId);
            this.iNextRecOffset = aNextRecOffset;
            this.iNextRecId = aNextRecId;
        }

        public void updateHeader() throws RecordStoreException {
            FileStorage.LOG("    RecordHeader.updateHeader(): " + this);
            byte[] header = this.getHeaderAsArray();
            int ret = FileStorage.this._writeFile(header, 0, header.length, this.iOffset);
            if (ret != 0) {
                FileStorage.ELOG("FileStore.updateHeader() failed");
                throw new RecordStoreException("Write operation failed");
            }
        }

        public RecordHeader getSuccessor() {
            if (this.iNextRecId != -1) {
                return FileStorage.this.iHeadersTable.get(this.iNextRecId);
            }
            return null;
        }

        public RecordHeader getPredecessor() {
            if (this.iPrevRecId != -1) {
                return FileStorage.this.iHeadersTable.get(this.iPrevRecId);
            }
            return null;
        }

        public int getNextRecordOffset() {
            return this.iNextRecOffset;
        }

        public int getDataOffset() {
            return this.iOffset + 16;
        }

        public boolean isDeleted() {
            return this.iDataSize == -1;
        }

        public void setDeleted() {
            this.iDataSize = -1;
        }

        public String toString() {
            return "RecordHeader, id=" + this.iRecordId + " data size=" + this.iDataSize + " total size=" + this.iTotalSize + " offset=" + this.iOffset + " next rec offset=" + this.iNextRecOffset + " next id=" + this.iNextRecId + " prev id=" + this.iPrevRecId;
        }

        public int getRecordFullSize() {
            return this.iTotalSize + 16;
        }
    }

    private static class RecordHeadersTable {
        private Hashtable iTable = new Hashtable();

        public void put(RecordHeader aHeader) {
            this.iTable.put(new Integer(aHeader.iRecordId), aHeader);
        }

        public RecordHeader get(int aRecordId) {
            Integer key = new Integer(aRecordId);
            RecordHeader header = (RecordHeader)this.iTable.get(key);
            return header;
        }

        public void remove(RecordHeader aHeader) {
            this.iTable.remove(new Integer(aHeader.iRecordId));
        }
    }

    private class RecordStoreHeader {
        private static final int SIGNATURE_OFFSET = 0;
        private static final int RS_FORMAT_VERSION_OFFSET = 8;
        private static final int AUTHMODE_OFFSET = 36;
        private static final int VERSION_OFFSET = 40;
        private static final int NEXT_REC_ID = 44;
        private static final int FIRST_RECORD_OFFSET = 48;
        private static final int UPDATE_OFFSET = 56;
        private static final int HEADER_SIZE = 72;
        private static final String SIGNATURE = "rms-file";
        private static final int RECORDSTORE_FORMAT_VERSION = 1;

        private RecordStoreHeader() {
        }

        public void store() throws RecordStoreException {
            FileStorage.this.iLastUpdate = System.currentTimeMillis();
            FileStorage.this.iVersion++;
            FileStorage.LOG("    RecordStoreHeader.store(): signature=rms-file format version=1 version=" + FileStorage.this.iVersion + " auth mode=" + FileStorage.this.iAuthMode + " next rec id=" + FileStorage.this.iNextRecordStoreId + " first rec offset=" + FileStorage.this.iFirstRecOffset + " time=" + FileStorage.this.iLastUpdate);
            byte[] header = new byte[72];
            byte[] sign = SIGNATURE.getBytes();
            System.arraycopy((Object)sign, 0, (Object)header, 0, sign.length);
            FileStorage.setInt(1, header, 8);
            FileStorage.setInt(FileStorage.this.iVersion, header, 40);
            FileStorage.setInt(FileStorage.this.iAuthMode, header, 36);
            FileStorage.setInt(FileStorage.this.iNextRecordStoreId, header, 44);
            FileStorage.setInt(FileStorage.this.iFirstRecOffset, header, 48);
            FileStorage.setLong(FileStorage.this.iLastUpdate, header, 56);
            int ret = FileStorage.this._writeFile(header, 0, header.length, 0);
            if (ret != 0) {
                FileStorage.ELOG("RecordStoreHeader.store() failed");
                throw new RecordStoreException("Write operation failed");
            }
        }

        public void read() throws RecordStoreException {
            byte[] header = new byte[72];
            int ret = FileStorage.this._readFile(header, 0, 72, 0);
            if (ret < 72) {
                FileStorage.ELOG("RecordStoreHeader.read() failed");
                throw new RecordStoreException("Read operation failed");
            }
            FileStorage.this.iVersion = FileStorage.getInt(header, 40);
            FileStorage.this.iAuthMode = FileStorage.getInt(header, 36);
            FileStorage.this.iNextRecordStoreId = FileStorage.getInt(header, 44);
            FileStorage.this.iFirstRecOffset = FileStorage.getInt(header, 48);
            FileStorage.this.iLastUpdate = FileStorage.getLong(header, 56);
            int format = FileStorage.getInt(header, 8);
            String sign = new String(header, 0, SIGNATURE.length());
            FileStorage.LOG("    RecordStoreHeader.read(): signature=" + sign + " format version=" + format + " version=" + FileStorage.this.iVersion + " auth mode=" + FileStorage.this.iAuthMode + " next rec id=" + FileStorage.this.iNextRecordStoreId + " first rec offset=" + FileStorage.this.iFirstRecOffset + " time=" + FileStorage.this.iLastUpdate);
            if (sign.compareTo(SIGNATURE) != 0 || format != 1) {
                FileStorage.WLOG("Wrong record store file format: signature =" + sign + " : file format version =" + format);
                this.doConversion();
            }
        }

        private void doConversion() throws RecordStoreException {
            FileStorage.LOG("--> doConversion()");
            RecordHeader prevRec = null;
            int recordOffset = FileStorage.this.iFirstRecOffset;
            while (recordOffset > 0) {
                FileStorage.LOG("recordOffset=" + recordOffset);
                RecordHeader rec = new RecordHeader(recordOffset);
                recordOffset = rec.getNextRecordOffset();
                FileStorage.LOG("    ->prevRec =" + prevRec);
                FileStorage.LOG("    ->rec     =" + rec);
                if (rec.iRecordId == -1) {
                    rec.iDataSize = -1;
                }
                rec.iTotalSize -= 16;
                if (prevRec != null) {
                    if (prevRec.isDeleted()) {
                        FileStorage.LOG("    merging:" + prevRec);
                        FileStorage.LOG("        to: " + rec);
                        rec.setSuccessor(prevRec.getNextRecordOffset(), prevRec.iNextRecId);
                        rec.iTotalSize += prevRec.getRecordFullSize();
                        FileStorage.LOG("    result: " + rec);
                    } else {
                        prevRec.iPrevRecId = rec.iRecordId;
                        rec.setSuccessor(prevRec.iOffset, prevRec.iRecordId);
                        this.updateHeader(prevRec);
                    }
                } else {
                    rec.iNextRecOffset = 0;
                    rec.iNextRecId = -1;
                }
                FileStorage.LOG("    <-prevRec =" + prevRec);
                FileStorage.LOG("    <-rec     =" + rec);
                prevRec = rec;
            }
            if (prevRec != null) {
                this.updateHeader(prevRec);
            }
            FileStorage.this.iFirstRecOffset = prevRec != null ? prevRec.iOffset : 0;
            FileStorage.LOG("    first record=" + prevRec);
            this.store();
            FileStorage.LOG("<-- doConversion()");
        }

        private void updateHeader(RecordHeader aHeader) throws RecordStoreException {
            RecordHeader temp = new RecordHeader(aHeader.iOffset);
            while (aHeader.getNextRecordOffset() != temp.getNextRecordOffset()) {
                FileStorage.WLOG("    rewriting the record: " + aHeader);
                aHeader.updateHeader();
                temp = new RecordHeader(aHeader.iOffset);
            }
        }
    }
}

