/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.rt;

import com.nokia.mj.impl.rt.DynamicProperty;
import com.nokia.mj.impl.rt.DynamicPropertyInfo;
import com.nokia.mj.impl.rt.support.SystemPropertyProvider;
import com.nokia.mj.impl.utils.Logger;
import java.util.Hashtable;

class SystemPropertyUtils {
    private static final String PROPERTY_HANDLER_CLASS_PREFIX = "com.nokia.mj.impl.properties.";
    private static final String PROPERTY_HANDLER_LEGACY_CLASS_PREFIX = "com.nokia.mj.impl.rt.properties.";

    SystemPropertyUtils() {
    }

    public static Object solvePropertyValue(Object propertyName, Object propertyValue, Hashtable systemProperties) {
        if (!(propertyName instanceof String) || !(propertyValue instanceof String)) {
            return propertyValue;
        }
        String propertyNameStr = (String)propertyName;
        String propertyValueStr = (String)propertyValue;
        try {
            if (propertyValueStr != null && propertyValueStr.length() > 0 && propertyValueStr.charAt(0) == ':') {
                if (propertyValueStr.length() > 1 && propertyValueStr.charAt(1) == ':') {
                    return propertyValueStr.substring(1);
                }
                String classEnding = propertyValueStr.substring(1);
                String className = PROPERTY_HANDLER_CLASS_PREFIX + classEnding;
                try {
                    Class clazz = null;
                    try {
                        clazz = Class.forName(className);
                    }
                    catch (ClassNotFoundException e) {
                        className = PROPERTY_HANDLER_LEGACY_CLASS_PREFIX + classEnding;
                        clazz = Class.forName(className);
                    }
                    Object providerImpl = clazz.newInstance();
                    boolean isFrozen = false;
                    if (providerImpl instanceof SystemPropertyProvider) {
                        SystemPropertyProvider systemPropertyProvider = (SystemPropertyProvider)providerImpl;
                        propertyValueStr = systemPropertyProvider.getProperty(propertyNameStr);
                        isFrozen = systemPropertyProvider.isStatic(propertyNameStr);
                    } else {
                        DynamicProperty systemPropertyProvider = (DynamicProperty)providerImpl;
                        DynamicPropertyInfo info = new DynamicPropertyInfo(propertyNameStr);
                        systemPropertyProvider.getProperty(info);
                        propertyValueStr = info.getPropertyValue();
                        isFrozen = info.getIsPropertyValueStatic();
                    }
                    if (propertyValueStr != null && isFrozen) {
                        systemProperties.put(propertyNameStr, propertyValueStr);
                    }
                    return propertyValueStr;
                }
                catch (ClassNotFoundException e) {
                    Logger.ELOG(6, "Dynamic property handler " + className + " was not found for " + propertyName);
                    return "";
                }
            }
            return propertyValueStr;
        }
        catch (Throwable t) {
            Logger.ELOG(6, "Error in system properties: Key=" + propertyNameStr + ", Val ='" + propertyValueStr, t);
            return "";
        }
    }
}

